/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.utils;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import lombok.Generated;

public final class Absolute {
    public static URI uri(String uri) {
        return Absolute.uri(URI.create(uri));
    }

    public static URI uri(URI uri) {
        URI decodedUri = URI.create(uri.getScheme() + ":" + uri.getSchemeSpecificPart().replace(" ", "%20"));
        if ("file".equals(decodedUri.getScheme()) && decodedUri.getAuthority() == null) {
            return Absolute.path(new File(decodedUri)).toUri();
        }
        return decodedUri;
    }

    public static URI uri(File file) {
        return Absolute.uri(Absolute.path(file).toUri());
    }

    public static Path path(String path) {
        return Absolute.path(Path.of(path, new String[0]));
    }

    public static Path path(URI uri) {
        return Absolute.path(Path.of(Absolute.uri(uri)));
    }

    public static Path path(Path path) {
        return Absolute.path(path.toFile());
    }

    public static Path path(File file) {
        return file.getCanonicalFile().toPath().toAbsolutePath();
    }

    @Generated
    private Absolute() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

