/*
 * Decompiled with CFR 0.152.
 */
package cn.hzw.doodle;

import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import cn.forward.androids.TouchGestureDetector;
import cn.forward.androids.utils.ImageUtils;
import cn.forward.androids.utils.LogUtil;
import cn.forward.androids.utils.StatusBarUtil;
import cn.forward.androids.utils.Util;
import cn.hzw.doodle.DoodleBitmap;
import cn.hzw.doodle.DoodleColor;
import cn.hzw.doodle.DoodleOnTouchGestureListener;
import cn.hzw.doodle.DoodleParams;
import cn.hzw.doodle.DoodlePath;
import cn.hzw.doodle.DoodlePen;
import cn.hzw.doodle.DoodleShape;
import cn.hzw.doodle.DoodleText;
import cn.hzw.doodle.DoodleTouchDetector;
import cn.hzw.doodle.DoodleView;
import cn.hzw.doodle.IDoodleListener;
import cn.hzw.doodle.R;
import cn.hzw.doodle.core.IDoodle;
import cn.hzw.doodle.core.IDoodleColor;
import cn.hzw.doodle.core.IDoodleItemListener;
import cn.hzw.doodle.core.IDoodlePen;
import cn.hzw.doodle.core.IDoodleSelectableItem;
import cn.hzw.doodle.core.IDoodleShape;
import cn.hzw.doodle.core.IDoodleTouchDetector;
import cn.hzw.doodle.dialog.ColorPickerDialog;
import cn.hzw.doodle.dialog.DialogController;
import cn.hzw.doodle.imagepicker.ImageSelectorView;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DoodleActivity
extends Activity {
    public static final String TAG = "Doodle";
    public static final int DEFAULT_MOSAIC_SIZE = 20;
    public static final int DEFAULT_COPY_SIZE = 20;
    public static final int DEFAULT_TEXT_SIZE = 18;
    public static final int DEFAULT_BITMAP_SIZE = 80;
    public static final int RESULT_ERROR = -111;
    public static final String KEY_PARAMS = "key_doodle_params";
    public static final String KEY_IMAGE_PATH = "key_image_path";
    private String mImagePath;
    private FrameLayout mFrameLayout;
    private IDoodle mDoodle;
    private DoodleView mDoodleView;
    private TextView mPaintSizeView;
    private View mBtnHidePanel;
    private View mSettingsPanel;
    private View mSelectedEditContainer;
    private TextView mItemScaleTextView;
    private View mBtnColor;
    private View mColorContainer;
    private SeekBar mEditSizeSeekBar;
    private View mShapeContainer;
    private View mPenContainer;
    private View mSizeContainer;
    private View mBtnUndo;
    private View mMosaicMenu;
    private View mEditBtn;
    private AlphaAnimation mViewShowAnimation;
    private AlphaAnimation mViewHideAnimation;
    private DoodleParams mDoodleParams;
    private Runnable mHideDelayRunnable;
    private Runnable mShowDelayRunnable;
    private DoodleOnTouchGestureListener mTouchGestureListener;
    private Map<IDoodlePen, Float> mPenSizeMap = new HashMap<IDoodlePen, Float>();
    private int mMosaicLevel = -1;
    private ValueAnimator mRotateAnimator;

    public static void startActivityForResult(Activity activity, DoodleParams params, int requestCode) {
        Intent intent = new Intent((Context)activity, DoodleActivity.class);
        intent.putExtra(KEY_PARAMS, (Parcelable)params);
        activity.startActivityForResult(intent, requestCode);
    }

    @Deprecated
    public static void startActivityForResult(Activity activity, String imagePath, String savePath, boolean isDir, int requestCode) {
        DoodleParams params = new DoodleParams();
        params.mImagePath = imagePath;
        params.mSavePath = savePath;
        params.mSavePathIsDir = isDir;
        DoodleActivity.startActivityForResult(activity, params, requestCode);
    }

    @Deprecated
    public static void startActivityForResult(Activity activity, String imagePath, int requestCode) {
        DoodleParams params = new DoodleParams();
        params.mImagePath = imagePath;
        DoodleActivity.startActivityForResult(activity, params, requestCode);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable(KEY_PARAMS, (Parcelable)this.mDoodleParams);
    }

    public void onRestoreInstanceState(Bundle savedInstanceState, PersistableBundle persistentState) {
        super.onRestoreInstanceState(savedInstanceState, persistentState);
        this.mDoodleParams = (DoodleParams)savedInstanceState.getParcelable(KEY_PARAMS);
    }

    public void onCreate(Bundle savedInstanceState) {
        Bitmap bitmap;
        super.onCreate(savedInstanceState);
        StatusBarUtil.setStatusBarTranslucent((Activity)this, (boolean)true, (boolean)false);
        if (this.mDoodleParams == null) {
            this.mDoodleParams = (DoodleParams)this.getIntent().getExtras().getParcelable(KEY_PARAMS);
        }
        if (this.mDoodleParams == null) {
            LogUtil.e((String)"TAG", (String)"mDoodleParams is null!");
            this.finish();
            return;
        }
        this.mImagePath = this.mDoodleParams.mImagePath;
        if (this.mImagePath == null) {
            LogUtil.e((String)"TAG", (String)"mImagePath is null!");
            this.finish();
            return;
        }
        LogUtil.d((String)"TAG", (String)this.mImagePath);
        if (this.mDoodleParams.mIsFullScreen) {
            this.getWindow().setFlags(1024, 1024);
        }
        if ((bitmap = ImageUtils.createBitmapFromPath((String)this.mImagePath, (Context)this)) == null) {
            LogUtil.e((String)"TAG", (String)"bitmap is null!");
            this.finish();
            return;
        }
        this.requestWindowFeature(1);
        this.setContentView(R.layout.doodle_layout);
        this.mFrameLayout = (FrameLayout)this.findViewById(R.id.doodle_container);
        this.mDoodleView = new DoodleViewWrapper((Context)this, bitmap, this.mDoodleParams.mOptimizeDrawing, new IDoodleListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSaved(IDoodle doodle, Bitmap bitmap, Runnable callback) {
                File doodleFile = null;
                File file = null;
                String savePath = ((DoodleActivity)DoodleActivity.this).mDoodleParams.mSavePath;
                boolean isDir = ((DoodleActivity)DoodleActivity.this).mDoodleParams.mSavePathIsDir;
                if (TextUtils.isEmpty((CharSequence)savePath)) {
                    File dcimFile = new File(Environment.getExternalStorageDirectory(), "DCIM");
                    doodleFile = new File(dcimFile, DoodleActivity.TAG);
                    file = new File(doodleFile, System.currentTimeMillis() + ".jpg");
                } else if (isDir) {
                    doodleFile = new File(savePath);
                    file = new File(doodleFile, System.currentTimeMillis() + ".jpg");
                } else {
                    file = new File(savePath);
                    doodleFile = file.getParentFile();
                }
                doodleFile.mkdirs();
                FileOutputStream outputStream = null;
                try {
                    outputStream = new FileOutputStream(file);
                    bitmap.compress(Bitmap.CompressFormat.JPEG, 95, (OutputStream)outputStream);
                    ImageUtils.addImage((ContentResolver)DoodleActivity.this.getContentResolver(), (String)file.getAbsolutePath());
                    Intent intent = new Intent();
                    intent.putExtra(DoodleActivity.KEY_IMAGE_PATH, file.getAbsolutePath());
                    DoodleActivity.this.setResult(-1, intent);
                    DoodleActivity.this.finish();
                }
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                        this.onError(-2, e.getMessage());
                    }
                    catch (Throwable throwable) {
                        Util.closeQuietly(outputStream);
                        throw throwable;
                    }
                    Util.closeQuietly((Closeable)outputStream);
                }
                Util.closeQuietly((Closeable)outputStream);
            }

            public void onError(int i, String msg) {
                DoodleActivity.this.setResult(-111);
                DoodleActivity.this.finish();
            }

            @Override
            public void onReady(IDoodle doodle) {
                float size;
                DoodleActivity.this.mEditSizeSeekBar.setMax(Math.min(DoodleActivity.this.mDoodleView.getWidth(), DoodleActivity.this.mDoodleView.getHeight()));
                float f = size = ((DoodleActivity)DoodleActivity.this).mDoodleParams.mPaintUnitSize > 0.0f ? ((DoodleActivity)DoodleActivity.this).mDoodleParams.mPaintUnitSize * DoodleActivity.this.mDoodle.getUnitSize() : 0.0f;
                if (size <= 0.0f) {
                    size = ((DoodleActivity)DoodleActivity.this).mDoodleParams.mPaintPixelSize > 0.0f ? ((DoodleActivity)DoodleActivity.this).mDoodleParams.mPaintPixelSize : DoodleActivity.this.mDoodle.getSize();
                }
                DoodleActivity.this.mDoodle.setSize(size);
                DoodleActivity.this.mDoodle.setPen(DoodlePen.BRUSH);
                DoodleActivity.this.mDoodle.setShape(DoodleShape.HAND_WRITE);
                DoodleActivity.this.mDoodle.setColor(new DoodleColor(((DoodleActivity)DoodleActivity.this).mDoodleParams.mPaintColor));
                if (((DoodleActivity)DoodleActivity.this).mDoodleParams.mZoomerScale <= 0.0f) {
                    DoodleActivity.this.findViewById(R.id.btn_zoomer).setVisibility(8);
                }
                DoodleActivity.this.mDoodle.setZoomerScale(((DoodleActivity)DoodleActivity.this).mDoodleParams.mZoomerScale);
                DoodleActivity.this.mTouchGestureListener.setSupportScaleItem(((DoodleActivity)DoodleActivity.this).mDoodleParams.mSupportScaleItem);
                DoodleActivity.this.mPenSizeMap.put(DoodlePen.BRUSH, Float.valueOf(DoodleActivity.this.mDoodle.getSize()));
                DoodleActivity.this.mPenSizeMap.put(DoodlePen.MOSAIC, Float.valueOf(20.0f * DoodleActivity.this.mDoodle.getUnitSize()));
                DoodleActivity.this.mPenSizeMap.put(DoodlePen.COPY, Float.valueOf(20.0f * DoodleActivity.this.mDoodle.getUnitSize()));
                DoodleActivity.this.mPenSizeMap.put(DoodlePen.ERASER, Float.valueOf(DoodleActivity.this.mDoodle.getSize()));
                DoodleActivity.this.mPenSizeMap.put(DoodlePen.TEXT, Float.valueOf(18.0f * DoodleActivity.this.mDoodle.getUnitSize()));
                DoodleActivity.this.mPenSizeMap.put(DoodlePen.BITMAP, Float.valueOf(80.0f * DoodleActivity.this.mDoodle.getUnitSize()));
            }
        }, null);
        this.mDoodle = this.mDoodleView;
        this.mTouchGestureListener = new DoodleOnTouchGestureListener(this.mDoodleView, new DoodleOnTouchGestureListener.ISelectionListener(){
            IDoodlePen mLastPen = null;
            IDoodleColor mLastColor = null;
            Float mSize = null;
            IDoodleItemListener mIDoodleItemListener = new IDoodleItemListener(){

                @Override
                public void onPropertyChanged(int property) {
                    if (DoodleActivity.this.mTouchGestureListener.getSelectedItem() == null) {
                        return;
                    }
                    if (property == 1) {
                        DoodleActivity.this.mItemScaleTextView.setText((CharSequence)((int)(DoodleActivity.this.mTouchGestureListener.getSelectedItem().getScale() * 100.0f + 0.5f) + "%"));
                    }
                }
            };

            @Override
            public void onSelectedItem(IDoodle doodle, IDoodleSelectableItem selectableItem, boolean selected) {
                if (selected) {
                    if (this.mLastPen == null) {
                        this.mLastPen = DoodleActivity.this.mDoodle.getPen();
                    }
                    if (this.mLastColor == null) {
                        this.mLastColor = DoodleActivity.this.mDoodle.getColor();
                    }
                    if (this.mSize == null) {
                        this.mSize = Float.valueOf(DoodleActivity.this.mDoodle.getSize());
                    }
                    DoodleActivity.this.mDoodleView.setEditMode(true);
                    DoodleActivity.this.mDoodle.setPen(selectableItem.getPen());
                    DoodleActivity.this.mDoodle.setColor(selectableItem.getColor());
                    DoodleActivity.this.mDoodle.setSize(selectableItem.getSize());
                    DoodleActivity.this.mEditSizeSeekBar.setProgress((int)selectableItem.getSize());
                    DoodleActivity.this.mSelectedEditContainer.setVisibility(0);
                    DoodleActivity.this.mSizeContainer.setVisibility(0);
                    DoodleActivity.this.mItemScaleTextView.setText((CharSequence)((int)(selectableItem.getScale() * 100.0f + 0.5f) + "%"));
                    selectableItem.addItemListener(this.mIDoodleItemListener);
                } else {
                    selectableItem.removeItemListener(this.mIDoodleItemListener);
                    if (DoodleActivity.this.mTouchGestureListener.getSelectedItem() == null) {
                        if (this.mLastPen != null) {
                            DoodleActivity.this.mDoodle.setPen(this.mLastPen);
                            this.mLastPen = null;
                        }
                        if (this.mLastColor != null) {
                            DoodleActivity.this.mDoodle.setColor(this.mLastColor);
                            this.mLastColor = null;
                        }
                        if (this.mSize != null) {
                            DoodleActivity.this.mDoodle.setSize(this.mSize.floatValue());
                            this.mSize = null;
                        }
                        DoodleActivity.this.mSelectedEditContainer.setVisibility(8);
                    }
                }
            }

            @Override
            public void onCreateSelectableItem(IDoodle doodle, float x, float y) {
                if (DoodleActivity.this.mDoodle.getPen() == DoodlePen.TEXT) {
                    DoodleActivity.this.createDoodleText(null, x, y);
                } else if (DoodleActivity.this.mDoodle.getPen() == DoodlePen.BITMAP) {
                    DoodleActivity.this.createDoodleBitmap(null, x, y);
                }
            }
        }){

            @Override
            public void setSupportScaleItem(boolean supportScaleItem) {
                super.setSupportScaleItem(supportScaleItem);
                if (supportScaleItem) {
                    DoodleActivity.this.mItemScaleTextView.setVisibility(0);
                } else {
                    DoodleActivity.this.mItemScaleTextView.setVisibility(8);
                }
            }
        };
        DoodleTouchDetector detector = new DoodleTouchDetector(this.getApplicationContext(), (TouchGestureDetector.IOnTouchGestureListener)this.mTouchGestureListener);
        this.mDoodleView.setDefaultTouchDetector(detector);
        this.mDoodle.setIsDrawableOutside(this.mDoodleParams.mIsDrawableOutside);
        this.mFrameLayout.addView((View)this.mDoodleView, -1, -1);
        this.mDoodle.setDoodleMinScale(this.mDoodleParams.mMinScale);
        this.mDoodle.setDoodleMaxScale(this.mDoodleParams.mMaxScale);
        this.initView();
    }

    private boolean canChangeColor(IDoodlePen pen) {
        return pen != DoodlePen.ERASER && pen != DoodlePen.BITMAP && pen != DoodlePen.COPY && pen != DoodlePen.MOSAIC;
    }

    private void createDoodleText(final DoodleText doodleText, final float x, final float y) {
        if (this.isFinishing()) {
            return;
        }
        DialogController.showInputTextDialog(this, doodleText == null ? null : doodleText.getText(), new View.OnClickListener(){

            public void onClick(View v) {
                String text = (v.getTag() + "").trim();
                if (TextUtils.isEmpty((CharSequence)text)) {
                    return;
                }
                if (doodleText == null) {
                    DoodleText item = new DoodleText(DoodleActivity.this.mDoodle, text, DoodleActivity.this.mDoodle.getSize(), DoodleActivity.this.mDoodle.getColor().copy(), x, y);
                    DoodleActivity.this.mDoodle.addItem(item);
                    DoodleActivity.this.mTouchGestureListener.setSelectedItem(item);
                } else {
                    doodleText.setText(text);
                }
                DoodleActivity.this.mDoodle.refresh();
            }
        }, null);
        if (doodleText == null) {
            this.mSettingsPanel.removeCallbacks(this.mHideDelayRunnable);
        }
    }

    private void createDoodleBitmap(final DoodleBitmap doodleBitmap, final float x, final float y) {
        DialogController.showSelectImageDialog(this, new ImageSelectorView.ImageSelectorListener(){

            @Override
            public void onCancel() {
            }

            @Override
            public void onEnter(List<String> pathList) {
                Bitmap bitmap = ImageUtils.createBitmapFromPath((String)pathList.get(0), (int)(DoodleActivity.this.mDoodleView.getWidth() / 4), (int)(DoodleActivity.this.mDoodleView.getHeight() / 4));
                if (doodleBitmap == null) {
                    DoodleBitmap item = new DoodleBitmap(DoodleActivity.this.mDoodle, bitmap, DoodleActivity.this.mDoodle.getSize(), x, y);
                    DoodleActivity.this.mDoodle.addItem(item);
                    DoodleActivity.this.mTouchGestureListener.setSelectedItem(item);
                } else {
                    doodleBitmap.setBitmap(bitmap);
                }
                DoodleActivity.this.mDoodle.refresh();
            }
        });
    }

    private void initView() {
        this.mBtnUndo = this.findViewById(R.id.btn_undo);
        this.mBtnUndo.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (DoodleParams.getDialogInterceptor() == null || !DoodleParams.getDialogInterceptor().onShow(DoodleActivity.this, DoodleActivity.this.mDoodle, DoodleParams.DialogType.CLEAR_ALL)) {
                    DialogController.showEnterCancelDialog(DoodleActivity.this, DoodleActivity.this.getString(R.string.doodle_clear_screen), DoodleActivity.this.getString(R.string.doodle_cant_undo_after_clearing), new View.OnClickListener(){

                        public void onClick(View v) {
                            DoodleActivity.this.mDoodle.clear();
                        }
                    }, null);
                }
                return true;
            }
        });
        this.mSelectedEditContainer = this.findViewById(R.id.doodle_selectable_edit_container);
        this.mSelectedEditContainer.setVisibility(8);
        this.mItemScaleTextView = (TextView)this.findViewById(R.id.item_scale);
        this.mItemScaleTextView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (DoodleActivity.this.mTouchGestureListener.getSelectedItem() != null) {
                    DoodleActivity.this.mTouchGestureListener.getSelectedItem().setScale(1.0f);
                }
                return true;
            }
        });
        this.mSettingsPanel = this.findViewById(R.id.doodle_panel);
        this.mBtnHidePanel = this.findViewById(R.id.doodle_btn_hide_panel);
        this.mPaintSizeView = (TextView)this.findViewById(R.id.paint_size_text);
        this.mShapeContainer = this.findViewById(R.id.shape_container);
        this.mPenContainer = this.findViewById(R.id.pen_container);
        this.mSizeContainer = this.findViewById(R.id.size_container);
        this.mMosaicMenu = this.findViewById(R.id.mosaic_menu);
        this.mEditBtn = this.findViewById(R.id.doodle_selectable_edit);
        this.mBtnColor = this.findViewById(R.id.btn_set_color);
        this.mColorContainer = this.findViewById(R.id.btn_set_color_container);
        this.mEditSizeSeekBar = (SeekBar)this.findViewById(R.id.doodle_seekbar_size);
        this.mEditSizeSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if (progress <= 0) {
                    DoodleActivity.this.mEditSizeSeekBar.setProgress(1);
                    return;
                }
                if ((int)DoodleActivity.this.mDoodle.getSize() == progress) {
                    return;
                }
                DoodleActivity.this.mDoodle.setSize(progress);
                if (DoodleActivity.this.mTouchGestureListener.getSelectedItem() != null) {
                    DoodleActivity.this.mTouchGestureListener.getSelectedItem().setSize(progress);
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
        this.mDoodleView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (!DoodleActivity.this.mBtnHidePanel.isSelected() && ((DoodleActivity)DoodleActivity.this).mDoodleParams.mChangePanelVisibilityDelay > 0L) {
                    switch (event.getAction() & 0xFF) {
                        case 0: {
                            DoodleActivity.this.mSettingsPanel.removeCallbacks(DoodleActivity.this.mHideDelayRunnable);
                            DoodleActivity.this.mSettingsPanel.removeCallbacks(DoodleActivity.this.mShowDelayRunnable);
                            DoodleActivity.this.mSettingsPanel.postDelayed(DoodleActivity.this.mHideDelayRunnable, ((DoodleActivity)DoodleActivity.this).mDoodleParams.mChangePanelVisibilityDelay);
                            break;
                        }
                        case 1: 
                        case 3: {
                            DoodleActivity.this.mSettingsPanel.removeCallbacks(DoodleActivity.this.mHideDelayRunnable);
                            DoodleActivity.this.mSettingsPanel.removeCallbacks(DoodleActivity.this.mShowDelayRunnable);
                            DoodleActivity.this.mSettingsPanel.postDelayed(DoodleActivity.this.mShowDelayRunnable, ((DoodleActivity)DoodleActivity.this).mDoodleParams.mChangePanelVisibilityDelay);
                        }
                    }
                }
                return false;
            }
        });
        this.findViewById(R.id.doodle_txt_title).setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction() & 0xFF) {
                    case 0: {
                        v.setPressed(true);
                        DoodleActivity.this.mDoodle.setShowOriginal(true);
                        break;
                    }
                    case 1: 
                    case 3: {
                        v.setPressed(false);
                        DoodleActivity.this.mDoodle.setShowOriginal(false);
                    }
                }
                return true;
            }
        });
        this.mViewShowAnimation = new AlphaAnimation(0.0f, 1.0f);
        this.mViewShowAnimation.setDuration(150L);
        this.mViewHideAnimation = new AlphaAnimation(1.0f, 0.0f);
        this.mViewHideAnimation.setDuration(150L);
        this.mHideDelayRunnable = new Runnable(){

            @Override
            public void run() {
                DoodleActivity.this.hideView(DoodleActivity.this.mSettingsPanel);
            }
        };
        this.mShowDelayRunnable = new Runnable(){

            @Override
            public void run() {
                DoodleActivity.this.showView(DoodleActivity.this.mSettingsPanel);
            }
        };
    }

    public void onClick(View v) {
        if (v.getId() == R.id.btn_pen_hand) {
            this.mDoodle.setPen(DoodlePen.BRUSH);
        } else if (v.getId() == R.id.btn_pen_mosaic) {
            this.mDoodle.setPen(DoodlePen.MOSAIC);
        } else if (v.getId() == R.id.btn_pen_copy) {
            this.mDoodle.setPen(DoodlePen.COPY);
        } else if (v.getId() == R.id.btn_pen_eraser) {
            this.mDoodle.setPen(DoodlePen.ERASER);
        } else if (v.getId() == R.id.btn_pen_text) {
            this.mDoodle.setPen(DoodlePen.TEXT);
        } else if (v.getId() == R.id.btn_pen_bitmap) {
            this.mDoodle.setPen(DoodlePen.BITMAP);
        } else if (v.getId() == R.id.doodle_btn_brush_edit) {
            this.mDoodleView.setEditMode(!this.mDoodleView.isEditMode());
        } else if (v.getId() == R.id.btn_undo) {
            this.mDoodle.undo();
        } else if (v.getId() == R.id.btn_zoomer) {
            this.mDoodleView.enableZoomer(!this.mDoodleView.isEnableZoomer());
        } else if (v.getId() == R.id.btn_set_color_container) {
            DoodleColor color = null;
            if (this.mDoodle.getColor() instanceof DoodleColor) {
                color = (DoodleColor)this.mDoodle.getColor();
            }
            if (color == null) {
                return;
            }
            if (DoodleParams.getDialogInterceptor() == null || !DoodleParams.getDialogInterceptor().onShow(this, this.mDoodle, DoodleParams.DialogType.COLOR_PICKER)) {
                boolean fullScreen = (this.getWindow().getAttributes().flags & 0x400) != 0;
                int themeId = fullScreen ? 0x1030011 : 0x1030010;
                new ColorPickerDialog((Context)this, new ColorPickerDialog.OnColorChangedListener(){

                    @Override
                    public void colorChanged(int color, int size) {
                        DoodleActivity.this.mDoodle.setColor(new DoodleColor(color));
                        DoodleActivity.this.mDoodle.setSize(size);
                    }

                    @Override
                    public void colorChanged(Drawable color, int size) {
                        Bitmap bitmap = ImageUtils.getBitmapFromDrawable((Drawable)color);
                        DoodleActivity.this.mDoodle.setColor(new DoodleColor(bitmap));
                        DoodleActivity.this.mDoodle.setSize(size);
                    }
                }, themeId).show(this.mDoodleView, this.mBtnColor.getBackground(), Math.min(this.mDoodleView.getWidth(), this.mDoodleView.getHeight()));
            }
        } else if (v.getId() == R.id.doodle_btn_hide_panel) {
            this.mSettingsPanel.removeCallbacks(this.mHideDelayRunnable);
            this.mSettingsPanel.removeCallbacks(this.mShowDelayRunnable);
            v.setSelected(!v.isSelected());
            if (!this.mBtnHidePanel.isSelected()) {
                this.showView(this.mSettingsPanel);
            } else {
                this.hideView(this.mSettingsPanel);
            }
        } else if (v.getId() == R.id.doodle_btn_finish) {
            this.mDoodle.save();
        } else if (v.getId() == R.id.doodle_btn_back) {
            if (this.mDoodle.getAllItem() == null || this.mDoodle.getItemCount() == 0) {
                this.finish();
                return;
            }
            if (DoodleParams.getDialogInterceptor() == null || !DoodleParams.getDialogInterceptor().onShow(this, this.mDoodle, DoodleParams.DialogType.SAVE)) {
                DialogController.showMsgDialog(this, this.getString(R.string.doodle_saving_picture), null, this.getString(R.string.doodle_cancel), this.getString(R.string.doodle_save), new View.OnClickListener(){

                    public void onClick(View v) {
                        DoodleActivity.this.mDoodle.save();
                    }
                }, new View.OnClickListener(){

                    public void onClick(View v) {
                        DoodleActivity.this.finish();
                    }
                });
            }
        } else if (v.getId() == R.id.doodle_btn_rotate) {
            if (this.mRotateAnimator == null) {
                this.mRotateAnimator = new ValueAnimator();
                this.mRotateAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animation) {
                        int value = (Integer)animation.getAnimatedValue();
                        DoodleActivity.this.mDoodle.setDoodleRotation(value);
                    }
                });
                this.mRotateAnimator.setDuration(250L);
            }
            if (this.mRotateAnimator.isRunning()) {
                return;
            }
            this.mRotateAnimator.setIntValues(new int[]{this.mDoodle.getDoodleRotation(), this.mDoodle.getDoodleRotation() + 90});
            this.mRotateAnimator.start();
        } else if (v.getId() == R.id.doodle_selectable_edit) {
            if (this.mTouchGestureListener.getSelectedItem() instanceof DoodleText) {
                this.createDoodleText((DoodleText)this.mTouchGestureListener.getSelectedItem(), -1.0f, -1.0f);
            } else if (this.mTouchGestureListener.getSelectedItem() instanceof DoodleBitmap) {
                this.createDoodleBitmap((DoodleBitmap)this.mTouchGestureListener.getSelectedItem(), -1.0f, -1.0f);
            }
        } else if (v.getId() == R.id.doodle_selectable_remove) {
            this.mDoodle.removeItem(this.mTouchGestureListener.getSelectedItem());
            this.mTouchGestureListener.setSelectedItem(null);
        } else if (v.getId() == R.id.doodle_selectable_top) {
            this.mDoodle.topItem(this.mTouchGestureListener.getSelectedItem());
        } else if (v.getId() == R.id.doodle_selectable_bottom) {
            this.mDoodle.bottomItem(this.mTouchGestureListener.getSelectedItem());
        } else if (v.getId() == R.id.btn_hand_write) {
            this.mDoodle.setShape(DoodleShape.HAND_WRITE);
        } else if (v.getId() == R.id.btn_arrow) {
            this.mDoodle.setShape(DoodleShape.ARROW);
        } else if (v.getId() == R.id.btn_line) {
            this.mDoodle.setShape(DoodleShape.LINE);
        } else if (v.getId() == R.id.btn_holl_circle) {
            this.mDoodle.setShape(DoodleShape.HOLLOW_CIRCLE);
        } else if (v.getId() == R.id.btn_fill_circle) {
            this.mDoodle.setShape(DoodleShape.FILL_CIRCLE);
        } else if (v.getId() == R.id.btn_holl_rect) {
            this.mDoodle.setShape(DoodleShape.HOLLOW_RECT);
        } else if (v.getId() == R.id.btn_fill_rect) {
            this.mDoodle.setShape(DoodleShape.FILL_RECT);
        } else if (v.getId() == R.id.btn_mosaic_level1) {
            if (v.isSelected()) {
                return;
            }
            this.mMosaicLevel = 5;
            this.mDoodle.setColor(DoodlePath.getMosaicColor(this.mDoodle, this.mMosaicLevel));
            v.setSelected(true);
            this.mMosaicMenu.findViewById(R.id.btn_mosaic_level2).setSelected(false);
            this.mMosaicMenu.findViewById(R.id.btn_mosaic_level3).setSelected(false);
            if (this.mTouchGestureListener.getSelectedItem() != null) {
                this.mTouchGestureListener.getSelectedItem().setColor(this.mDoodle.getColor().copy());
            }
        } else if (v.getId() == R.id.btn_mosaic_level2) {
            if (v.isSelected()) {
                return;
            }
            this.mMosaicLevel = 20;
            this.mDoodle.setColor(DoodlePath.getMosaicColor(this.mDoodle, this.mMosaicLevel));
            v.setSelected(true);
            this.mMosaicMenu.findViewById(R.id.btn_mosaic_level1).setSelected(false);
            this.mMosaicMenu.findViewById(R.id.btn_mosaic_level3).setSelected(false);
            if (this.mTouchGestureListener.getSelectedItem() != null) {
                this.mTouchGestureListener.getSelectedItem().setColor(this.mDoodle.getColor().copy());
            }
        } else if (v.getId() == R.id.btn_mosaic_level3) {
            if (v.isSelected()) {
                return;
            }
            this.mMosaicLevel = 50;
            this.mDoodle.setColor(DoodlePath.getMosaicColor(this.mDoodle, this.mMosaicLevel));
            v.setSelected(true);
            this.mMosaicMenu.findViewById(R.id.btn_mosaic_level1).setSelected(false);
            this.mMosaicMenu.findViewById(R.id.btn_mosaic_level2).setSelected(false);
            if (this.mTouchGestureListener.getSelectedItem() != null) {
                this.mTouchGestureListener.getSelectedItem().setColor(this.mDoodle.getColor().copy());
            }
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4 && this.mDoodleView.isEditMode()) {
            this.mDoodleView.setEditMode(false);
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public void onBackPressed() {
        this.findViewById(R.id.doodle_btn_back).performClick();
    }

    private void showView(View view) {
        if (view.getVisibility() == 0) {
            return;
        }
        view.clearAnimation();
        view.startAnimation((Animation)this.mViewShowAnimation);
        view.setVisibility(0);
    }

    private void hideView(View view) {
        if (view.getVisibility() != 0) {
            return;
        }
        view.clearAnimation();
        view.startAnimation((Animation)this.mViewHideAnimation);
        view.setVisibility(8);
    }

    private class DoodleViewWrapper
    extends DoodleView {
        private Map<IDoodlePen, Integer> mBtnPenIds;
        private Map<IDoodleShape, Integer> mBtnShapeIds;
        TextView mPaintSizeView;
        View mBtnEditMode;
        Boolean mLastIsDrawableOutside;

        public DoodleViewWrapper(Context context, Bitmap bitmap, boolean optimizeDrawing, IDoodleListener listener, IDoodleTouchDetector defaultDetector) {
            super(context, bitmap, optimizeDrawing, listener, defaultDetector);
            this.mBtnPenIds = new HashMap<IDoodlePen, Integer>();
            this.mBtnPenIds.put(DoodlePen.BRUSH, R.id.btn_pen_hand);
            this.mBtnPenIds.put(DoodlePen.MOSAIC, R.id.btn_pen_mosaic);
            this.mBtnPenIds.put(DoodlePen.COPY, R.id.btn_pen_copy);
            this.mBtnPenIds.put(DoodlePen.ERASER, R.id.btn_pen_eraser);
            this.mBtnPenIds.put(DoodlePen.TEXT, R.id.btn_pen_text);
            this.mBtnPenIds.put(DoodlePen.BITMAP, R.id.btn_pen_bitmap);
            this.mBtnShapeIds = new HashMap<IDoodleShape, Integer>();
            this.mBtnShapeIds.put(DoodleShape.HAND_WRITE, R.id.btn_hand_write);
            this.mBtnShapeIds.put(DoodleShape.ARROW, R.id.btn_arrow);
            this.mBtnShapeIds.put(DoodleShape.LINE, R.id.btn_line);
            this.mBtnShapeIds.put(DoodleShape.HOLLOW_CIRCLE, R.id.btn_holl_circle);
            this.mBtnShapeIds.put(DoodleShape.FILL_CIRCLE, R.id.btn_fill_circle);
            this.mBtnShapeIds.put(DoodleShape.HOLLOW_RECT, R.id.btn_holl_rect);
            this.mBtnShapeIds.put(DoodleShape.FILL_RECT, R.id.btn_fill_rect);
            this.mPaintSizeView = (TextView)DoodleActivity.this.findViewById(R.id.paint_size_text);
            this.mBtnEditMode = DoodleActivity.this.findViewById(R.id.doodle_btn_brush_edit);
            this.mLastIsDrawableOutside = null;
        }

        @Override
        public void setPen(IDoodlePen pen) {
            Drawable colorBg;
            IDoodlePen oldPen = this.getPen();
            super.setPen(pen);
            DoodleActivity.this.mMosaicMenu.setVisibility(8);
            DoodleActivity.this.mEditBtn.setVisibility(8);
            if (pen == DoodlePen.BITMAP || pen == DoodlePen.TEXT) {
                DoodleActivity.this.mEditBtn.setVisibility(0);
                DoodleActivity.this.mShapeContainer.setVisibility(8);
                if (pen == DoodlePen.BITMAP) {
                    DoodleActivity.this.mColorContainer.setVisibility(8);
                } else {
                    DoodleActivity.this.mColorContainer.setVisibility(0);
                }
            } else if (pen == DoodlePen.MOSAIC) {
                DoodleActivity.this.mMosaicMenu.setVisibility(0);
                DoodleActivity.this.mShapeContainer.setVisibility(0);
                DoodleActivity.this.mColorContainer.setVisibility(8);
            } else {
                DoodleActivity.this.mShapeContainer.setVisibility(0);
                if (pen == DoodlePen.COPY || pen == DoodlePen.ERASER) {
                    DoodleActivity.this.mColorContainer.setVisibility(8);
                } else {
                    DoodleActivity.this.mColorContainer.setVisibility(0);
                }
            }
            this.setSingleSelected(this.mBtnPenIds.values(), this.mBtnPenIds.get(pen));
            if (DoodleActivity.this.mTouchGestureListener.getSelectedItem() == null) {
                DoodleActivity.this.mPenSizeMap.put(oldPen, Float.valueOf(this.getSize()));
                Float size = (Float)DoodleActivity.this.mPenSizeMap.get(pen);
                if (size != null) {
                    DoodleActivity.this.mDoodle.setSize(size.floatValue());
                }
                if (this.isEditMode()) {
                    DoodleActivity.this.mShapeContainer.setVisibility(8);
                    DoodleActivity.this.mColorContainer.setVisibility(8);
                    DoodleActivity.this.mMosaicMenu.setVisibility(8);
                }
            } else {
                DoodleActivity.this.mShapeContainer.setVisibility(8);
                return;
            }
            if (pen == DoodlePen.BRUSH) {
                colorBg = DoodleActivity.this.mBtnColor.getBackground();
                if (colorBg instanceof ColorDrawable) {
                    DoodleActivity.this.mDoodle.setColor(new DoodleColor(((ColorDrawable)colorBg).getColor()));
                } else {
                    DoodleActivity.this.mDoodle.setColor(new DoodleColor(((BitmapDrawable)colorBg).getBitmap()));
                }
            } else if (pen == DoodlePen.MOSAIC) {
                if (DoodleActivity.this.mMosaicLevel <= 0) {
                    DoodleActivity.this.mMosaicMenu.findViewById(R.id.btn_mosaic_level2).performClick();
                } else {
                    DoodleActivity.this.mDoodle.setColor(DoodlePath.getMosaicColor(DoodleActivity.this.mDoodle, DoodleActivity.this.mMosaicLevel));
                }
            } else if (pen != DoodlePen.COPY && pen != DoodlePen.ERASER) {
                if (pen == DoodlePen.TEXT) {
                    colorBg = DoodleActivity.this.mBtnColor.getBackground();
                    if (colorBg instanceof ColorDrawable) {
                        DoodleActivity.this.mDoodle.setColor(new DoodleColor(((ColorDrawable)colorBg).getColor()));
                    } else {
                        DoodleActivity.this.mDoodle.setColor(new DoodleColor(((BitmapDrawable)colorBg).getBitmap()));
                    }
                } else if (pen == DoodlePen.BITMAP) {
                    colorBg = DoodleActivity.this.mBtnColor.getBackground();
                    if (colorBg instanceof ColorDrawable) {
                        DoodleActivity.this.mDoodle.setColor(new DoodleColor(((ColorDrawable)colorBg).getColor()));
                    } else {
                        DoodleActivity.this.mDoodle.setColor(new DoodleColor(((BitmapDrawable)colorBg).getBitmap()));
                    }
                }
            }
        }

        @Override
        public void setShape(IDoodleShape shape) {
            super.setShape(shape);
            this.setSingleSelected(this.mBtnShapeIds.values(), this.mBtnShapeIds.get(shape));
        }

        @Override
        public void setSize(float paintSize) {
            super.setSize(paintSize);
            DoodleActivity.this.mEditSizeSeekBar.setProgress((int)paintSize);
            this.mPaintSizeView.setText((CharSequence)("" + (int)paintSize));
            if (DoodleActivity.this.mTouchGestureListener.getSelectedItem() != null) {
                DoodleActivity.this.mTouchGestureListener.getSelectedItem().setSize(this.getSize());
            }
        }

        @Override
        public void setColor(IDoodleColor color) {
            IDoodlePen pen = this.getPen();
            super.setColor(color);
            DoodleColor doodleColor = null;
            if (color instanceof DoodleColor) {
                doodleColor = (DoodleColor)color;
            }
            if (doodleColor != null && DoodleActivity.this.canChangeColor(pen)) {
                if (doodleColor.getType() == DoodleColor.Type.COLOR) {
                    DoodleActivity.this.mBtnColor.setBackgroundColor(doodleColor.getColor());
                } else if (doodleColor.getType() == DoodleColor.Type.BITMAP) {
                    DoodleActivity.this.mBtnColor.setBackgroundDrawable((Drawable)new BitmapDrawable(doodleColor.getBitmap()));
                }
                if (DoodleActivity.this.mTouchGestureListener.getSelectedItem() != null) {
                    DoodleActivity.this.mTouchGestureListener.getSelectedItem().setColor(this.getColor().copy());
                }
            }
            if (doodleColor != null && pen == DoodlePen.MOSAIC && doodleColor.getLevel() != DoodleActivity.this.mMosaicLevel) {
                switch (doodleColor.getLevel()) {
                    case 5: {
                        DoodleActivity.this.findViewById(R.id.btn_mosaic_level1).performClick();
                        break;
                    }
                    case 20: {
                        DoodleActivity.this.findViewById(R.id.btn_mosaic_level2).performClick();
                        break;
                    }
                    case 50: {
                        DoodleActivity.this.findViewById(R.id.btn_mosaic_level3).performClick();
                    }
                }
            }
        }

        @Override
        public void enableZoomer(boolean enable) {
            super.enableZoomer(enable);
            DoodleActivity.this.findViewById(R.id.btn_zoomer).setSelected(enable);
            if (enable) {
                Toast.makeText((Context)DoodleActivity.this, (CharSequence)("x" + ((DoodleActivity)DoodleActivity.this).mDoodleParams.mZoomerScale), (int)0).show();
            }
        }

        @Override
        public boolean undo() {
            DoodleActivity.this.mTouchGestureListener.setSelectedItem(null);
            return super.undo();
        }

        @Override
        public void clear() {
            super.clear();
            DoodleActivity.this.mTouchGestureListener.setSelectedItem(null);
        }

        @Override
        public void setEditMode(boolean editMode) {
            if (editMode == this.isEditMode()) {
                return;
            }
            super.setEditMode(editMode);
            this.mBtnEditMode.setSelected(editMode);
            if (editMode) {
                Toast.makeText((Context)DoodleActivity.this, (int)R.string.doodle_edit_mode, (int)0).show();
                this.mLastIsDrawableOutside = DoodleActivity.this.mDoodle.isDrawableOutside();
                DoodleActivity.this.mDoodle.setIsDrawableOutside(true);
                DoodleActivity.this.mPenContainer.setVisibility(8);
                DoodleActivity.this.mShapeContainer.setVisibility(8);
                DoodleActivity.this.mSizeContainer.setVisibility(8);
                DoodleActivity.this.mColorContainer.setVisibility(8);
                DoodleActivity.this.mBtnUndo.setVisibility(8);
                DoodleActivity.this.mMosaicMenu.setVisibility(8);
            } else {
                if (this.mLastIsDrawableOutside != null) {
                    DoodleActivity.this.mDoodle.setIsDrawableOutside(this.mLastIsDrawableOutside);
                }
                DoodleActivity.this.mTouchGestureListener.center();
                if (DoodleActivity.this.mTouchGestureListener.getSelectedItem() == null) {
                    this.setPen(this.getPen());
                }
                DoodleActivity.this.mTouchGestureListener.setSelectedItem(null);
                DoodleActivity.this.mPenContainer.setVisibility(0);
                DoodleActivity.this.mSizeContainer.setVisibility(0);
                DoodleActivity.this.mBtnUndo.setVisibility(0);
            }
        }

        private void setSingleSelected(Collection<Integer> ids, int selectedId) {
            for (int id2 : ids) {
                if (id2 == selectedId) {
                    DoodleActivity.this.findViewById(id2).setSelected(true);
                    continue;
                }
                DoodleActivity.this.findViewById(id2).setSelected(false);
            }
        }
    }
}

