/*
 * Decompiled with CFR 0.152.
 */
package cn.hzw.doodle;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import cn.hzw.doodle.CopyLocation;
import cn.hzw.doodle.DoodlePaintAttrs;
import cn.hzw.doodle.DoodlePen;
import cn.hzw.doodle.DoodleRotatableItemBase;
import cn.hzw.doodle.DoodleShape;
import cn.hzw.doodle.DoodleView;
import cn.hzw.doodle.core.IDoodle;
import cn.hzw.doodle.util.DrawUtil;

public class DoodlePath
extends DoodleRotatableItemBase {
    private Path mPath;
    private PointF mSxy = new PointF();
    private PointF mDxy = new PointF();
    private Paint mPaint = new Paint();
    private CopyLocation mCopyLocation;
    private RectF mBound = new RectF();
    private Path mArrowTrianglePath;

    public DoodlePath(IDoodle doodle) {
        super(doodle, 0, 0.0f, 0.0f);
    }

    public DoodlePath(IDoodle doodle, DoodlePaintAttrs attrs) {
        super(doodle, attrs, 0, 0.0f, 0.0f);
    }

    public void updateXY(float sx, float sy, float dx, float dy) {
        this.mSxy.set(sx, sy);
        this.mDxy.set(dx, dy);
        if (this.mPath == null) {
            this.mPath = new Path();
        }
        this.mPath.reset();
        if (DoodleShape.ARROW.equals(this.getShape())) {
            this.updateArrowPath(this.mPath, this.mSxy.x, this.mSxy.y, this.mDxy.x, this.mDxy.y, this.getSize());
        } else if (DoodleShape.LINE.equals(this.getShape())) {
            this.updateLinePath(this.mPath, this.mSxy.x, this.mSxy.y, this.mDxy.x, this.mDxy.y, this.getSize());
        } else if (DoodleShape.FILL_CIRCLE.equals(this.getShape()) || DoodleShape.HOLLOW_CIRCLE.equals(this.getShape())) {
            this.updateCirclePath(this.mPath, this.mSxy.x, this.mSxy.y, this.mDxy.x, this.mDxy.y, this.getSize());
        } else if (DoodleShape.FILL_RECT.equals(this.getShape()) || DoodleShape.HOLLOW_RECT.equals(this.getShape())) {
            this.updateRectPath(this.mPath, this.mSxy.x, this.mSxy.y, this.mDxy.x, this.mDxy.y, this.getSize());
        }
        this.mPath.computeBounds(this.mBound, false);
        this.setPivotX(this.mBound.left + this.mBound.width() / 2.0f);
        this.setPivotY(this.mBound.top + this.mBound.height() / 2.0f);
    }

    public void updatePath(Path path) {
        this.mPath = path;
        if (this.mPath != null) {
            this.mPath.computeBounds(this.mBound, false);
            this.setPivotX(this.mBound.left + this.mBound.width() / 2.0f);
            this.setPivotY(this.mBound.top + this.mBound.height() / 2.0f);
        }
    }

    public void updateCopy(float touchStartX, float touchStartY, float copyStartX, float copyStartY) {
        if (this.mCopyLocation == null) {
            return;
        }
        this.mCopyLocation.setStartPosition(touchStartX, touchStartY, copyStartX, copyStartY);
    }

    public CopyLocation getCopyLocation() {
        return this.mCopyLocation;
    }

    public Path getPath() {
        return this.mPath;
    }

    private PointF getDxy() {
        return this.mDxy;
    }

    private PointF getSxy() {
        return this.mSxy;
    }

    public static DoodlePath toShape(IDoodle doodle, float sx, float sy, float dx, float dy) {
        DoodlePath path = new DoodlePath(doodle);
        path.setPen(doodle.getPen().copy());
        path.setShape(doodle.getShape().copy());
        path.setSize(doodle.getSize());
        path.setColor(doodle.getColor().copy());
        path.updateXY(sx, sy, dx, dy);
        if (path.getPen() == DoodlePen.COPY && doodle instanceof DoodleView) {
            path.mCopyLocation = DoodlePen.COPY.getCopyLocation().copy();
        }
        return path;
    }

    public static DoodlePath toPath(IDoodle doodle, Path p) {
        DoodlePath path = new DoodlePath(doodle);
        path.setPen(doodle.getPen().copy());
        path.setShape(doodle.getShape().copy());
        path.setSize(doodle.getSize());
        path.setColor(doodle.getColor().copy());
        path.updatePath(p);
        path.mCopyLocation = doodle instanceof DoodleView ? DoodlePen.COPY.getCopyLocation().copy() : null;
        return path;
    }

    @Override
    public void setSize(float size) {
        super.setSize(size);
        if (DoodleShape.ARROW.equals(this.getShape())) {
            if (this.mPath == null) {
                this.mPath = new Path();
            }
            this.mPath.reset();
            this.updateArrowPath(this.mPath, this.mSxy.x, this.mSxy.y, this.mDxy.x, this.mDxy.y, this.getSize());
        }
        this.refresh();
    }

    @Override
    protected void doDraw(Canvas canvas) {
        this.mPaint.reset();
        this.mPaint.setStrokeWidth(this.getSize());
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setAntiAlias(true);
        this.getPen().config(this, this.mPaint);
        this.getColor().config(this, this.mPaint);
        this.getShape().config(this, this.mPaint);
        canvas.drawPath(this.getPath(), this.mPaint);
    }

    @Override
    protected void resetBounds(Rect rect) {
        if (this.mPath != null) {
            int diff = (int)(this.getSize() / 2.0f);
            this.mPath.computeBounds(this.mBound, false);
            if (this.getShape() == DoodleShape.ARROW || this.getShape() == DoodleShape.FILL_CIRCLE || this.getShape() == DoodleShape.FILL_RECT) {
                diff = (int)this.getDoodle().getUnitSize();
            }
            rect.set((int)(this.mBound.left - (float)diff), (int)(this.mBound.top - (float)diff), (int)(this.mBound.right + (float)diff), (int)(this.mBound.bottom + (float)diff));
        }
    }

    @Override
    public boolean isDoodleEditable() {
        if (this.getPen() == DoodlePen.ERASER) {
            return false;
        }
        return super.isDoodleEditable();
    }

    private void updateArrowPath(Path path, float sx, float sy, float ex, float ey, float size) {
        float arrowSize = size;
        double H = arrowSize;
        double L = arrowSize / 2.0f;
        double awrad = Math.atan(L / 2.0 / H);
        double arraow_len = Math.sqrt(L / 2.0 * L / 2.0 + H * H) - 5.0;
        double[] arrXY_1 = DrawUtil.rotateVec(ex - sx, ey - sy, awrad, true, arraow_len);
        double[] arrXY_2 = DrawUtil.rotateVec(ex - sx, ey - sy, -awrad, true, arraow_len);
        float x_3 = (float)((double)ex - arrXY_1[0]);
        float y_3 = (float)((double)ey - arrXY_1[1]);
        float x_4 = (float)((double)ex - arrXY_2[0]);
        float y_4 = (float)((double)ey - arrXY_2[1]);
        path.moveTo(sx, sy);
        path.lineTo(x_3, y_3);
        path.lineTo(x_4, y_4);
        path.close();
        awrad = Math.atan(L / H);
        arraow_len = Math.sqrt(L * L + H * H);
        arrXY_1 = DrawUtil.rotateVec(ex - sx, ey - sy, awrad, true, arraow_len);
        arrXY_2 = DrawUtil.rotateVec(ex - sx, ey - sy, -awrad, true, arraow_len);
        x_3 = (float)((double)ex - arrXY_1[0]);
        y_3 = (float)((double)ey - arrXY_1[1]);
        x_4 = (float)((double)ex - arrXY_2[0]);
        y_4 = (float)((double)ey - arrXY_2[1]);
        if (this.mArrowTrianglePath == null) {
            this.mArrowTrianglePath = new Path();
        }
        this.mArrowTrianglePath.reset();
        this.mArrowTrianglePath.moveTo(ex, ey);
        this.mArrowTrianglePath.lineTo(x_4, y_4);
        this.mArrowTrianglePath.lineTo(x_3, y_3);
        this.mArrowTrianglePath.close();
        path.addPath(this.mArrowTrianglePath);
    }

    private void updateLinePath(Path path, float sx, float sy, float ex, float ey, float size) {
        path.moveTo(sx, sy);
        path.lineTo(ex, ey);
    }

    private void updateCirclePath(Path path, float sx, float sy, float dx, float dy, float size) {
        float radius = (float)Math.sqrt((sx - dx) * (sx - dx) + (sy - dy) * (sy - dy));
        path.addCircle(sx, sy, radius, Path.Direction.CCW);
    }

    private void updateRectPath(Path path, float sx, float sy, float dx, float dy, float size) {
        if (sx < dx) {
            if (sy < dy) {
                path.addRect(sx, sy, dx, dy, Path.Direction.CCW);
            } else {
                path.addRect(sx, dy, dx, sy, Path.Direction.CCW);
            }
        } else if (sy < dy) {
            path.addRect(dx, sy, sx, dy, Path.Direction.CCW);
        } else {
            path.addRect(dx, dy, sx, sy, Path.Direction.CCW);
        }
    }
}

