/*
 * Decompiled with CFR 0.152.
 */
package cn.hzw.doodle;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import cn.hzw.doodle.DoodlePath;
import cn.hzw.doodle.core.IDoodleItem;
import cn.hzw.doodle.core.IDoodleShape;
import cn.hzw.doodle.util.DrawUtil;

public enum DoodleShape implements IDoodleShape
{
    HAND_WRITE,
    ARROW,
    LINE,
    FILL_CIRCLE,
    HOLLOW_CIRCLE,
    FILL_RECT,
    HOLLOW_RECT;


    @Override
    public void draw(Canvas canvas, IDoodleItem doodleItem, Paint paint) {
        DoodlePath doodlePath = (DoodlePath)doodleItem;
        if (this == HAND_WRITE) {
            canvas.drawPath(doodlePath.getPath(), paint);
        } else {
            PointF mSxy = doodlePath.getSxy();
            PointF mDxy = doodlePath.getDxy();
            this.draw(canvas, paint, (DoodleShape)doodleItem.getShape(), mSxy.x, mSxy.y, mDxy.x, mDxy.y);
        }
    }

    private void draw(Canvas canvas, Paint paint, DoodleShape shape, float sx, float sy, float dx, float dy) {
        switch (shape) {
            case ARROW: {
                paint.setStyle(Paint.Style.FILL);
                DrawUtil.drawArrow(canvas, sx, sy, dx, dy, paint);
                break;
            }
            case LINE: {
                DrawUtil.drawLine(canvas, sx, sy, dx, dy, paint);
                break;
            }
            case FILL_CIRCLE: {
                paint.setStyle(Paint.Style.FILL);
            }
            case HOLLOW_CIRCLE: {
                DrawUtil.drawCircle(canvas, sx, sy, (float)Math.sqrt((sx - dx) * (sx - dx) + (sy - dy) * (sy - dy)), paint);
                break;
            }
            case FILL_RECT: {
                paint.setStyle(Paint.Style.FILL);
            }
            case HOLLOW_RECT: {
                DrawUtil.drawRect(canvas, sx, sy, dx, dy, paint);
                break;
            }
            default: {
                throw new RuntimeException("unknown shape:" + shape);
            }
        }
    }

    @Override
    public IDoodleShape copy() {
        return this;
    }
}

