/*
 * Decompiled with CFR 0.152.
 */
package cn.forward.androids.views;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import cn.forward.androids.R;
import java.util.ArrayList;
import java.util.List;

public abstract class ScrollPickerView<T>
extends View {
    private int mVisibleItemCount = 3;
    private boolean mIsInertiaScroll = true;
    private boolean mIsCirculation = true;
    private boolean mDisallowInterceptTouch = false;
    private int mSelected;
    private List<T> mData;
    private int mItemHeight = 0;
    private int mItemWidth = 0;
    private int mItemSize;
    private int mCenterPosition = -1;
    private int mCenterY;
    private int mCenterX;
    private int mCenterPoint;
    private float mLastMoveY;
    private float mLastMoveX;
    private float mMoveLength = 0.0f;
    private GestureDetector mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new FlingOnGestureListener());
    private OnSelectedListener mListener;
    private Scroller mScroller = new Scroller(this.getContext());
    private boolean mIsFling;
    private boolean mIsMovingCenter;
    private int mLastScrollY = 0;
    private int mLastScrollX = 0;
    private boolean mDisallowTouch = false;
    private Paint mPaint;
    private Drawable mCenterItemBackground = null;
    private boolean mCanTap = true;
    private boolean mIsHorizontal = false;
    private boolean mDrawAllItem = false;
    private boolean mHasCallSelectedListener = false;
    private int mSelectedOnTouch;
    private boolean mIsAutoScrolling = false;
    private ValueAnimator mAutoScrollAnimator = ValueAnimator.ofInt((int[])new int[]{0, 0});
    private static final SlotInterpolator sAutoScrollInterpolator = new SlotInterpolator();

    public ScrollPickerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ScrollPickerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mPaint = new Paint(1);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        if (attrs != null) {
            TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.ScrollPickerView);
            if (typedArray.hasValue(R.styleable.ScrollPickerView_spv_center_item_background)) {
                this.setCenterItemBackground(typedArray.getDrawable(R.styleable.ScrollPickerView_spv_center_item_background));
            }
            this.setVisibleItemCount(typedArray.getInt(R.styleable.ScrollPickerView_spv_visible_item_count, this.getVisibleItemCount()));
            this.setCenterPosition(typedArray.getInt(R.styleable.ScrollPickerView_spv_center_item_position, this.getCenterPosition()));
            this.setIsCirculation(typedArray.getBoolean(R.styleable.ScrollPickerView_spv_is_circulation, this.isIsCirculation()));
            this.setDisallowInterceptTouch(typedArray.getBoolean(R.styleable.ScrollPickerView_spv_disallow_intercept_touch, this.isDisallowInterceptTouch()));
            this.setHorizontal(typedArray.getInt(R.styleable.ScrollPickerView_spv_orientation, this.mIsHorizontal ? 1 : 2) == 1);
            typedArray.recycle();
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.mData == null || this.mData.size() <= 0) {
            return;
        }
        if (this.mCenterItemBackground != null) {
            this.mCenterItemBackground.draw(canvas);
        }
        int length = Math.max(this.mCenterPosition + 1, this.mVisibleItemCount - this.mCenterPosition);
        int start = Math.min(length, this.mData.size());
        if (this.mDrawAllItem) {
            start = this.mData.size();
        }
        for (int i = start; i >= 1; --i) {
            int position;
            if (this.mDrawAllItem || i <= this.mCenterPosition + 1) {
                int n = position = this.mSelected - i < 0 ? this.mData.size() + this.mSelected - i : this.mSelected - i;
                if (this.mIsCirculation) {
                    this.drawItem(canvas, this.mData, position, -i, this.mMoveLength, (float)this.mCenterPoint + this.mMoveLength - (float)(i * this.mItemSize));
                } else if (this.mSelected - i >= 0) {
                    this.drawItem(canvas, this.mData, position, -i, this.mMoveLength, (float)this.mCenterPoint + this.mMoveLength - (float)(i * this.mItemSize));
                }
            }
            if (!this.mDrawAllItem && i > this.mVisibleItemCount - this.mCenterPosition) continue;
            int n = position = this.mSelected + i >= this.mData.size() ? this.mSelected + i - this.mData.size() : this.mSelected + i;
            if (this.mIsCirculation) {
                this.drawItem(canvas, this.mData, position, i, this.mMoveLength, (float)this.mCenterPoint + this.mMoveLength + (float)(i * this.mItemSize));
                continue;
            }
            if (this.mSelected + i >= this.mData.size()) continue;
            this.drawItem(canvas, this.mData, position, i, this.mMoveLength, (float)this.mCenterPoint + this.mMoveLength + (float)(i * this.mItemSize));
        }
        this.drawItem(canvas, this.mData, this.mSelected, 0, this.mMoveLength, (float)this.mCenterPoint + this.mMoveLength);
    }

    public abstract void drawItem(Canvas var1, List<T> var2, int var3, int var4, float var5, float var6);

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.reset();
    }

    private void reset() {
        if (this.mCenterPosition < 0) {
            this.mCenterPosition = this.mVisibleItemCount / 2;
        }
        if (this.mIsHorizontal) {
            this.mItemHeight = this.getMeasuredHeight();
            this.mItemWidth = this.getMeasuredWidth() / this.mVisibleItemCount;
            this.mCenterY = 0;
            this.mCenterX = this.mCenterPosition * this.mItemWidth;
            this.mItemSize = this.mItemWidth;
            this.mCenterPoint = this.mCenterX;
        } else {
            this.mItemHeight = this.getMeasuredHeight() / this.mVisibleItemCount;
            this.mItemWidth = this.getMeasuredWidth();
            this.mCenterY = this.mCenterPosition * this.mItemHeight;
            this.mCenterX = 0;
            this.mItemSize = this.mItemHeight;
            this.mCenterPoint = this.mCenterY;
        }
        if (this.mCenterItemBackground != null) {
            this.mCenterItemBackground.setBounds(this.mCenterX, this.mCenterY, this.mCenterX + this.mItemWidth, this.mCenterY + this.mItemHeight);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mDisallowTouch) {
            return true;
        }
        switch (event.getActionMasked()) {
            case 0: {
                this.mSelectedOnTouch = this.mSelected;
            }
        }
        if (this.mGestureDetector.onTouchEvent(event)) {
            return true;
        }
        switch (event.getActionMasked()) {
            case 2: {
                if (this.mIsHorizontal) {
                    if (Math.abs(event.getX() - this.mLastMoveX) < 0.1f) {
                        return true;
                    }
                    this.mMoveLength += event.getX() - this.mLastMoveX;
                } else {
                    if (Math.abs(event.getY() - this.mLastMoveY) < 0.1f) {
                        return true;
                    }
                    this.mMoveLength += event.getY() - this.mLastMoveY;
                }
                this.mLastMoveY = event.getY();
                this.mLastMoveX = event.getX();
                this.checkCirculation();
                this.invalidate();
                break;
            }
            case 1: {
                this.mLastMoveY = event.getY();
                this.mLastMoveX = event.getX();
                if (this.mMoveLength == 0.0f) {
                    if (this.mSelectedOnTouch == this.mSelected) break;
                    this.notifySelected();
                    break;
                }
                this.moveToCenter();
            }
        }
        return true;
    }

    private void computeScroll(int curr, int end, float rate) {
        if (rate < 1.0f) {
            if (this.mIsHorizontal) {
                this.mMoveLength = this.mMoveLength + (float)curr - (float)this.mLastScrollX;
                this.mLastScrollX = curr;
            } else {
                this.mMoveLength = this.mMoveLength + (float)curr - (float)this.mLastScrollY;
                this.mLastScrollY = curr;
            }
            this.checkCirculation();
            this.invalidate();
        } else {
            this.mIsMovingCenter = false;
            this.mLastScrollY = 0;
            this.mLastScrollX = 0;
            this.mMoveLength = this.mMoveLength > 0.0f ? (this.mMoveLength < (float)(this.mItemSize / 2) ? 0.0f : (float)this.mItemSize) : (-this.mMoveLength < (float)(this.mItemSize / 2) ? 0.0f : (float)(-this.mItemSize));
            this.checkCirculation();
            this.notifySelected();
            this.invalidate();
        }
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            this.mMoveLength = this.mIsHorizontal ? this.mMoveLength + (float)this.mScroller.getCurrX() - (float)this.mLastScrollX : this.mMoveLength + (float)this.mScroller.getCurrY() - (float)this.mLastScrollY;
            this.mLastScrollY = this.mScroller.getCurrY();
            this.mLastScrollX = this.mScroller.getCurrX();
            this.checkCirculation();
            this.invalidate();
        } else if (this.mIsFling) {
            this.mIsFling = false;
            if (this.mMoveLength == 0.0f) {
                this.notifySelected();
            } else {
                this.moveToCenter();
            }
        } else if (this.mIsMovingCenter) {
            this.notifySelected();
        }
    }

    public void cancelScroll() {
        this.mLastScrollY = 0;
        this.mLastScrollX = 0;
        this.mIsMovingCenter = false;
        this.mIsFling = false;
        this.mScroller.abortAnimation();
        this.stopAutoScroll();
    }

    private void checkCirculation() {
        if (this.mMoveLength >= (float)this.mItemSize) {
            int span = (int)(this.mMoveLength / (float)this.mItemSize);
            this.mSelected -= span;
            if (this.mSelected < 0) {
                if (this.mIsCirculation) {
                    do {
                        this.mSelected = this.mData.size() + this.mSelected;
                    } while (this.mSelected < 0);
                    this.mMoveLength = (this.mMoveLength - (float)this.mItemSize) % (float)this.mItemSize;
                } else {
                    this.mSelected = 0;
                    this.mMoveLength = this.mItemSize;
                    if (this.mIsFling) {
                        this.mScroller.forceFinished(true);
                    }
                    if (this.mIsMovingCenter) {
                        this.scroll(this.mMoveLength, 0);
                    }
                }
            } else {
                this.mMoveLength = (this.mMoveLength - (float)this.mItemSize) % (float)this.mItemSize;
            }
        } else if (this.mMoveLength <= (float)(-this.mItemSize)) {
            int span = (int)(-this.mMoveLength / (float)this.mItemSize);
            this.mSelected += span;
            if (this.mSelected >= this.mData.size()) {
                if (this.mIsCirculation) {
                    do {
                        this.mSelected -= this.mData.size();
                    } while (this.mSelected >= this.mData.size());
                    this.mMoveLength = (this.mMoveLength + (float)this.mItemSize) % (float)this.mItemSize;
                } else {
                    this.mSelected = this.mData.size() - 1;
                    this.mMoveLength = -this.mItemSize;
                    if (this.mIsFling) {
                        this.mScroller.forceFinished(true);
                    }
                    if (this.mIsMovingCenter) {
                        this.scroll(this.mMoveLength, 0);
                    }
                }
            } else {
                this.mMoveLength = (this.mMoveLength + (float)this.mItemSize) % (float)this.mItemSize;
            }
        }
    }

    private void moveToCenter() {
        if (!this.mScroller.isFinished() || this.mIsFling || this.mMoveLength == 0.0f) {
            return;
        }
        this.cancelScroll();
        if (this.mMoveLength > 0.0f) {
            if (this.mIsHorizontal) {
                if (this.mMoveLength < (float)(this.mItemWidth / 2)) {
                    this.scroll(this.mMoveLength, 0);
                } else {
                    this.scroll(this.mMoveLength, this.mItemWidth);
                }
            } else if (this.mMoveLength < (float)(this.mItemHeight / 2)) {
                this.scroll(this.mMoveLength, 0);
            } else {
                this.scroll(this.mMoveLength, this.mItemHeight);
            }
        } else if (this.mIsHorizontal) {
            if (-this.mMoveLength < (float)(this.mItemWidth / 2)) {
                this.scroll(this.mMoveLength, 0);
            } else {
                this.scroll(this.mMoveLength, -this.mItemWidth);
            }
        } else if (-this.mMoveLength < (float)(this.mItemHeight / 2)) {
            this.scroll(this.mMoveLength, 0);
        } else {
            this.scroll(this.mMoveLength, -this.mItemHeight);
        }
    }

    private void scroll(float from, int to) {
        if (this.mIsHorizontal) {
            this.mLastScrollX = (int)from;
            this.mIsMovingCenter = true;
            this.mScroller.startScroll((int)from, 0, 0, 0);
            this.mScroller.setFinalX(to);
        } else {
            this.mLastScrollY = (int)from;
            this.mIsMovingCenter = true;
            this.mScroller.startScroll(0, (int)from, 0, 0);
            this.mScroller.setFinalY(to);
        }
        this.invalidate();
    }

    private void fling(float from, float vel) {
        if (this.mIsHorizontal) {
            this.mLastScrollX = (int)from;
            this.mIsFling = true;
            this.mScroller.fling((int)from, 0, (int)vel, 0, -10 * this.mItemWidth, 10 * this.mItemWidth, 0, 0);
        } else {
            this.mLastScrollY = (int)from;
            this.mIsFling = true;
            this.mScroller.fling(0, (int)from, 0, (int)vel, 0, 0, -10 * this.mItemHeight, 10 * this.mItemHeight);
        }
        this.invalidate();
    }

    private void notifySelected() {
        this.mMoveLength = 0.0f;
        this.cancelScroll();
        if (this.mListener != null) {
            this.mListener.onSelected(this, this.mSelected);
        }
    }

    public void autoScrollFast(int position, long duration, float speed, Interpolator interpolator) {
        if (this.mIsAutoScrolling || !this.mIsCirculation) {
            return;
        }
        this.cancelScroll();
        this.mIsAutoScrolling = true;
        int length = (int)(speed * (float)duration);
        int circle = (int)((float)length * 1.0f / (float)(this.mData.size() * this.mItemSize) + 0.5f);
        circle = circle <= 0 ? 1 : circle;
        int aPlan = circle * this.mData.size() * this.mItemSize + (this.mSelected - position) * this.mItemSize;
        int bPlan = aPlan + this.mData.size() * this.mItemSize;
        final int end = Math.abs(length - aPlan) < Math.abs(length - bPlan) ? aPlan : bPlan;
        this.mAutoScrollAnimator.cancel();
        this.mAutoScrollAnimator.setIntValues(new int[]{0, end});
        this.mAutoScrollAnimator.setInterpolator((TimeInterpolator)interpolator);
        this.mAutoScrollAnimator.setDuration(duration);
        this.mAutoScrollAnimator.removeAllUpdateListeners();
        if (end != 0) {
            this.mAutoScrollAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    float rate = 0.0f;
                    rate = (float)animation.getCurrentPlayTime() * 1.0f / (float)animation.getDuration();
                    ScrollPickerView.this.computeScroll((Integer)animation.getAnimatedValue(), end, rate);
                }
            });
            this.mAutoScrollAnimator.removeAllListeners();
            this.mAutoScrollAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    ScrollPickerView.this.mIsAutoScrolling = false;
                }
            });
            this.mAutoScrollAnimator.start();
        } else {
            this.computeScroll(end, end, 1.0f);
            this.mIsAutoScrolling = false;
        }
    }

    public void autoScrollFast(int position, long duration) {
        float speed = this.dip2px(0.6f);
        this.autoScrollFast(position, duration, speed, sAutoScrollInterpolator);
    }

    public void autoScrollFast(int position, long duration, float speed) {
        this.autoScrollFast(position, duration, speed, sAutoScrollInterpolator);
    }

    public void autoScrollToPosition(int toPosition, long duration, Interpolator interpolator) {
        int endY = (this.mSelected - (toPosition %= this.mData.size())) * this.mItemHeight;
        this.autoScrollTo(endY, duration, interpolator, false);
    }

    public void autoScrollTo(final int endY, long duration, Interpolator interpolator, boolean canIntercept) {
        if (this.mIsAutoScrolling) {
            return;
        }
        final boolean temp = this.mDisallowTouch;
        this.mDisallowTouch = !canIntercept;
        this.mIsAutoScrolling = true;
        this.mAutoScrollAnimator.cancel();
        this.mAutoScrollAnimator.setIntValues(new int[]{0, endY});
        this.mAutoScrollAnimator.setInterpolator((TimeInterpolator)interpolator);
        this.mAutoScrollAnimator.setDuration(duration);
        this.mAutoScrollAnimator.removeAllUpdateListeners();
        this.mAutoScrollAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float rate = 0.0f;
                rate = (float)animation.getCurrentPlayTime() * 1.0f / (float)animation.getDuration();
                ScrollPickerView.this.computeScroll((Integer)animation.getAnimatedValue(), endY, rate);
            }
        });
        this.mAutoScrollAnimator.removeAllListeners();
        this.mAutoScrollAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                ScrollPickerView.this.mIsAutoScrolling = false;
                ScrollPickerView.this.mDisallowTouch = temp;
            }
        });
        this.mAutoScrollAnimator.start();
    }

    public void stopAutoScroll() {
        this.mIsAutoScrolling = false;
        this.mAutoScrollAnimator.cancel();
    }

    public List<T> getData() {
        return this.mData;
    }

    public void setData(List<? extends T> data) {
        this.mData = data == null ? new ArrayList<T>() : data;
        this.mSelected = this.mData.size() / 2;
        this.invalidate();
    }

    public T getSelectedItem() {
        return this.mData.get(this.mSelected);
    }

    public int getSelectedPosition() {
        return this.mSelected;
    }

    public void setSelectedPosition(int position) {
        if (position < 0 || position > this.mData.size() - 1 || position == this.mSelected && this.mHasCallSelectedListener) {
            return;
        }
        this.mHasCallSelectedListener = true;
        this.mSelected = position;
        this.invalidate();
        this.notifySelected();
    }

    public void setOnSelectedListener(OnSelectedListener listener) {
        this.mListener = listener;
    }

    public OnSelectedListener getListener() {
        return this.mListener;
    }

    public boolean isInertiaScroll() {
        return this.mIsInertiaScroll;
    }

    public void setInertiaScroll(boolean inertiaScroll) {
        this.mIsInertiaScroll = inertiaScroll;
    }

    public boolean isIsCirculation() {
        return this.mIsCirculation;
    }

    public void setIsCirculation(boolean isCirculation) {
        this.mIsCirculation = isCirculation;
    }

    public boolean isDisallowInterceptTouch() {
        return this.mDisallowInterceptTouch;
    }

    public int getVisibleItemCount() {
        return this.mVisibleItemCount;
    }

    public void setVisibleItemCount(int visibleItemCount) {
        this.mVisibleItemCount = visibleItemCount;
        this.reset();
        this.invalidate();
    }

    public void setDisallowInterceptTouch(boolean disallowInterceptTouch) {
        this.mDisallowInterceptTouch = disallowInterceptTouch;
    }

    public int getItemHeight() {
        return this.mItemHeight;
    }

    public int getItemWidth() {
        return this.mItemWidth;
    }

    public int getItemSize() {
        return this.mItemSize;
    }

    public int getCenterX() {
        return this.mCenterX;
    }

    public int getCenterY() {
        return this.mCenterY;
    }

    public int getCenterPoint() {
        return this.mCenterPoint;
    }

    public boolean isDisallowTouch() {
        return this.mDisallowTouch;
    }

    public void setDisallowTouch(boolean disallowTouch) {
        this.mDisallowTouch = disallowTouch;
    }

    public void setCenterPosition(int centerPosition) {
        this.mCenterPosition = centerPosition < 0 ? 0 : (centerPosition >= this.mVisibleItemCount ? this.mVisibleItemCount - 1 : centerPosition);
        this.mCenterY = this.mCenterPosition * this.mItemHeight;
        this.invalidate();
    }

    public int getCenterPosition() {
        return this.mCenterPosition;
    }

    public void setCenterItemBackground(Drawable centerItemBackground) {
        this.mCenterItemBackground = centerItemBackground;
        this.mCenterItemBackground.setBounds(this.mCenterX, this.mCenterY, this.mCenterX + this.mItemWidth, this.mCenterY + this.mItemHeight);
        this.invalidate();
    }

    public void setCenterItemBackground(int centerItemBackgroundColor) {
        this.mCenterItemBackground = new ColorDrawable(centerItemBackgroundColor);
        this.mCenterItemBackground.setBounds(this.mCenterX, this.mCenterY, this.mCenterX + this.mItemWidth, this.mCenterY + this.mItemHeight);
        this.invalidate();
    }

    public Drawable getCenterItemBackground() {
        return this.mCenterItemBackground;
    }

    public boolean isScrolling() {
        return this.mIsFling || this.mIsMovingCenter || this.mIsAutoScrolling;
    }

    public boolean isFling() {
        return this.mIsFling;
    }

    public boolean isMovingCenter() {
        return this.mIsMovingCenter;
    }

    public boolean isAutoScrolling() {
        return this.mIsAutoScrolling;
    }

    public boolean isCanTap() {
        return this.mCanTap;
    }

    public void setCanTap(boolean canTap) {
        this.mCanTap = canTap;
    }

    public boolean isHorizontal() {
        return this.mIsHorizontal;
    }

    public boolean isVertical() {
        return !this.mIsHorizontal;
    }

    public void setHorizontal(boolean horizontal) {
        if (this.mIsHorizontal == horizontal) {
            return;
        }
        this.mIsHorizontal = horizontal;
        this.reset();
        this.mItemSize = this.mIsHorizontal ? this.mItemWidth : this.mItemHeight;
        this.invalidate();
    }

    public void setVertical(boolean vertical) {
        if (this.mIsHorizontal == !vertical) {
            return;
        }
        this.mIsHorizontal = !vertical;
        this.reset();
        this.mItemSize = this.mIsHorizontal ? this.mItemWidth : this.mItemHeight;
        this.invalidate();
    }

    public boolean isDrawAllItem() {
        return this.mDrawAllItem;
    }

    public void setDrawAllItem(boolean drawAllItem) {
        this.mDrawAllItem = drawAllItem;
    }

    public int dip2px(float dipVlue) {
        DisplayMetrics metrics = this.getContext().getResources().getDisplayMetrics();
        float sDensity = metrics.density;
        return (int)(dipVlue * sDensity + 0.5f);
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (visibility == 0) {
            this.moveToCenter();
        }
    }

    public static interface OnSelectedListener {
        public void onSelected(ScrollPickerView var1, int var2);
    }

    private class FlingOnGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private boolean mIsScrollingLastTime = false;

        private FlingOnGestureListener() {
        }

        public boolean onDown(MotionEvent e) {
            ViewParent parent;
            if (ScrollPickerView.this.mDisallowInterceptTouch && (parent = ScrollPickerView.this.getParent()) != null) {
                parent.requestDisallowInterceptTouchEvent(true);
            }
            this.mIsScrollingLastTime = ScrollPickerView.this.isScrolling();
            ScrollPickerView.this.cancelScroll();
            ScrollPickerView.this.mLastMoveY = e.getY();
            ScrollPickerView.this.mLastMoveX = e.getX();
            return true;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (ScrollPickerView.this.mIsInertiaScroll) {
                ScrollPickerView.this.cancelScroll();
                if (ScrollPickerView.this.mIsHorizontal) {
                    ScrollPickerView.this.fling(ScrollPickerView.this.mMoveLength, velocityX);
                } else {
                    ScrollPickerView.this.fling(ScrollPickerView.this.mMoveLength, velocityY);
                }
            }
            return true;
        }

        public boolean onSingleTapUp(MotionEvent e) {
            ScrollPickerView.this.mLastMoveY = e.getY();
            ScrollPickerView.this.mLastMoveX = e.getX();
            float lastMove = 0.0f;
            if (ScrollPickerView.this.isHorizontal()) {
                ScrollPickerView.this.mCenterPoint = ScrollPickerView.this.mCenterX;
                lastMove = ScrollPickerView.this.mLastMoveX;
            } else {
                ScrollPickerView.this.mCenterPoint = ScrollPickerView.this.mCenterY;
                lastMove = ScrollPickerView.this.mLastMoveY;
            }
            if (ScrollPickerView.this.mCanTap && !this.mIsScrollingLastTime) {
                if (lastMove >= (float)ScrollPickerView.this.mCenterPoint && lastMove <= (float)(ScrollPickerView.this.mCenterPoint + ScrollPickerView.this.mItemSize)) {
                    ScrollPickerView.this.performClick();
                } else if (lastMove < (float)ScrollPickerView.this.mCenterPoint) {
                    int move = ScrollPickerView.this.mItemSize;
                    ScrollPickerView.this.autoScrollTo(move, 150L, sAutoScrollInterpolator, false);
                } else {
                    int move = -ScrollPickerView.this.mItemSize;
                    ScrollPickerView.this.autoScrollTo(move, 150L, sAutoScrollInterpolator, false);
                }
            } else {
                ScrollPickerView.this.moveToCenter();
            }
            return true;
        }
    }

    private static class SlotInterpolator
    implements Interpolator {
        private SlotInterpolator() {
        }

        public float getInterpolation(float input) {
            return (float)(Math.cos((double)(input + 1.0f) * Math.PI) / 2.0) + 0.5f;
        }
    }
}

