/*
 * Decompiled with CFR 0.152.
 */
package cn.forward.androids.Image;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.os.Environment;
import android.util.LruCache;
import cn.forward.androids.utils.LogUtil;
import cn.forward.androids.utils.cache.DiskLruCache;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public class ImageCache {
    private int mMemoryCacheMaxSize;
    private long mDiskCacheMaxSize;
    private File mDiskCacheDir;
    private final Object mDiskCacheLock = new Object();
    private DiskLruCache diskLruCache;
    private LruCache<String, Bitmap> memoryLruCache;
    private Context mContext;

    public ImageCache(Context context, int memoryCacheMaxSize, long diskCacheMaxSize) {
        this(context, memoryCacheMaxSize, diskCacheMaxSize, new File(ImageCache.getDiskCacheDir(context, "androidsCache")));
    }

    public ImageCache(Context context, int memoryCacheMaxSize, long diskCacheMaxSize, File diskCacheDir) {
        this.mContext = context;
        this.mMemoryCacheMaxSize = memoryCacheMaxSize;
        this.mDiskCacheMaxSize = diskCacheMaxSize;
        this.mDiskCacheDir = diskCacheDir;
        this.initMemoryCache();
        this.initDiskCache();
    }

    private void initMemoryCache() {
        this.memoryLruCache = new LruCache<String, Bitmap>(this.mMemoryCacheMaxSize){

            protected int sizeOf(String key, Bitmap value) {
                if (value == null) {
                    return 0;
                }
                return value.getRowBytes() * value.getHeight();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDiskCache() {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.diskLruCache != null && !this.diskLruCache.isClosed()) {
                return;
            }
            int vc = 0;
            try {
                PackageManager manager = this.mContext.getPackageManager();
                PackageInfo info = manager.getPackageInfo(this.mContext.getPackageName(), 0);
                if (info != null) {
                    vc = info.versionCode;
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
            try {
                if (this.mDiskCacheDir.exists() || this.mDiskCacheDir.mkdirs()) {
                    this.diskLruCache = DiskLruCache.open(this.mDiskCacheDir, vc, 1, this.mDiskCacheMaxSize);
                } else {
                    LogUtil.e("disk cache dir init failed");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void clearAllCache() {
        this.clearAllMemoryCache();
        this.clearAllDiskCache();
    }

    public void clearAllMemoryCache() {
        if (this.memoryLruCache == null) {
            return;
        }
        this.memoryLruCache.evictAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllDiskCache() {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.diskLruCache == null) {
                return;
            }
            try {
                this.diskLruCache.delete();
                this.diskLruCache.close();
                this.diskLruCache = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.initDiskCache();
    }

    public void closeAllCache() {
        this.closeMemoryCache();
        this.closeDiskCache();
    }

    public void closeMemoryCache() {
        this.clearAllMemoryCache();
        this.memoryLruCache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDiskCache() {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.diskLruCache == null) {
                return;
            }
            try {
                this.diskLruCache.close();
                this.diskLruCache = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Bitmap getBitmapMemoryCache(String key) {
        if (this.memoryLruCache != null) {
            return (Bitmap)this.memoryLruCache.get((Object)key);
        }
        return null;
    }

    public void saveBitmapMemoryCache(Bitmap bitmap, String key) {
        if (this.memoryLruCache != null && key != null) {
            this.memoryLruCache.put((Object)key, (Object)bitmap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap getBitmapDiskCache(String key) {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.diskLruCache == null || key == null) {
                return null;
            }
            BitmapFactory.Options options = new BitmapFactory.Options();
            DiskLruCache.Snapshot snapshot = null;
            try {
                snapshot = this.diskLruCache.get(key.hashCode() + "");
                if (snapshot != null) {
                    options.inPreferredConfig = Bitmap.Config.RGB_565;
                    options.inInputShareable = true;
                    options.inPurgeable = true;
                    return BitmapFactory.decodeStream((InputStream)snapshot.getInputStream(0), null, (BitmapFactory.Options)options);
                }
            }
            catch (OutOfMemoryError error) {
                LogUtil.e("getBitmapDiskCache:OutOfMemory");
                try {
                    options.inSampleSize = 2;
                    return BitmapFactory.decodeStream((InputStream)snapshot.getInputStream(0), null, (BitmapFactory.Options)options);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public void saveBitmapDiskCache(Bitmap bitmap, String key) {
        this.saveBitmapDiskCache(bitmap, key, Bitmap.CompressFormat.JPEG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveBitmapDiskCache(Bitmap bitmap, String key, Bitmap.CompressFormat format) {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.diskLruCache == null || key == null) {
                return;
            }
            try {
                DiskLruCache.Editor editor = this.diskLruCache.edit(key.hashCode() + "");
                if (editor != null) {
                    OutputStream out = editor.newOutputStream(0);
                    bitmap.compress(format, 90, out);
                    editor.commit();
                    out.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Bitmap getBitmap(String key) {
        Bitmap bitmap = this.getBitmapMemoryCache(key);
        if (bitmap == null && (bitmap = this.getBitmapDiskCache(key)) != null) {
            this.saveBitmapMemoryCache(bitmap, key);
        }
        return bitmap;
    }

    public void save(Bitmap bitmap, String key, Bitmap.CompressFormat format) {
        this.saveBitmapMemoryCache(bitmap, key);
        this.saveBitmapDiskCache(bitmap, key, format);
    }

    public void save(Bitmap bitmap, String key) {
        this.saveBitmapMemoryCache(bitmap, key);
        this.saveBitmapDiskCache(bitmap, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushDiskCache() {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.diskLruCache != null) {
                try {
                    this.diskLruCache.flush();
                }
                catch (Throwable e) {
                    LogUtil.e(e.getMessage());
                }
            }
        }
    }

    public int getMemoryCacheMaxSize() {
        return this.mMemoryCacheMaxSize;
    }

    public void setMemoryCacheMaxSize(int size) {
        if (this.memoryLruCache != null && Build.VERSION.SDK_INT >= 21) {
            this.memoryLruCache.resize(size);
        }
    }

    public long getDiskCacheMaxSize() {
        return this.mDiskCacheMaxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDiskCacheMaxSize(long size) {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.diskLruCache == null) {
                return;
            }
            this.diskLruCache.setMaxSize(size);
        }
    }

    public File getDiskCacheDir() {
        return this.mDiskCacheDir;
    }

    public Map<String, Bitmap> getSnapshotMemoryCache() {
        if (this.memoryLruCache == null) {
            return null;
        }
        return this.memoryLruCache.snapshot();
    }

    public static String getDiskCacheDir(Context context, String dirName) {
        File cacheDir;
        File externalCacheDir;
        String cachePath = null;
        if ("mounted".equals(Environment.getExternalStorageState()) && (externalCacheDir = context.getExternalCacheDir()) != null) {
            cachePath = externalCacheDir.getPath();
        }
        if (cachePath == null && (cacheDir = context.getCacheDir()) != null && cacheDir.exists()) {
            cachePath = cacheDir.getPath();
        }
        return cachePath + File.separator + dirName;
    }
}

