/*
 * Decompiled with CFR 0.152.
 */
package cn.forward.androids.views;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.widget.FrameLayout;

public class KeyboardLayout
extends FrameLayout {
    private KeyboardLayoutListener mListener;
    private boolean mIsKeyboardActive = false;
    private int mKeyboardHeight = 0;

    public KeyboardLayout(Context context) {
        this(context, null, 0);
    }

    public KeyboardLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public KeyboardLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)new KeyboardOnGlobalChangeListener());
    }

    public void setKeyboardListener(KeyboardLayoutListener listener) {
        this.mListener = listener;
    }

    public KeyboardLayoutListener getKeyboardListener() {
        return this.mListener;
    }

    public boolean isKeyboardActive() {
        return this.mIsKeyboardActive;
    }

    public int getKeyboardHeight() {
        return this.mKeyboardHeight;
    }

    public static interface KeyboardLayoutListener {
        public void onKeyboardStateChanged(boolean var1, int var2);
    }

    private class KeyboardOnGlobalChangeListener
    implements ViewTreeObserver.OnGlobalLayoutListener {
        int mScreenHeight = 0;
        Rect mRect = new Rect();

        private KeyboardOnGlobalChangeListener() {
        }

        private int getScreenHeight() {
            if (this.mScreenHeight > 0) {
                return this.mScreenHeight;
            }
            this.mScreenHeight = ((WindowManager)KeyboardLayout.this.getContext().getSystemService("window")).getDefaultDisplay().getHeight();
            return this.mScreenHeight;
        }

        public void onGlobalLayout() {
            KeyboardLayout.this.getWindowVisibleDisplayFrame(this.mRect);
            int screenHeight = this.getScreenHeight();
            int keyboardHeight = screenHeight - this.mRect.bottom;
            boolean isActive = false;
            if (Math.abs(keyboardHeight) > screenHeight / 5) {
                isActive = true;
                KeyboardLayout.this.mKeyboardHeight = keyboardHeight;
            }
            KeyboardLayout.this.mIsKeyboardActive = isActive;
            if (KeyboardLayout.this.mListener != null) {
                KeyboardLayout.this.mListener.onKeyboardStateChanged(isActive, keyboardHeight);
            }
        }
    }
}

