/*
 * Decompiled with CFR 0.152.
 */
package cn.forward.androids;

import android.os.Binder;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import cn.forward.androids.CompareRunnable;
import cn.forward.androids.Priority;
import cn.forward.androids.PriorityRunnable;
import cn.forward.androids.utils.LogUtil;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class SimpleAsyncTask<Params, Progress, Result> {
    private static final String LOG_TAG = "SimpleAsyncTask";
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int CORE_POOL_SIZE = CPU_COUNT + 1;
    private static final int MAXIMUM_POOL_SIZE = CPU_COUNT * 2 + 1;
    private static final int KEEP_ALIVE = 1;
    private static final ThreadFactory sThreadFactory = new ThreadFactory(){
        private final AtomicInteger mCount = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "SimpleAsyncTask #" + this.mCount.getAndIncrement());
        }
    };
    private static int sMaxSizeLIFO = 128;
    private static final ThreadPoolExecutor EXECUTOR = new ThreadPoolExecutor(CORE_POOL_SIZE, MAXIMUM_POOL_SIZE, 1L, TimeUnit.MILLISECONDS, new LinkedBlockingStack<Runnable>(Policy.FIFO));
    private static final ThreadPoolExecutor EXECUTOR_LIFO = new ThreadPoolExecutor(CORE_POOL_SIZE, MAXIMUM_POOL_SIZE, 1L, TimeUnit.MILLISECONDS, new LinkedBlockingStack<Runnable>(Policy.LIFO));
    private static final ThreadPoolExecutor EXECUTOR_PRIORITY = new ThreadPoolExecutor(1, 1, 1L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)new PriorityBlockingQueue<Runnable>(){

        @Override
        public boolean offer(Runnable runnable) {
            return super.offer(new CompareRunnableFIFOWrapper((CompareRunnable)runnable));
        }
    });
    private static final int MESSAGE_POST_RESULT = 1;
    private static final int MESSAGE_POST_PROGRESS = 2;
    private static volatile Executor sDefaultExecutor = EXECUTOR;
    private static InternalHandler sHandler;
    private final WorkerRunnable<Params, Result> mWorker;
    private final FutureTask<Result> mFuture;
    private volatile Status mStatus = Status.PENDING;
    private final AtomicBoolean mCancelled = new AtomicBoolean();
    private final AtomicBoolean mTaskInvoked = new AtomicBoolean();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Handler getHandler() {
        Class<SimpleAsyncTask> clazz = SimpleAsyncTask.class;
        synchronized (SimpleAsyncTask.class) {
            if (sHandler == null) {
                sHandler = new InternalHandler();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sHandler;
        }
    }

    public static void setDefaultExecutor(Executor exec) {
        sDefaultExecutor = exec;
    }

    public SimpleAsyncTask() {
        this.mWorker = new WorkerRunnable<Params, Result>(){

            @Override
            public Result call() throws Exception {
                SimpleAsyncTask.this.mTaskInvoked.set(true);
                Process.setThreadPriority((int)10);
                Object result = SimpleAsyncTask.this.doInBackground(this.mParams);
                Binder.flushPendingCommands();
                return SimpleAsyncTask.this.postResult(result);
            }
        };
        this.mFuture = new FutureTask<Result>(this.mWorker){

            @Override
            protected void done() {
                try {
                    SimpleAsyncTask.this.postResultIfNotInvoked(this.get());
                }
                catch (InterruptedException e) {
                    LogUtil.w(SimpleAsyncTask.LOG_TAG, e);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException("An error occurred while executing doInBackground()", e.getCause());
                }
                catch (CancellationException e) {
                    SimpleAsyncTask.this.postResultIfNotInvoked(null);
                }
            }
        };
    }

    public boolean reset() {
        if (Status.RUNNING == this.mStatus) {
            return false;
        }
        this.mStatus = Status.PENDING;
        this.mCancelled.set(false);
        this.mTaskInvoked.set(false);
        return true;
    }

    private void postResultIfNotInvoked(Result result) {
        boolean wasTaskInvoked = this.mTaskInvoked.get();
        if (!wasTaskInvoked) {
            this.postResult(result);
        }
    }

    private Result postResult(Result result) {
        Message message = SimpleAsyncTask.getHandler().obtainMessage(1, new AsyncTaskResult<Object>(this, result));
        message.sendToTarget();
        return result;
    }

    public final Status getStatus() {
        return this.mStatus;
    }

    protected abstract Result doInBackground(Params ... var1);

    protected void onPreExecute() {
    }

    protected void onPostExecute(Result result) {
    }

    protected void onProgressUpdate(Progress ... values) {
    }

    protected void onCancelled(Result result) {
        this.onCancelled();
    }

    protected void onCancelled() {
    }

    public final boolean isCancelled() {
        return this.mCancelled.get();
    }

    public final boolean cancel(boolean mayInterruptIfRunning) {
        this.mCancelled.set(true);
        return this.mFuture.cancel(mayInterruptIfRunning);
    }

    public final Result get() throws InterruptedException, ExecutionException {
        return this.mFuture.get();
    }

    public final Result get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.mFuture.get(timeout, unit);
    }

    public final SimpleAsyncTask<Params, Progress, Result> execute(Params ... params) {
        return this.executeOnExecutor(sDefaultExecutor, params);
    }

    public final SimpleAsyncTask<Params, Progress, Result> executeLIFO(Params ... params) {
        return this.executeOnExecutor((Executor)EXECUTOR_LIFO, params);
    }

    public final SimpleAsyncTask<Params, Progress, Result> executePriority(Priority priority, Params ... params) {
        if (priority == null) {
            throw new RuntimeException("priority is null!");
        }
        return this.executeOnExecutor((Executor)EXECUTOR_PRIORITY, priority, params);
    }

    public final SimpleAsyncTask<Params, Progress, Result> executeOnExecutor(Executor exec, Params ... params) {
        return this.executeOnExecutor(exec, null, params);
    }

    private final SimpleAsyncTask<Params, Progress, Result> executeOnExecutor(Executor exec, Priority priority, Params ... params) {
        if (this.mStatus != Status.PENDING) {
            switch (this.mStatus) {
                case RUNNING: {
                    throw new IllegalStateException("Cannot execute task: the task is already running.");
                }
                case FINISHED: {
                    throw new IllegalStateException("Cannot execute task: the task has already been executed (a task can be executed only once)");
                }
            }
        }
        this.mStatus = Status.RUNNING;
        this.onPreExecute();
        this.mWorker.mParams = params;
        if (priority != null) {
            exec.execute(new PriorityRunnable(priority, this.mFuture));
        } else {
            exec.execute(this.mFuture);
        }
        return this;
    }

    public static void execute(Runnable runnable) {
        sDefaultExecutor.execute(runnable);
    }

    protected final void publishProgress(Progress ... values) {
        if (!this.isCancelled()) {
            SimpleAsyncTask.getHandler().obtainMessage(2, new AsyncTaskResult<Progress>(this, values)).sendToTarget();
        }
    }

    private void finish(Result result) {
        if (this.isCancelled()) {
            this.onCancelled(result);
        } else {
            this.onPostExecute(result);
        }
        this.mStatus = Status.FINISHED;
    }

    private static class AsyncTaskResult<Data> {
        final SimpleAsyncTask mTask;
        final Data[] mData;

        AsyncTaskResult(SimpleAsyncTask task, Data ... data) {
            this.mTask = task;
            this.mData = data;
        }
    }

    private static abstract class WorkerRunnable<Params, Result>
    implements Callable<Result> {
        Params[] mParams;

        private WorkerRunnable() {
        }
    }

    private static class InternalHandler
    extends Handler {
        public InternalHandler() {
            super(Looper.getMainLooper());
        }

        public void handleMessage(Message msg) {
            AsyncTaskResult result = (AsyncTaskResult)msg.obj;
            switch (msg.what) {
                case 1: {
                    result.mTask.finish(result.mData[0]);
                    break;
                }
                case 2: {
                    result.mTask.onProgressUpdate(result.mData);
                }
            }
        }
    }

    public static enum Status {
        PENDING,
        RUNNING,
        FINISHED;

    }

    private static class CompareRunnableFIFOWrapper
    implements CompareRunnable<CompareRunnableFIFOWrapper> {
        private static AtomicLong mCount = new AtomicLong(0L);
        private final long mSecondPriority;
        private CompareRunnable mRunnable;

        private CompareRunnableFIFOWrapper(CompareRunnable runnable) {
            this.mRunnable = runnable;
            this.mSecondPriority = mCount.incrementAndGet();
        }

        public CompareRunnable getRunnable() {
            return this.mRunnable;
        }

        public long getSecondPriority() {
            return this.mSecondPriority;
        }

        @Override
        public void run() {
            this.mRunnable.run();
        }

        @Override
        public int compareTo(CompareRunnableFIFOWrapper another) {
            int res = this.mRunnable.compareTo(another.getRunnable());
            if (res == 0) {
                return this.mSecondPriority < another.getSecondPriority() ? -1 : 1;
            }
            return res;
        }
    }

    public static class LinkedBlockingStack<T>
    extends LinkedBlockingDeque<T> {
        private static Policy sPolicy = Policy.FIFO;

        private LinkedBlockingStack(Policy policy) {
            sPolicy = policy;
        }

        @Override
        public boolean offer(T e) {
            switch (sPolicy) {
                case LIFO: {
                    this.offerFirst(e);
                    if (this.size() > sMaxSizeLIFO) {
                        this.removeLast();
                    }
                    return true;
                }
            }
            this.offerLast(e);
            return true;
        }
    }

    public static enum Policy {
        FIFO,
        LIFO;

    }
}

