/*
 * Decompiled with CFR 0.152.
 */
package com.zhangke.websocket.request;

import com.zhangke.websocket.request.ByteArrayRequest;
import com.zhangke.websocket.request.ByteBufferRequest;
import com.zhangke.websocket.request.CollectionFrameDataRequest;
import com.zhangke.websocket.request.FrameDataRequest;
import com.zhangke.websocket.request.PingRequest;
import com.zhangke.websocket.request.PongRequest;
import com.zhangke.websocket.request.Request;
import com.zhangke.websocket.request.StringRequest;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Queue;
import org.java_websocket.framing.Framedata;
import org.java_websocket.framing.PingFrame;

public class RequestFactory {
    private static final int POLL_SIZE = 7;
    private static Queue<ByteArrayRequest> BYTE_ARRAY_REQUEST_POOL = new ArrayDeque<ByteArrayRequest>(7);
    private static Queue<ByteBufferRequest> BYTE_BUFFER_REQUEST_POOL = new ArrayDeque<ByteBufferRequest>(7);
    private static Queue<StringRequest> STRING_REQUEST_POOL = new ArrayDeque<StringRequest>(7);
    private static Queue<PingRequest> PING_REQUEST_POOL = new ArrayDeque<PingRequest>(7);
    private static Queue<PongRequest> PONG_REQUEST_POOL = new ArrayDeque<PongRequest>(7);
    private static Queue<FrameDataRequest> FRAME_DATA_REQUEST_POOL = new ArrayDeque<FrameDataRequest>(7);
    private static Queue<CollectionFrameDataRequest> COLLECTION_FRAME_REQUEST_POOL = new ArrayDeque<CollectionFrameDataRequest>(7);

    public static Request<byte[]> createByteArrayRequest() {
        Request request = BYTE_ARRAY_REQUEST_POOL.poll();
        if (request == null) {
            request = new ByteArrayRequest();
        }
        return request;
    }

    public static Request<ByteBuffer> createByteBufferRequest() {
        Request request = BYTE_BUFFER_REQUEST_POOL.poll();
        if (request == null) {
            request = new ByteBufferRequest();
        }
        return request;
    }

    public static Request<String> createStringRequest() {
        Request request = STRING_REQUEST_POOL.poll();
        if (request == null) {
            request = new StringRequest();
        }
        return request;
    }

    public static Request createPingRequest() {
        Request request = PING_REQUEST_POOL.poll();
        if (request == null) {
            request = new PingRequest();
        }
        return request;
    }

    public static Request<PingFrame> createPongRequest() {
        Request request = PONG_REQUEST_POOL.poll();
        if (request == null) {
            request = new PongRequest();
        }
        return request;
    }

    public static Request<Framedata> createFrameDataRequest() {
        Request request = FRAME_DATA_REQUEST_POOL.poll();
        if (request == null) {
            request = new FrameDataRequest();
        }
        return request;
    }

    public static Request<Collection<Framedata>> createCollectionFrameRequest() {
        Request request = COLLECTION_FRAME_REQUEST_POOL.poll();
        if (request == null) {
            request = new CollectionFrameDataRequest();
        }
        return request;
    }

    static void releaseByteArrayRequest(ByteArrayRequest request) {
        BYTE_ARRAY_REQUEST_POOL.offer(request);
    }

    static void releaseByteBufferRequest(ByteBufferRequest request) {
        BYTE_BUFFER_REQUEST_POOL.offer(request);
    }

    static void releaseStringRequest(StringRequest request) {
        STRING_REQUEST_POOL.offer(request);
    }

    static void releasePingRequest(PingRequest request) {
        PING_REQUEST_POOL.offer(request);
    }

    static void releasePongRequest(PongRequest request) {
        PONG_REQUEST_POOL.offer(request);
    }

    static void releaseFrameDataRequest(FrameDataRequest request) {
        FRAME_DATA_REQUEST_POOL.offer(request);
    }

    static void releaseCollectionFrameRequest(CollectionFrameDataRequest request) {
        COLLECTION_FRAME_REQUEST_POOL.offer(request);
    }
}

