/*
 * Decompiled with CFR 0.152.
 */
package com.zhangke.websocket;

import com.zhangke.websocket.ReconnectManager;
import com.zhangke.websocket.WebSocketManager;
import com.zhangke.websocket.util.LogUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;

public class DefaultReconnectManager
implements ReconnectManager {
    private static final String TAG = "WSDefaultRM";
    private final Object BLOCK = new Object();
    private WebSocketManager mWebSocketManager;
    private ReconnectManager.OnConnectListener mOnDisconnectListener;
    private volatile boolean reconnecting;
    private volatile boolean destroyed;
    private volatile boolean needStopReconnect = false;
    private volatile boolean connected = false;
    private final ExecutorService singleThreadPool = Executors.newSingleThreadExecutor();
    private int reconnectCount = 1;
    private int finishCount = 1;

    public DefaultReconnectManager(WebSocketManager webSocketManager, ReconnectManager.OnConnectListener onDisconnectListener) {
        this.mWebSocketManager = webSocketManager;
        this.mOnDisconnectListener = onDisconnectListener;
        this.reconnecting = false;
        this.destroyed = false;
    }

    @Override
    public boolean reconnecting() {
        return this.reconnecting;
    }

    @Override
    public void startReconnect() {
        if (this.reconnecting) {
            LogUtil.i(TAG, "Reconnecting, do not call again.");
            return;
        }
        if (this.destroyed) {
            LogUtil.e(TAG, "ReconnectManager is destroyed!!!");
            return;
        }
        this.needStopReconnect = false;
        this.reconnecting = true;
        try {
            this.singleThreadPool.execute(this.getReconnectRunnable());
        }
        catch (RejectedExecutionException e) {
            LogUtil.e(TAG, "\u7ebf\u7a0b\u961f\u5217\u5df2\u6ee1\uff0c\u65e0\u6cd5\u6267\u884c\u6b64\u6b21\u4efb\u52a1\u3002", e);
            this.reconnecting = false;
        }
    }

    private Runnable getReconnectRunnable() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (DefaultReconnectManager.this.destroyed || DefaultReconnectManager.this.needStopReconnect) {
                    DefaultReconnectManager.this.reconnecting = false;
                    return;
                }
                LogUtil.d(DefaultReconnectManager.TAG, "\u5f00\u59cb\u91cd\u8fde:" + DefaultReconnectManager.this.reconnectCount);
                DefaultReconnectManager.this.reconnectCount++;
                DefaultReconnectManager.this.reconnecting = true;
                DefaultReconnectManager.this.connected = false;
                try {
                    int count = DefaultReconnectManager.this.mWebSocketManager.getSetting().getReconnectFrequency();
                    for (int i = 0; i < count; ++i) {
                        LogUtil.i(DefaultReconnectManager.TAG, String.format("\u7b2c%s\u6b21\u91cd\u8fde", i + 1));
                        DefaultReconnectManager.this.mWebSocketManager.reconnectOnce();
                        Object object = DefaultReconnectManager.this.BLOCK;
                        synchronized (object) {
                            block13: {
                                DefaultReconnectManager.this.BLOCK.wait(DefaultReconnectManager.this.mWebSocketManager.getSetting().getConnectTimeout());
                                if (!DefaultReconnectManager.this.connected) break block13;
                                LogUtil.i(DefaultReconnectManager.TAG, "reconnectOnce success!");
                                DefaultReconnectManager.this.mOnDisconnectListener.onConnected();
                                return;
                            }
                            try {
                                if (DefaultReconnectManager.this.needStopReconnect) {
                                }
                            }
                            catch (InterruptedException e) {}
                            break;
                        }
                    }
                    LogUtil.i(DefaultReconnectManager.TAG, "reconnectOnce failed!");
                    DefaultReconnectManager.this.mOnDisconnectListener.onDisconnect();
                }
                finally {
                    LogUtil.d(DefaultReconnectManager.TAG, "\u91cd\u8fde\u7ed3\u675f:" + DefaultReconnectManager.this.finishCount);
                    DefaultReconnectManager.this.finishCount++;
                    DefaultReconnectManager.this.reconnecting = false;
                    LogUtil.i(DefaultReconnectManager.TAG, "reconnecting = false");
                }
            }
        };
    }

    @Override
    public void stopReconnect() {
        this.needStopReconnect = true;
        if (this.singleThreadPool != null) {
            this.singleThreadPool.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConnected() {
        this.connected = true;
        Object object = this.BLOCK;
        synchronized (object) {
            LogUtil.i(TAG, "onConnected()->BLOCK.notifyAll()");
            this.BLOCK.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConnectError(Throwable th) {
        this.connected = false;
        Object object = this.BLOCK;
        synchronized (object) {
            LogUtil.i(TAG, "onConnectError(Throwable)->BLOCK.notifyAll()");
            this.BLOCK.notifyAll();
        }
    }

    @Override
    public void destroy() {
        this.destroyed = true;
        this.stopReconnect();
        this.mWebSocketManager = null;
    }
}

