/*
 * Decompiled with CFR 0.152.
 */
package com.zhangke.websocket;

import android.text.TextUtils;
import com.zhangke.websocket.DefaultReconnectManager;
import com.zhangke.websocket.ReconnectManager;
import com.zhangke.websocket.SocketListener;
import com.zhangke.websocket.SocketWrapperListener;
import com.zhangke.websocket.WebSocketEngine;
import com.zhangke.websocket.WebSocketSetting;
import com.zhangke.websocket.WebSocketWrapper;
import com.zhangke.websocket.dispatcher.MainThreadResponseDelivery;
import com.zhangke.websocket.dispatcher.ResponseDelivery;
import com.zhangke.websocket.dispatcher.ResponseProcessEngine;
import com.zhangke.websocket.request.Request;
import com.zhangke.websocket.request.RequestFactory;
import com.zhangke.websocket.response.ErrorResponse;
import com.zhangke.websocket.response.Response;
import com.zhangke.websocket.response.ResponseFactory;
import com.zhangke.websocket.util.LogUtil;
import java.nio.ByteBuffer;
import java.util.Collection;
import org.java_websocket.framing.Framedata;
import org.java_websocket.framing.PingFrame;

public class WebSocketManager {
    private static final String TAG = "WSManager";
    private WebSocketSetting mSetting;
    private WebSocketWrapper mWebSocket;
    private ResponseDelivery mDelivery;
    private ReconnectManager mReconnectManager;
    private SocketWrapperListener mSocketWrapperListener;
    private boolean destroyed = false;
    private boolean disconnect = false;
    private WebSocketEngine mWebSocketEngine;
    private ResponseProcessEngine mResponseProcessEngine;

    WebSocketManager(WebSocketSetting setting, WebSocketEngine webSocketEngine, ResponseProcessEngine responseProcessEngine) {
        this.mSetting = setting;
        this.mWebSocketEngine = webSocketEngine;
        this.mResponseProcessEngine = responseProcessEngine;
        this.mDelivery = this.mSetting.getResponseDelivery();
        if (this.mDelivery == null) {
            this.mDelivery = new MainThreadResponseDelivery();
        }
        this.mSocketWrapperListener = this.getSocketWrapperListener();
        if (this.mWebSocket == null) {
            this.mWebSocket = new WebSocketWrapper(this.mSetting, this.mSocketWrapperListener);
        }
        this.start();
    }

    public WebSocketManager start() {
        if (this.mWebSocket == null) {
            this.mWebSocket = new WebSocketWrapper(this.mSetting, this.mSocketWrapperListener);
        }
        if (this.mWebSocket.getConnectState() == 0) {
            this.reconnect();
        }
        return this;
    }

    public void setReconnectManager(ReconnectManager reconnectManager) {
        this.mReconnectManager = reconnectManager;
    }

    public WebSocketManager reconnect() {
        this.disconnect = false;
        if (this.mReconnectManager == null) {
            this.mReconnectManager = this.getDefaultReconnectManager();
        }
        if (!this.mReconnectManager.reconnecting()) {
            this.mReconnectManager.startReconnect();
        }
        return this;
    }

    public WebSocketManager reconnect(WebSocketSetting setting) {
        this.disconnect = false;
        if (this.destroyed) {
            LogUtil.e(TAG, "This WebSocketManager is destroyed!");
            return this;
        }
        this.mSetting = setting;
        if (this.mWebSocket != null) {
            this.mWebSocket.destroy();
            this.mWebSocket = null;
        }
        this.start();
        return this;
    }

    public WebSocketManager disConnect() {
        this.disconnect = true;
        if (this.destroyed) {
            LogUtil.e(TAG, "This WebSocketManager is destroyed!");
            return this;
        }
        if (this.mWebSocket.getConnectState() != 0) {
            this.mWebSocketEngine.disConnect(this.mWebSocket, this.mSocketWrapperListener);
        }
        return this;
    }

    public void send(String text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        Request<String> request = RequestFactory.createStringRequest();
        request.setRequestData(text);
        this.sendRequest(request);
    }

    public void send(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return;
        }
        Request<byte[]> request = RequestFactory.createByteArrayRequest();
        request.setRequestData(bytes);
        this.sendRequest(request);
    }

    public void send(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return;
        }
        Request<ByteBuffer> request = RequestFactory.createByteBufferRequest();
        request.setRequestData(byteBuffer);
        this.sendRequest(request);
    }

    public void sendPing() {
        this.sendRequest(RequestFactory.createPingRequest());
    }

    public void sendPong() {
        this.sendRequest(RequestFactory.createPongRequest());
    }

    public void sendPong(PingFrame pingFrame) {
        if (pingFrame == null) {
            return;
        }
        Request<PingFrame> request = RequestFactory.createPongRequest();
        request.setRequestData(pingFrame);
        this.sendRequest(request);
    }

    public void sendFrame(Framedata framedata) {
        if (framedata == null) {
            return;
        }
        Request<Framedata> request = RequestFactory.createFrameDataRequest();
        request.setRequestData(framedata);
        this.sendRequest(request);
    }

    public void sendFrame(Collection<Framedata> frameData) {
        if (frameData == null) {
            return;
        }
        Request<Collection<Framedata>> request = RequestFactory.createCollectionFrameRequest();
        request.setRequestData(frameData);
        this.sendRequest(request);
    }

    public WebSocketManager addListener(SocketListener listener) {
        this.mDelivery.addListener(listener);
        return this;
    }

    public WebSocketManager removeListener(SocketListener listener) {
        this.mDelivery.removeListener(listener);
        return this;
    }

    public WebSocketSetting getSetting() {
        return this.mSetting;
    }

    public void destroy() {
        this.destroyed = true;
        if (this.mWebSocket != null) {
            this.mWebSocketEngine.destroyWebSocket(this.mWebSocket);
            this.mWebSocketEngine = null;
            this.mWebSocket = null;
        }
        if (this.mDelivery != null) {
            if (!this.mDelivery.isEmpty()) {
                this.mDelivery.clear();
            }
            this.mDelivery = null;
        }
        if (this.mReconnectManager != null) {
            if (this.mReconnectManager.reconnecting()) {
                this.mReconnectManager.stopReconnect();
            }
            this.mReconnectManager = null;
        }
    }

    void reconnectOnce() {
        if (this.destroyed) {
            LogUtil.e(TAG, "This WebSocketManager is destroyed!");
            return;
        }
        if (this.mWebSocket.getConnectState() == 0) {
            this.mWebSocketEngine.connect(this.mWebSocket, this.mSocketWrapperListener);
        } else {
            if (this.mReconnectManager != null) {
                this.mReconnectManager.onConnected();
            }
            LogUtil.e(TAG, "WebSocket \u5df2\u8fde\u63a5\uff0c\u8bf7\u52ff\u91cd\u8bd5\u3002");
        }
    }

    private void sendRequest(Request request) {
        if (this.destroyed) {
            LogUtil.e(TAG, "This WebSocketManager is destroyed!");
            return;
        }
        this.mWebSocketEngine.sendRequest(this.mWebSocket, request, this.mSocketWrapperListener);
    }

    private ReconnectManager getDefaultReconnectManager() {
        return new DefaultReconnectManager(this, new ReconnectManager.OnConnectListener(){

            @Override
            public void onConnected() {
                LogUtil.i(WebSocketManager.TAG, "\u91cd\u8fde\u6210\u529f");
            }

            @Override
            public void onDisconnect() {
                LogUtil.i(WebSocketManager.TAG, "\u91cd\u8fde\u5931\u8d25");
                WebSocketManager.this.mSetting.getResponseDispatcher().onDisconnect(WebSocketManager.this.mDelivery);
            }
        });
    }

    private SocketWrapperListener getSocketWrapperListener() {
        return new SocketWrapperListener(){

            @Override
            public void onConnected() {
                if (WebSocketManager.this.mReconnectManager != null) {
                    WebSocketManager.this.mReconnectManager.onConnected();
                }
                WebSocketManager.this.mSetting.getResponseDispatcher().onConnected(WebSocketManager.this.mDelivery);
            }

            @Override
            public void onConnectFailed(Throwable e) {
                if (WebSocketManager.this.mReconnectManager != null && WebSocketManager.this.mReconnectManager.reconnecting()) {
                    WebSocketManager.this.mReconnectManager.onConnectError(e);
                } else {
                    WebSocketManager.this.mSetting.getResponseDispatcher().onConnectFailed(e, WebSocketManager.this.mDelivery);
                }
            }

            @Override
            public void onDisconnect() {
                if (WebSocketManager.this.mReconnectManager != null && WebSocketManager.this.mReconnectManager.reconnecting()) {
                    if (WebSocketManager.this.disconnect) {
                        WebSocketManager.this.mSetting.getResponseDispatcher().onDisconnect(WebSocketManager.this.mDelivery);
                    } else {
                        WebSocketManager.this.mReconnectManager.onConnectError(null);
                    }
                } else {
                    WebSocketManager.this.mSetting.getResponseDispatcher().onDisconnect(WebSocketManager.this.mDelivery);
                    if (!WebSocketManager.this.disconnect) {
                        if (WebSocketManager.this.mReconnectManager == null) {
                            WebSocketManager.this.mReconnectManager = WebSocketManager.this.getDefaultReconnectManager();
                        }
                        WebSocketManager.this.mReconnectManager.onConnectError(null);
                        WebSocketManager.this.mReconnectManager.startReconnect();
                    }
                }
            }

            @Override
            public void onSendDataError(Request request, int type, Throwable tr) {
                ErrorResponse errorResponse = ResponseFactory.createErrorResponse();
                errorResponse.init(request, type, tr);
                if (WebSocketManager.this.mSetting.processDataOnBackground()) {
                    WebSocketManager.this.mResponseProcessEngine.onSendDataError(errorResponse, WebSocketManager.this.mSetting.getResponseDispatcher(), WebSocketManager.this.mDelivery);
                } else {
                    WebSocketManager.this.mSetting.getResponseDispatcher().onSendDataError(errorResponse, WebSocketManager.this.mDelivery);
                }
                if (!WebSocketManager.this.disconnect && type == 0) {
                    LogUtil.e(WebSocketManager.TAG, "\u6570\u636e\u53d1\u9001\u5931\u8d25\uff0c\u7f51\u7edc\u672a\u8fde\u63a5\uff0c\u5f00\u59cb\u91cd\u8fde\u3002\u3002\u3002");
                    WebSocketManager.this.reconnect();
                }
            }

            @Override
            public void onMessage(Response message) {
                if (WebSocketManager.this.mSetting.processDataOnBackground()) {
                    WebSocketManager.this.mResponseProcessEngine.onMessageReceive(message, WebSocketManager.this.mSetting.getResponseDispatcher(), WebSocketManager.this.mDelivery);
                } else {
                    message.onResponse(WebSocketManager.this.mSetting.getResponseDispatcher(), WebSocketManager.this.mDelivery);
                }
            }
        };
    }
}

