/*
 * Decompiled with CFR 0.152.
 */
package com.zhangke.websocket;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.zhangke.websocket.SocketWrapperListener;
import com.zhangke.websocket.WebSocketWrapper;
import com.zhangke.websocket.request.Request;
import com.zhangke.websocket.util.LogUtil;
import java.util.ArrayDeque;
import java.util.Queue;

public class WebSocketEngine {
    private static final String TAG = "WSWebSocketEngine";
    private OptionThread mOptionThread = new OptionThread();

    WebSocketEngine() {
        this.mOptionThread.start();
    }

    void sendRequest(WebSocketWrapper webSocket, Request request, SocketWrapperListener listener) {
        if (this.mOptionThread.mHandler == null) {
            listener.onSendDataError(request, 2, null);
        } else {
            ReRunnable runnable = ReRunnable.obtain();
            runnable.type = 0;
            runnable.request = request;
            runnable.webSocketWrapper = webSocket;
            this.mOptionThread.mHandler.post(runnable);
        }
    }

    void connect(WebSocketWrapper webSocket, SocketWrapperListener listener) {
        if (this.mOptionThread.mHandler == null) {
            listener.onConnectFailed(new Exception("WebSocketEngine not start!"));
        } else {
            ReRunnable runnable = ReRunnable.obtain();
            runnable.type = 1;
            runnable.webSocketWrapper = webSocket;
            this.mOptionThread.mHandler.post(runnable);
        }
    }

    void disConnect(WebSocketWrapper webSocket, SocketWrapperListener listener) {
        if (this.mOptionThread.mHandler != null) {
            ReRunnable runnable = ReRunnable.obtain();
            runnable.type = 2;
            runnable.webSocketWrapper = webSocket;
            this.mOptionThread.mHandler.post(runnable);
        } else {
            LogUtil.e(TAG, "WebSocketEngine not start!");
        }
    }

    void destroyWebSocket(WebSocketWrapper webSocket) {
        if (this.mOptionThread.mHandler != null) {
            ReRunnable runnable = ReRunnable.obtain();
            runnable.type = 3;
            runnable.webSocketWrapper = webSocket;
            this.mOptionThread.mHandler.post(runnable);
        } else {
            LogUtil.e(TAG, "WebSocketEngine not start!");
        }
    }

    public void destroy() {
        if (this.mOptionThread != null && this.mOptionThread.mHandler != null) {
            this.mOptionThread.mHandler.sendEmptyMessage(1);
        }
    }

    private static class ReRunnable
    implements Runnable {
        private static Queue<ReRunnable> POOL = new ArrayDeque<ReRunnable>(10);
        private int type;
        private WebSocketWrapper webSocketWrapper;
        private Request request;

        private ReRunnable() {
        }

        static ReRunnable obtain() {
            ReRunnable runnable = POOL.poll();
            if (runnable == null) {
                runnable = new ReRunnable();
            }
            return runnable;
        }

        @Override
        public void run() {
            try {
                if (this.webSocketWrapper == null) {
                    return;
                }
                if (this.type == 0 && this.request == null) {
                    return;
                }
                if (this.type == 0) {
                    this.webSocketWrapper.send(this.request);
                } else if (this.type == 1) {
                    this.webSocketWrapper.reconnect();
                } else if (this.type == 2) {
                    this.webSocketWrapper.disConnect();
                } else if (this.type == 3) {
                    this.webSocketWrapper.destroy();
                }
            }
            finally {
                this.webSocketWrapper = null;
                this.request = null;
                this.release();
            }
        }

        void release() {
            POOL.offer(this);
        }
    }

    private static class OptionHandler
    extends Handler {
        private static final int QUIT = 1;

        private OptionHandler() {
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
        }
    }

    private class OptionThread
    extends Thread {
        private OptionHandler mHandler;

        private OptionThread() {
        }

        @Override
        public void run() {
            super.run();
            Looper.prepare();
            this.mHandler = new OptionHandler();
            Looper.loop();
        }
    }
}

