/*
 * Decompiled with CFR 0.152.
 */
package com.zhangke.websocket.response;

import com.zhangke.websocket.response.ByteBufferResponse;
import com.zhangke.websocket.response.ErrorResponse;
import com.zhangke.websocket.response.PingResponse;
import com.zhangke.websocket.response.PongResponse;
import com.zhangke.websocket.response.Response;
import com.zhangke.websocket.response.TextResponse;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;
import org.java_websocket.framing.Framedata;

public class ResponseFactory {
    private static final int POOL_SIZE = 7;
    private static Queue<ErrorResponse> ERROR_RESPONSE_POOL = new ArrayDeque<ErrorResponse>(7);
    private static Queue<TextResponse> TEXT_RESPONSE_POOL = new ArrayDeque<TextResponse>(7);
    private static Queue<ByteBufferResponse> BYTE_BUFFER_RESPONSE_POOL = new ArrayDeque<ByteBufferResponse>(7);
    private static Queue<PingResponse> PING_RESPONSE_POOL = new ArrayDeque<PingResponse>(7);
    private static Queue<PongResponse> PONG_RESPONSE_POOL = new ArrayDeque<PongResponse>(7);

    public static ErrorResponse createErrorResponse() {
        ErrorResponse response = ERROR_RESPONSE_POOL.poll();
        if (response == null) {
            response = new ErrorResponse();
        }
        return response;
    }

    public static Response<String> createTextResponse() {
        Response response = TEXT_RESPONSE_POOL.poll();
        if (response == null) {
            response = new TextResponse();
        }
        return response;
    }

    public static Response<ByteBuffer> createByteBufferResponse() {
        Response response = BYTE_BUFFER_RESPONSE_POOL.poll();
        if (response == null) {
            response = new ByteBufferResponse();
        }
        return response;
    }

    public static Response<Framedata> createPingResponse() {
        Response response = PING_RESPONSE_POOL.poll();
        if (response == null) {
            response = new PingResponse();
        }
        return response;
    }

    public static Response<Framedata> createPongResponse() {
        Response response = PONG_RESPONSE_POOL.poll();
        if (response == null) {
            response = new PongResponse();
        }
        return response;
    }

    static void releaseErrorResponse(ErrorResponse response) {
        ERROR_RESPONSE_POOL.offer(response);
    }

    static void releaseTextResponse(TextResponse response) {
        TEXT_RESPONSE_POOL.offer(response);
    }

    static void releaseByteBufferResponse(ByteBufferResponse response) {
        BYTE_BUFFER_RESPONSE_POOL.offer(response);
    }

    static void releasePingResponse(PingResponse response) {
        PING_RESPONSE_POOL.offer(response);
    }

    static void releasePongResponse(PongResponse response) {
        PONG_RESPONSE_POOL.offer(response);
    }
}

