/*
 * Decompiled with CFR 0.152.
 */
package com.zhangke.websocket.dispatcher;

import android.os.Process;
import com.zhangke.websocket.dispatcher.ResponseProcessEngine;
import com.zhangke.websocket.util.LogUtil;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class EngineThread
extends Thread {
    private String TAG = "WSEngineThread";
    private ArrayBlockingQueue<ResponseProcessEngine.EngineEntity> jobQueue = new ArrayBlockingQueue(10);
    private ExecutorService executorService;
    private boolean stop;

    @Override
    public synchronized void start() {
        this.stop = false;
        super.start();
    }

    @Override
    public void run() {
        super.run();
        Process.setThreadPriority((int)10);
        while (!this.stop) {
            try {
                ResponseProcessEngine.EngineEntity entity = this.jobQueue.take();
                if (entity.isError) {
                    entity.dispatcher.onSendDataError(entity.errorResponse, entity.delivery);
                } else {
                    entity.response.onResponse(entity.dispatcher, entity.delivery);
                }
                ResponseProcessEngine.EngineEntity.release(entity);
            }
            catch (InterruptedException e) {
                if (!this.stop) continue;
                return;
            }
            catch (Exception e) {
                LogUtil.e(this.TAG, "run()->Exception", e);
            }
        }
    }

    void add(final ResponseProcessEngine.EngineEntity entity) {
        if (!this.jobQueue.offer(entity)) {
            LogUtil.e(this.TAG, "Offer response to Engine failed!start an thread to put.");
            if (this.executorService == null) {
                this.executorService = Executors.newCachedThreadPool();
            }
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    if (EngineThread.this.stop) {
                        return;
                    }
                    try {
                        EngineThread.this.jobQueue.put(entity);
                    }
                    catch (Exception e) {
                        if (EngineThread.this.stop) {
                            LogUtil.e(EngineThread.this.TAG, "put response failed!", e);
                        }
                        EngineThread.this.interrupt();
                    }
                }
            });
        }
    }

    void quit() {
        this.stop = true;
        this.jobQueue.clear();
        this.interrupt();
    }
}

