/*
 * Decompiled with CFR 0.152.
 */
package com.zhangke.websocket;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.zhangke.websocket.WebSocketHandler;
import com.zhangke.websocket.WebSocketManager;
import com.zhangke.websocket.util.LogUtil;
import com.zhangke.websocket.util.PermissionUtil;
import java.util.Map;

public class NetworkChangedReceiver
extends BroadcastReceiver {
    private static final String TAG = "WSNetworkReceiver";

    public void onReceive(Context context, Intent intent) {
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
            ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
            if (manager == null) {
                return;
            }
            try {
                NetworkInfo activeNetwork;
                if (PermissionUtil.checkPermission(context, "android.permission.ACCESS_NETWORK_STATE") && (activeNetwork = manager.getActiveNetworkInfo()) != null) {
                    if (activeNetwork.isConnected()) {
                        if (activeNetwork.getType() == 1) {
                            LogUtil.i(TAG, "\u7f51\u7edc\u8fde\u63a5\u53d1\u751f\u53d8\u5316\uff0c\u5f53\u524dWiFi\u8fde\u63a5\u53ef\u7528\uff0c\u6b63\u5728\u5c1d\u8bd5\u91cd\u8fde\u3002");
                        } else if (activeNetwork.getType() == 0) {
                            LogUtil.i(TAG, "\u7f51\u7edc\u8fde\u63a5\u53d1\u751f\u53d8\u5316\uff0c\u5f53\u524d\u79fb\u52a8\u8fde\u63a5\u53ef\u7528\uff0c\u6b63\u5728\u5c1d\u8bd5\u91cd\u8fde\u3002");
                        }
                        if (WebSocketHandler.getDefault() != null && WebSocketHandler.getDefault().getSetting().reconnectWithNetworkChanged()) {
                            WebSocketHandler.getDefault().reconnect();
                        }
                        if (!WebSocketHandler.getAllWebSocket().isEmpty()) {
                            Map<String, WebSocketManager> webSocketManagerMap = WebSocketHandler.getAllWebSocket();
                            for (String key : webSocketManagerMap.keySet()) {
                                WebSocketManager item = webSocketManagerMap.get(key);
                                if (item == null || !item.getSetting().reconnectWithNetworkChanged()) continue;
                                item.reconnect();
                            }
                        }
                    } else {
                        LogUtil.i(TAG, "\u5f53\u524d\u6ca1\u6709\u53ef\u7528\u7f51\u7edc");
                    }
                }
            }
            catch (Exception e) {
                LogUtil.e(TAG, "\u7f51\u7edc\u72b6\u6001\u83b7\u53d6\u9519\u8bef", e);
            }
        }
    }
}

