/*
 * Decompiled with CFR 0.152.
 */
package com.zhangke.websocket;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.util.Log;
import com.zhangke.websocket.ErrorResponse;
import com.zhangke.websocket.IWebSocketPage;
import com.zhangke.websocket.Response;
import com.zhangke.websocket.ResponseDelivery;
import com.zhangke.websocket.SocketListener;
import com.zhangke.websocket.WebSocketService;
import com.zhangke.websocket.WebSocketSetting;

public class WebSocketServiceConnectManager {
    private static final String TAG = "WebSocketLib";
    private Context context;
    private IWebSocketPage webSocketPage;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private boolean webSocketServiceBindSuccess = false;
    protected WebSocketService mWebSocketService;
    private int bindTime = 0;
    private boolean binding = false;
    protected ServiceConnection mWebSocketServiceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            WebSocketServiceConnectManager.this.webSocketServiceBindSuccess = true;
            WebSocketServiceConnectManager.this.binding = false;
            WebSocketServiceConnectManager.this.bindTime = 0;
            WebSocketServiceConnectManager.this.mWebSocketService = ((WebSocketService.ServiceBinder)service).getService();
            WebSocketServiceConnectManager.this.mWebSocketService.addListener(WebSocketServiceConnectManager.this.mSocketListener);
            WebSocketServiceConnectManager.this.webSocketPage.onServiceBindSuccess();
        }

        public void onServiceDisconnected(ComponentName name) {
            WebSocketServiceConnectManager.this.binding = false;
            WebSocketServiceConnectManager.this.webSocketServiceBindSuccess = false;
            Log.e((String)WebSocketServiceConnectManager.TAG, (String)("onServiceDisconnected:" + name));
            if (WebSocketServiceConnectManager.this.bindTime < 5 && !WebSocketServiceConnectManager.this.binding) {
                Log.d((String)WebSocketServiceConnectManager.TAG, (String)String.format("WebSocketService \u8fde\u63a5\u65ad\u5f00\uff0c\u5f00\u59cb\u7b2c%s\u6b21\u91cd\u8fde", WebSocketServiceConnectManager.this.bindTime));
                WebSocketServiceConnectManager.this.bindService();
            }
        }
    };
    private SocketListener mSocketListener = new SocketListener(){

        @Override
        public void onConnected() {
            WebSocketServiceConnectManager.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    WebSocketServiceConnectManager.this.webSocketPage.onConnected();
                }
            });
        }

        @Override
        public void onConnectError(final Throwable cause) {
            WebSocketServiceConnectManager.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    WebSocketServiceConnectManager.this.webSocketPage.onConnectError(cause);
                }
            });
        }

        @Override
        public void onDisconnected() {
            WebSocketServiceConnectManager.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    WebSocketServiceConnectManager.this.webSocketPage.onDisconnected();
                }
            });
        }

        @Override
        public void onMessageResponse(final Response message) {
            WebSocketServiceConnectManager.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    WebSocketServiceConnectManager.this.webSocketPage.onMessageResponse(message);
                }
            });
        }

        @Override
        public void onSendMessageError(final ErrorResponse error) {
            WebSocketServiceConnectManager.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    WebSocketServiceConnectManager.this.webSocketPage.onSendMessageError(error);
                }
            });
        }
    };

    public WebSocketServiceConnectManager(Context context, IWebSocketPage webSocketPage) {
        this.context = context;
        this.webSocketPage = webSocketPage;
        this.webSocketServiceBindSuccess = false;
    }

    public void onCreate() {
        for (int i = 0; i < 10; ++i) {
            this.bindService();
        }
    }

    private void bindService() {
        this.binding = true;
        this.webSocketServiceBindSuccess = false;
        Intent intent = new Intent(this.context, WebSocketService.class);
        this.context.bindService(intent, this.mWebSocketServiceConnection, 1);
        ++this.bindTime;
    }

    public void sendText(String text) {
        if (this.webSocketServiceBindSuccess && this.mWebSocketService != null) {
            this.mWebSocketService.sendText(text);
        } else {
            ErrorResponse errorResponse = new ErrorResponse();
            errorResponse.setErrorCode(2);
            errorResponse.setCause(new Throwable("WebSocketService dose not bind!"));
            errorResponse.setRequestText(text);
            ResponseDelivery delivery = new ResponseDelivery();
            delivery.addListener(this.mSocketListener);
            WebSocketSetting.getResponseProcessDelivery().onSendMessageError(errorResponse, delivery);
            if (!this.binding) {
                this.bindTime = 0;
                Log.d((String)TAG, (String)String.format("WebSocketService \u8fde\u63a5\u65ad\u5f00\uff0c\u5f00\u59cb\u7b2c%s\u6b21\u91cd\u8fde", this.bindTime));
                this.bindService();
            }
        }
    }

    public void reconnect() {
        if (this.webSocketServiceBindSuccess && this.mWebSocketService != null) {
            this.mWebSocketService.reconnect();
        } else {
            ErrorResponse errorResponse = new ErrorResponse();
            errorResponse.setErrorCode(2);
            errorResponse.setCause(new Throwable("WebSocketService dose not bind!"));
            ResponseDelivery delivery = new ResponseDelivery();
            delivery.addListener(this.mSocketListener);
            WebSocketSetting.getResponseProcessDelivery().onSendMessageError(errorResponse, delivery);
            if (!this.binding) {
                this.bindTime = 0;
                Log.d((String)TAG, (String)String.format("WebSocketService \u8fde\u63a5\u65ad\u5f00\uff0c\u5f00\u59cb\u7b2c%s\u6b21\u91cd\u8fde", this.bindTime));
                this.bindService();
            }
        }
    }

    public void onDestroy() {
        this.binding = false;
        this.bindTime = 0;
        this.context.unbindService(this.mWebSocketServiceConnection);
        Log.d((String)TAG, (String)(this.context.toString() + "\u5df2\u89e3\u9664 WebSocketService \u7ed1\u5b9a"));
        this.webSocketServiceBindSuccess = false;
        this.mWebSocketService.removeListener(this.mSocketListener);
    }
}

