/*
 * Decompiled with CFR 0.152.
 */
package com.zhangke.websocket;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.annotation.RequiresPermission;
import android.util.Log;
import com.zhangke.websocket.WebSocketService;

public class NetworkChangedReceiver
extends BroadcastReceiver {
    private static final String LOGTAG = "NetworkChangedReceiver";
    private WebSocketService socketService;

    public NetworkChangedReceiver() {
    }

    public NetworkChangedReceiver(WebSocketService socketService) {
        this.socketService = socketService;
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public void onReceive(Context context, Intent intent) {
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
            ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
            if (manager == null) {
                return;
            }
            NetworkInfo activeNetwork = manager.getActiveNetworkInfo();
            if (activeNetwork != null) {
                if (activeNetwork.isConnected()) {
                    if (activeNetwork.getType() == 1) {
                        Log.i((String)LOGTAG, (String)"\u7f51\u7edc\u8fde\u63a5\u53d1\u751f\u53d8\u5316\uff0c\u5f53\u524dWiFi\u8fde\u63a5\u53ef\u7528\uff0c\u6b63\u5728\u5c1d\u8bd5\u91cd\u8fde\u3002");
                    } else if (activeNetwork.getType() == 0) {
                        Log.i((String)LOGTAG, (String)"\u7f51\u7edc\u8fde\u63a5\u53d1\u751f\u53d8\u5316\uff0c\u5f53\u524d\u79fb\u52a8\u8fde\u63a5\u53ef\u7528\uff0c\u6b63\u5728\u5c1d\u8bd5\u91cd\u8fde\u3002");
                    }
                    if (this.socketService != null) {
                        this.socketService.reconnect();
                    }
                } else {
                    Log.i((String)LOGTAG, (String)"\u5f53\u524d\u6ca1\u6709\u53ef\u7528\u7f51\u7edc");
                }
            }
        }
    }
}

