/*
 * Decompiled with CFR 0.152.
 */
package com.zhangke.websocket;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.util.Log;
import com.zhangke.websocket.ErrorResponse;
import com.zhangke.websocket.IWebSocketPage;
import com.zhangke.websocket.Response;
import com.zhangke.websocket.SocketListener;
import com.zhangke.websocket.WebSocketService;

public class WebSocketServiceConnectManager {
    private static final String TAG = "WebSocketLib";
    private Context context;
    private IWebSocketPage webSocketPage;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private boolean webSocketServiceBindSuccess;
    protected WebSocketService mWebSocketService;
    protected ServiceConnection mWebSocketServiceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            WebSocketServiceConnectManager.this.webSocketServiceBindSuccess = true;
            WebSocketServiceConnectManager.this.webSocketPage.onServiceBindSuccess();
            WebSocketServiceConnectManager.this.mWebSocketService = ((WebSocketService.ServiceBinder)service).getService();
            WebSocketServiceConnectManager.this.mWebSocketService.addListener(WebSocketServiceConnectManager.this.mSocketListener);
        }

        public void onServiceDisconnected(ComponentName name) {
            WebSocketServiceConnectManager.this.webSocketServiceBindSuccess = false;
            Log.e((String)WebSocketServiceConnectManager.TAG, (String)("onServiceDisconnected:" + name));
        }
    };
    private SocketListener mSocketListener = new SocketListener(){

        @Override
        public void onConnected() {
            WebSocketServiceConnectManager.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    WebSocketServiceConnectManager.this.webSocketPage.onConnected();
                }
            });
        }

        @Override
        public void onConnectError(final Throwable cause) {
            WebSocketServiceConnectManager.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    WebSocketServiceConnectManager.this.webSocketPage.onConnectError(cause);
                }
            });
        }

        @Override
        public void onDisconnected() {
            WebSocketServiceConnectManager.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    WebSocketServiceConnectManager.this.webSocketPage.onDisconnected();
                }
            });
        }

        @Override
        public void onMessageResponse(final Response message) {
            WebSocketServiceConnectManager.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    WebSocketServiceConnectManager.this.webSocketPage.onMessageResponse(message);
                }
            });
        }

        @Override
        public void onSendMessageError(final ErrorResponse error) {
            WebSocketServiceConnectManager.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    WebSocketServiceConnectManager.this.webSocketPage.onSendMessageError(error);
                }
            });
        }
    };

    public WebSocketServiceConnectManager(Context context, IWebSocketPage webSocketPage) {
        this.context = context;
        this.webSocketPage = webSocketPage;
        this.webSocketServiceBindSuccess = false;
    }

    public void onCreate() {
        Intent intent = new Intent(this.context, WebSocketService.class);
        this.context.bindService(intent, this.mWebSocketServiceConnection, 1);
    }

    public void sendText(String text) {
        if (this.webSocketServiceBindSuccess && this.mWebSocketService != null) {
            this.mWebSocketService.sendText(text);
        } else {
            ErrorResponse errorResponse = new ErrorResponse();
            errorResponse.setErrorCode(2);
            errorResponse.setCause(new Throwable("WebSocketService dose not bind!"));
            errorResponse.setRequestText(text);
            this.mSocketListener.onSendMessageError(errorResponse);
        }
    }

    public void reconnect() {
        if (this.mWebSocketService == null) {
            this.mSocketListener.onConnectError(new Throwable("WebSocket dose not ready"));
        } else {
            this.mWebSocketService.reconnect();
        }
    }

    public void onDestroy() {
        this.context.unbindService(this.mWebSocketServiceConnection);
        this.webSocketServiceBindSuccess = false;
        this.mWebSocketService.removeListener(this.mSocketListener);
    }
}

