/*
 * Decompiled with CFR 0.152.
 */
package com.zhangke.websocket;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import com.zhangke.websocket.ErrorResponse;
import com.zhangke.websocket.ReconnectManager;
import com.zhangke.websocket.SocketListener;
import com.zhangke.websocket.TextResponse;
import com.zhangke.websocket.WebSocketSetting;
import java.net.URI;
import java.net.URISyntaxException;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.exceptions.WebsocketNotConnectedException;
import org.java_websocket.handshake.ServerHandshake;

public class WebSocketThread
extends Thread {
    private static final String TAG = "WebSocketLib";
    private String connectUrl;
    private WebSocketClient mWebSocket;
    private WebSocketHandler mHandler;
    private boolean quit;
    private SocketListener mSocketListener;
    private ReconnectManager mReconnectManager;
    private int connectStatus = 0;

    WebSocketThread(String connectUrl) {
        this.connectUrl = connectUrl;
        this.mReconnectManager = new ReconnectManager(this);
    }

    @Override
    public void run() {
        super.run();
        Looper.prepare();
        this.quit = false;
        this.mHandler = new WebSocketHandler();
        this.mHandler.sendEmptyMessage(0);
        Looper.loop();
    }

    public Handler getHandler() {
        return this.mHandler;
    }

    public WebSocketClient getSocket() {
        return this.mWebSocket;
    }

    public void setSocketListener(SocketListener socketListener) {
        this.mSocketListener = socketListener;
    }

    public int getConnectState() {
        return this.connectStatus;
    }

    public void reconnect() {
        this.mReconnectManager.performReconnect();
    }

    private class WebSocketHandler
    extends Handler {
        private WebSocketHandler() {
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 0: {
                    this.connect();
                    break;
                }
                case 1: {
                    this.disconnect();
                    break;
                }
                case 2: {
                    this.quit();
                    break;
                }
                case 4: {
                    if (WebSocketThread.this.mSocketListener == null || !(msg.obj instanceof String)) break;
                    WebSocketThread.this.mSocketListener.onMessageResponse(new TextResponse((String)msg.obj));
                    break;
                }
                case 3: {
                    if (!(msg.obj instanceof String)) break;
                    String message = (String)msg.obj;
                    if (WebSocketThread.this.mWebSocket != null && WebSocketThread.this.connectStatus == 2) {
                        this.send(message);
                        break;
                    }
                    if (WebSocketThread.this.mSocketListener == null) break;
                    ErrorResponse errorResponse = new ErrorResponse();
                    errorResponse.setErrorCode(1);
                    errorResponse.setCause(new Throwable("WebSocket does not connect or closed!"));
                    errorResponse.setRequestText(message);
                    WebSocketThread.this.mSocketListener.onSendMessageError(errorResponse);
                    WebSocketThread.this.mReconnectManager.performReconnect();
                }
            }
        }

        private void connect() {
            block6: {
                if (WebSocketThread.this.connectStatus == 0) {
                    WebSocketThread.this.connectStatus = 1;
                    try {
                        if (WebSocketThread.this.mWebSocket == null) {
                            if (TextUtils.isEmpty((CharSequence)WebSocketSetting.getConnectUrl())) {
                                throw new RuntimeException("WebSocket connect url is empty!");
                            }
                            WebSocketThread.this.mWebSocket = new WebSocketClient(new URI(WebSocketThread.this.connectUrl), (Draft)new Draft_6455()){

                                public void onOpen(ServerHandshake handShakeData) {
                                    WebSocketThread.this.connectStatus = 2;
                                    Log.d((String)WebSocketThread.TAG, (String)"WebSocket \u8fde\u63a5\u6210\u529f");
                                    if (WebSocketThread.this.mSocketListener != null) {
                                        WebSocketThread.this.mSocketListener.onConnected();
                                    }
                                }

                                public void onMessage(String message) {
                                    WebSocketThread.this.connectStatus = 2;
                                    Log.d((String)WebSocketThread.TAG, (String)("WebSocket \u63a5\u6536\u5230\u6d88\u606f\uff1a" + message));
                                    Message msg = WebSocketThread.this.mHandler.obtainMessage();
                                    msg.what = 4;
                                    msg.obj = message;
                                    WebSocketThread.this.mHandler.sendMessage(msg);
                                }

                                public void onClose(int code, String reason, boolean remote) {
                                    WebSocketThread.this.connectStatus = 0;
                                    Log.d((String)WebSocketThread.TAG, (String)"WebSocket \u65ad\u5f00\u8fde\u63a5");
                                    if (WebSocketThread.this.mSocketListener != null) {
                                        WebSocketThread.this.mSocketListener.onDisconnected();
                                    }
                                    WebSocketThread.this.mReconnectManager.performReconnect();
                                }

                                public void onError(Exception ex) {
                                    Log.e((String)WebSocketThread.TAG, (String)"WebSocketClient#onError(Exception)", (Throwable)ex);
                                }
                            };
                            Log.d((String)WebSocketThread.TAG, (String)"WebSocket \u5f00\u59cb\u8fde\u63a5...");
                            WebSocketThread.this.mWebSocket.connect();
                        } else {
                            Log.d((String)WebSocketThread.TAG, (String)"WebSocket \u5f00\u59cb\u91cd\u65b0\u8fde\u63a5...");
                            WebSocketThread.this.mWebSocket.reconnect();
                        }
                    }
                    catch (URISyntaxException e) {
                        WebSocketThread.this.connectStatus = 0;
                        Log.d((String)WebSocketThread.TAG, (String)"WebSocket \u8fde\u63a5\u5931\u8d25");
                        if (WebSocketThread.this.mSocketListener == null) break block6;
                        WebSocketThread.this.mSocketListener.onConnectError(e);
                    }
                }
            }
        }

        private void disconnect() {
            if (WebSocketThread.this.connectStatus == 2) {
                Log.d((String)WebSocketThread.TAG, (String)"\u6b63\u5728\u5173\u95edWebSocket\u8fde\u63a5");
                if (WebSocketThread.this.mWebSocket != null) {
                    WebSocketThread.this.mWebSocket.close();
                }
                WebSocketThread.this.connectStatus = 0;
                Log.d((String)WebSocketThread.TAG, (String)"WebSocket\u8fde\u63a5\u5df2\u5173\u95ed");
            }
        }

        private void send(String text) {
            if (WebSocketThread.this.mWebSocket != null && WebSocketThread.this.connectStatus == 2) {
                try {
                    WebSocketThread.this.mWebSocket.send(text);
                    Log.d((String)WebSocketThread.TAG, (String)("\u6570\u636e\u53d1\u9001\u6210\u529f\uff1a" + text));
                }
                catch (WebsocketNotConnectedException e) {
                    WebSocketThread.this.connectStatus = 0;
                    Log.e((String)WebSocketThread.TAG, (String)("send()" + text), (Throwable)e);
                    Log.e((String)WebSocketThread.TAG, (String)("\u8fde\u63a5\u5df2\u65ad\u5f00\uff0c\u6570\u636e\u53d1\u9001\u5931\u8d25\uff1a" + text), (Throwable)e);
                    if (WebSocketThread.this.mSocketListener != null) {
                        WebSocketThread.this.mSocketListener.onDisconnected();
                        ErrorResponse errorResponse = new ErrorResponse();
                        errorResponse.setErrorCode(1);
                        errorResponse.setCause(new Throwable("WebSocket does not connected or closed!"));
                        errorResponse.setRequestText(text);
                        WebSocketThread.this.mSocketListener.onSendMessageError(errorResponse);
                    }
                    WebSocketThread.this.mReconnectManager.performReconnect();
                }
            }
        }

        private void quit() {
            this.disconnect();
            WebSocketThread.this.mWebSocket = null;
            WebSocketThread.this.mReconnectManager.destroy();
            WebSocketThread.this.quit = true;
            WebSocketThread.this.connectStatus = 0;
            Looper looper = Looper.myLooper();
            if (looper != null) {
                looper.quit();
            }
            WebSocketThread.this.interrupt();
        }
    }
}

