/*
 * Decompiled with CFR 0.152.
 */
package com.zhangke.websocket;

import android.app.Service;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Binder;
import android.os.IBinder;
import android.os.Message;
import android.support.annotation.Nullable;
import com.zhangke.websocket.ErrorResponse;
import com.zhangke.websocket.IResponseDispatcher;
import com.zhangke.websocket.NetworkChangedReceiver;
import com.zhangke.websocket.Response;
import com.zhangke.websocket.ResponseDelivery;
import com.zhangke.websocket.SocketListener;
import com.zhangke.websocket.WebSocketSetting;
import com.zhangke.websocket.WebSocketThread;

public class WebSocketService
extends Service
implements SocketListener {
    private WebSocketThread mWebSocketThread;
    private ResponseDelivery mResponseDelivery = new ResponseDelivery();
    private IResponseDispatcher responseDispatcher;
    private boolean networkChangedReceiverRegist = false;
    private NetworkChangedReceiver networkChangedReceiver;
    private ServiceBinder serviceBinder = new ServiceBinder();

    @Nullable
    public IBinder onBind(Intent intent) {
        if (this.serviceBinder == null) {
            this.serviceBinder = new ServiceBinder();
        }
        return this.serviceBinder;
    }

    public void onCreate() {
        super.onCreate();
        this.mWebSocketThread = new WebSocketThread(WebSocketSetting.getConnectUrl());
        this.mWebSocketThread.setSocketListener(this);
        this.mWebSocketThread.start();
        this.responseDispatcher = WebSocketSetting.getResponseProcessDelivery();
        if (WebSocketSetting.isReconnectWithNetworkChanged()) {
            this.networkChangedReceiver = new NetworkChangedReceiver(this);
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            filter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
            filter.addAction("android.net.wifi.STATE_CHANGE");
            this.registerReceiver(this.networkChangedReceiver, filter);
            this.networkChangedReceiverRegist = true;
        }
    }

    public void onDestroy() {
        this.mWebSocketThread.getHandler().sendEmptyMessage(2);
        if (this.networkChangedReceiverRegist && this.networkChangedReceiver != null) {
            this.unregisterReceiver(this.networkChangedReceiver);
        }
        super.onDestroy();
    }

    public void sendText(String text) {
        if (this.mWebSocketThread.getHandler() == null) {
            ErrorResponse errorResponse = new ErrorResponse();
            errorResponse.setErrorCode(3);
            errorResponse.setCause(new Throwable("WebSocket does not initialization!"));
            errorResponse.setRequestText(text);
            this.onSendMessageError(errorResponse);
        } else {
            Message message = this.mWebSocketThread.getHandler().obtainMessage();
            message.obj = text;
            message.what = 3;
            this.mWebSocketThread.getHandler().sendMessage(message);
        }
    }

    public void addListener(SocketListener listener) {
        this.mResponseDelivery.addListener(listener);
    }

    public void removeListener(SocketListener listener) {
        this.mResponseDelivery.removeListener(listener);
    }

    public void reconnect() {
        if (this.mWebSocketThread.getHandler() == null) {
            this.onConnectError(new Throwable("WebSocket dose not ready"));
        } else {
            this.mWebSocketThread.getHandler().sendEmptyMessage(0);
        }
    }

    @Override
    public void onConnected() {
        this.responseDispatcher.onConnected(this.mResponseDelivery);
    }

    @Override
    public void onConnectError(Throwable cause) {
        this.responseDispatcher.onConnectError(cause, this.mResponseDelivery);
    }

    @Override
    public void onDisconnected() {
        this.responseDispatcher.onDisconnected(this.mResponseDelivery);
    }

    @Override
    public void onMessageResponse(Response message) {
        this.responseDispatcher.onMessageResponse(message, this.mResponseDelivery);
    }

    @Override
    public void onSendMessageError(ErrorResponse message) {
        this.responseDispatcher.onSendMessageError(message, this.mResponseDelivery);
    }

    public class ServiceBinder
    extends Binder {
        public WebSocketService getService() {
            return WebSocketService.this;
        }
    }
}

