/*
 * Decompiled with CFR 0.152.
 */
package com.zhangke.websocket;

import android.os.Handler;
import android.util.Log;
import com.zhangke.websocket.WebSocketThread;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.java_websocket.client.WebSocketClient;

public class ReconnectManager {
    private static final String TAG = "WebSocketLib";
    private WebSocketThread mWebSocketThread;
    private volatile boolean retrying;
    private volatile boolean destroyed;
    private final ExecutorService singleThreadPool = Executors.newSingleThreadExecutor();

    ReconnectManager(WebSocketThread mWebSocketThread) {
        this.mWebSocketThread = mWebSocketThread;
        this.retrying = false;
        this.destroyed = false;
    }

    synchronized void performReconnect() {
        if (this.retrying) {
            Log.i((String)TAG, (String)"\u6b63\u5728\u91cd\u8fde\uff0c\u8bf7\u52ff\u91cd\u590d\u8c03\u7528\u3002");
        } else {
            this.retry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void retry() {
        if (!this.retrying) {
            this.retrying = true;
            ExecutorService executorService = this.singleThreadPool;
            synchronized (executorService) {
                this.singleThreadPool.execute(new Runnable(){

                    @Override
                    public void run() {
                        ReconnectManager.this.retrying = true;
                        for (int i = 0; i < 20; ++i) {
                            if (ReconnectManager.this.destroyed) {
                                ReconnectManager.this.retrying = false;
                                return;
                            }
                            Handler handler = ReconnectManager.this.mWebSocketThread.getHandler();
                            WebSocketClient websocket = ReconnectManager.this.mWebSocketThread.getSocket();
                            if (handler == null || websocket == null || ReconnectManager.this.mWebSocketThread.getConnectState() == 2) break;
                            if (ReconnectManager.this.mWebSocketThread.getConnectState() == 1) continue;
                            handler.sendEmptyMessage(0);
                            try {
                                Thread.sleep(500L);
                                continue;
                            }
                            catch (InterruptedException e) {
                                Log.e((String)ReconnectManager.TAG, (String)"retry()", (Throwable)e);
                                if (ReconnectManager.this.destroyed = true) {
                                    ReconnectManager.this.retrying = false;
                                    return;
                                }
                                Thread.currentThread().interrupt();
                            }
                        }
                        ReconnectManager.this.retrying = false;
                    }
                });
            }
        }
    }

    void destroy() {
        this.destroyed = true;
        if (this.singleThreadPool != null) {
            this.singleThreadPool.shutdownNow();
        }
        this.mWebSocketThread = null;
    }
}

