/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;

public final class PluginFileUtils {
    private PluginFileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMd5ByFile(File file) throws FileNotFoundException {
        String value = null;
        FileInputStream in = new FileInputStream(file);
        try {
            MappedByteBuffer byteBuffer = in.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(byteBuffer);
            BigInteger bi = new BigInteger(1, md5.digest());
            value = bi.toString(16);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return value;
    }

    public static void cleanEmptyFile(Path path) {
        if (path == null) {
            return;
        }
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        try {
            Files.list(path).forEach(subPath -> {
                File file = subPath.toFile();
                if (!file.isFile()) {
                    return;
                }
                long length = file.length();
                if (length == 0L) {
                    try {
                        Files.deleteIfExists(subPath);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Path createExistFile(Path path) throws IOException {
        Path parent = path.getParent();
        if (!Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createFile(path, new FileAttribute[0]);
        }
        return path;
    }
}

