/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.utils;

import com.gitee.starblues.annotation.ConfigDefinition;
import org.pf4j.RuntimeMode;
import org.pf4j.util.StringUtils;

public class PluginConfigUtils {
    private static final String DO = "-";

    private PluginConfigUtils() {
    }

    public static FileNamePack getConfigFileName(ConfigDefinition configDefinition, RuntimeMode runtimeMode) {
        String fileName = configDefinition.fileName();
        if (StringUtils.isNullOrEmpty((String)fileName)) {
            return null;
        }
        String suffix = "";
        if (runtimeMode == RuntimeMode.DEPLOYMENT) {
            suffix = configDefinition.prodSuffix();
        } else if (runtimeMode == RuntimeMode.DEVELOPMENT) {
            suffix = configDefinition.devSuffix();
        }
        return new FileNamePack(fileName, suffix);
    }

    public static String joinConfigFileName(FileNamePack fileNamePack) {
        if (fileNamePack == null) {
            return null;
        }
        return PluginConfigUtils.joinConfigFileName(fileNamePack.getSourceFileName(), fileNamePack.getFileSuffix());
    }

    public static String joinConfigFileName(String fileName, String suffix) {
        String fileNamePrefixSuffix;
        String fileNamePrefix;
        if (fileName.lastIndexOf(".") == -1) {
            fileNamePrefix = fileName;
            fileNamePrefixSuffix = "";
        } else {
            int index = fileName.lastIndexOf(".");
            fileNamePrefix = fileName.substring(0, index);
            fileNamePrefixSuffix = fileName.substring(index);
        }
        if (suffix == null) {
            suffix = "";
        }
        if (!suffix.startsWith(DO)) {
            suffix = DO + suffix;
        }
        return fileNamePrefix + suffix + fileNamePrefixSuffix;
    }

    public static class FileNamePack {
        private final String sourceFileName;
        private final String fileSuffix;

        public FileNamePack(String sourceFileName, String fileSuffix) {
            this.sourceFileName = sourceFileName;
            this.fileSuffix = fileSuffix;
        }

        public String getSourceFileName() {
            return this.sourceFileName;
        }

        public String getFileSuffix() {
            return this.fileSuffix;
        }
    }
}

