/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.utils;

import com.gitee.starblues.integration.IntegrationConfiguration;
import com.gitee.starblues.utils.OrderPriority;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.pf4j.util.StringUtils;

public class CommonUtils {
    private CommonUtils() {
    }

    public static <T> List<T> order(List<T> list, Function<T, Integer> orderImpl) {
        if (list == null) {
            return list;
        }
        Collections.sort(list, Comparator.comparing(orderImpl, Comparator.nullsLast(Comparator.reverseOrder())));
        return list;
    }

    public static <T> Comparator<T> orderPriority(Function<T, OrderPriority> order) {
        return Comparator.comparing(t -> {
            OrderPriority orderPriority = (OrderPriority)order.apply(t);
            if (orderPriority == null) {
                orderPriority = OrderPriority.getLowPriority();
            }
            return orderPriority.getPriority();
        }, Comparator.nullsLast(Comparator.reverseOrder()));
    }

    public static String getPluginRestPrefix(IntegrationConfiguration configuration, String pluginId) {
        String pathPrefix = configuration.pluginRestPathPrefix();
        if (configuration.enablePluginIdRestPathPrefix()) {
            pathPrefix = pathPrefix != null && !"".equals(pathPrefix) ? CommonUtils.restJoiningPath(pathPrefix, pluginId) : pluginId;
            return pathPrefix;
        }
        if (pathPrefix == null || "".equals(pathPrefix)) {
            return null;
        }
        return pathPrefix;
    }

    public static String restJoiningPath(String path1, String path2) {
        if (path1 != null && path2 != null) {
            if (path1.endsWith("/") && path2.startsWith("/")) {
                return path1 + path2.substring(1);
            }
            if (!path1.endsWith("/") && !path2.startsWith("/")) {
                return path1 + "/" + path2;
            }
            return path1 + path2;
        }
        if (path1 != null) {
            return path1;
        }
        if (path2 != null) {
            return path2;
        }
        return "";
    }

    public static String joiningPath(String ... paths) {
        if (paths == null || paths.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int length = paths.length;
        for (int i = 0; i < length; ++i) {
            String path = paths[i];
            if (StringUtils.isNullOrEmpty((String)path)) continue;
            if (i < length - 1 && path.endsWith("/")) {
                path = path.substring(path.lastIndexOf("/"));
            }
            if (path.startsWith("/")) {
                stringBuilder.append(path);
                continue;
            }
            stringBuilder.append("/").append(path);
        }
        return stringBuilder.toString();
    }

    public static String joiningFilePath(String ... paths) {
        if (paths == null || paths.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int length = paths.length;
        for (int i = 0; i < length; ++i) {
            String path = paths[i];
            if (StringUtils.isNullOrEmpty((String)path)) continue;
            if (i > 0) {
                if (path.startsWith(File.separator) || path.startsWith("/") || path.startsWith("\\") || path.startsWith("//")) {
                    stringBuilder.append(path);
                    continue;
                }
                stringBuilder.append(File.separator).append(path);
                continue;
            }
            stringBuilder.append(path);
        }
        return stringBuilder.toString();
    }
}

