/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.integration.pf4j.descriptor;

import com.gitee.starblues.integration.pf4j.descriptor.DefaultPluginDescriptorExtend;
import com.gitee.starblues.integration.pf4j.descriptor.ResourcesPluginDescriptorFinder;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import org.pf4j.DefaultPluginDescriptor;
import org.pf4j.PluginDescriptor;
import org.pf4j.PluginRuntimeException;
import org.pf4j.PropertiesPluginDescriptorFinder;
import org.pf4j.util.FileUtils;

public class ResolvePropertiesPluginDescriptorFinder
extends PropertiesPluginDescriptorFinder {
    protected Properties readProperties(Path pluginPath) {
        Path propertiesPath = this.getPropertiesPath(pluginPath, this.propertiesFileName);
        return ResolvePropertiesPluginDescriptorFinder.getProperties(propertiesPath);
    }

    protected PluginDescriptor createPluginDescriptor(Properties properties) {
        DefaultPluginDescriptorExtend pluginDescriptor = (DefaultPluginDescriptorExtend)super.createPluginDescriptor(properties);
        return ResourcesPluginDescriptorFinder.resolvePluginDescriptor(properties, pluginDescriptor);
    }

    protected DefaultPluginDescriptor createPluginDescriptorInstance() {
        return new DefaultPluginDescriptorExtend();
    }

    public static Properties getProperties(Path propertiesPath) {
        if (propertiesPath == null) {
            throw new PluginRuntimeException("Cannot find the properties path");
        }
        if (Files.notExists(propertiesPath, new LinkOption[0])) {
            throw new PluginRuntimeException("Cannot find '{}' path", new Object[]{propertiesPath});
        }
        Properties properties = new Properties();
        try (InputStreamReader input = new InputStreamReader(Files.newInputStream(propertiesPath, new OpenOption[0]), StandardCharsets.UTF_8);){
            properties.load(input);
        }
        catch (IOException e) {
            throw new PluginRuntimeException((Throwable)e);
        }
        finally {
            FileUtils.closePath((Path)propertiesPath);
        }
        return properties;
    }
}

