/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.integration.pf4j;

import com.gitee.starblues.integration.IntegrationConfiguration;
import com.gitee.starblues.integration.pf4j.ConfigPluginStatusProvider;
import com.gitee.starblues.integration.pf4j.JarPluginLoader;
import com.gitee.starblues.integration.pf4j.Pf4jFactory;
import com.gitee.starblues.integration.pf4j.SortDependencyResolver;
import com.gitee.starblues.integration.pf4j.descriptor.ManifestPluginDescriptorFinderExtend;
import com.gitee.starblues.integration.pf4j.descriptor.ResolvePropertiesPluginDescriptorFinder;
import com.gitee.starblues.integration.pf4j.descriptor.ResourcesPluginDescriptorFinder;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.pf4j.CompoundPluginDescriptorFinder;
import org.pf4j.CompoundPluginLoader;
import org.pf4j.DefaultPluginLoader;
import org.pf4j.DefaultPluginManager;
import org.pf4j.DevelopmentPluginLoader;
import org.pf4j.PluginDescriptorFinder;
import org.pf4j.PluginLoader;
import org.pf4j.PluginManager;
import org.pf4j.PluginState;
import org.pf4j.PluginStatusProvider;
import org.pf4j.RuntimeMode;

public class DefaultPf4jFactory
implements Pf4jFactory {
    private final IntegrationConfiguration configuration;

    public DefaultPf4jFactory(IntegrationConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public PluginManager getPluginManager() {
        if (this.configuration == null) {
            throw new NullPointerException("IntegrationConfiguration is null");
        }
        RuntimeMode environment = this.configuration.environment();
        if (environment == null) {
            throw new RuntimeException("Configuration RuntimeMode is null" + this.configuration.environment());
        }
        final List<String> sortInitPluginIds = this.configuration.sortInitPluginIds();
        DefaultPluginManager defaultPluginManager = null;
        List<String> pluginDir = this.configuration.pluginPath();
        List pluginDirPath = pluginDir.stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        if (RuntimeMode.DEVELOPMENT == environment) {
            defaultPluginManager = new DefaultPluginManager(pluginDirPath){

                protected void initialize() {
                    super.initialize();
                    this.dependencyResolver = new SortDependencyResolver(sortInitPluginIds, this.versionManager);
                }

                public RuntimeMode getRuntimeMode() {
                    System.setProperty("pf4j.mode", RuntimeMode.DEVELOPMENT.toString());
                    return RuntimeMode.DEVELOPMENT;
                }

                protected PluginDescriptorFinder createPluginDescriptorFinder() {
                    return DefaultPf4jFactory.getPluginDescriptorFinder(RuntimeMode.DEVELOPMENT);
                }

                protected PluginLoader createPluginLoader() {
                    return new CompoundPluginLoader().add((PluginLoader)new DevelopmentPluginLoader((PluginManager)this), () -> (this).isDevelopment());
                }

                protected PluginStatusProvider createPluginStatusProvider() {
                    return new ConfigPluginStatusProvider(DefaultPf4jFactory.this.configuration.enablePluginIds(), DefaultPf4jFactory.this.configuration.disablePluginIds());
                }

                public PluginState stopPlugin(String pluginId) {
                    return this.stopPlugin(pluginId, DefaultPf4jFactory.this.configuration.stopDependents());
                }
            };
        } else if (RuntimeMode.DEPLOYMENT == environment) {
            defaultPluginManager = new DefaultPluginManager(pluginDirPath){

                protected void initialize() {
                    super.initialize();
                    this.dependencyResolver = new SortDependencyResolver(sortInitPluginIds, this.versionManager);
                }

                protected PluginDescriptorFinder createPluginDescriptorFinder() {
                    return DefaultPf4jFactory.getPluginDescriptorFinder(RuntimeMode.DEPLOYMENT);
                }

                protected PluginStatusProvider createPluginStatusProvider() {
                    return new ConfigPluginStatusProvider(DefaultPf4jFactory.this.configuration.enablePluginIds(), DefaultPf4jFactory.this.configuration.disablePluginIds());
                }

                protected PluginLoader createPluginLoader() {
                    return new CompoundPluginLoader().add((PluginLoader)new JarPluginLoader((PluginManager)this), () -> (this).isNotDevelopment()).add((PluginLoader)new DefaultPluginLoader((PluginManager)this), () -> (this).isNotDevelopment());
                }

                public PluginState stopPlugin(String pluginId) {
                    return this.stopPlugin(pluginId, DefaultPf4jFactory.this.configuration.stopDependents());
                }
            };
        }
        if (defaultPluginManager == null) {
            throw new RuntimeException("Not found run environment " + this.configuration.environment());
        }
        defaultPluginManager.setSystemVersion(this.configuration.version());
        defaultPluginManager.setExactVersionAllowed(this.configuration.exactVersionAllowed());
        return defaultPluginManager;
    }

    public static PluginDescriptorFinder getPluginDescriptorFinder(RuntimeMode runtimeMode) {
        if (runtimeMode == RuntimeMode.DEPLOYMENT) {
            return new CompoundPluginDescriptorFinder().add((PluginDescriptorFinder)new ResourcesPluginDescriptorFinder(runtimeMode)).add((PluginDescriptorFinder)new ManifestPluginDescriptorFinderExtend());
        }
        return new CompoundPluginDescriptorFinder().add((PluginDescriptorFinder)new ResourcesPluginDescriptorFinder(runtimeMode)).add((PluginDescriptorFinder)new ResolvePropertiesPluginDescriptorFinder()).add((PluginDescriptorFinder)new ManifestPluginDescriptorFinderExtend());
    }
}

