/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.integration.pf4j;

import java.util.HashSet;
import java.util.Set;
import org.pf4j.PluginStatusProvider;

public class ConfigPluginStatusProvider
implements PluginStatusProvider {
    private Set<String> enablePluginIds = new HashSet<String>();
    private Set<String> disabledPlugins = new HashSet<String>();

    public ConfigPluginStatusProvider() {
        this(null, null);
    }

    public ConfigPluginStatusProvider(Set<String> enablePluginIds, Set<String> disabledPluginIds) {
        if (enablePluginIds != null && !enablePluginIds.isEmpty()) {
            this.enablePluginIds.addAll(enablePluginIds);
        }
        if (disabledPluginIds != null && !disabledPluginIds.isEmpty()) {
            this.disabledPlugins.addAll(disabledPluginIds);
        }
    }

    public boolean isPluginDisabled(String pluginId) {
        if (this.disabledPlugins.contains("*")) {
            return true;
        }
        if (this.disabledPlugins.contains(pluginId)) {
            return true;
        }
        return !this.enablePluginIds.isEmpty() && !this.enablePluginIds.contains(pluginId);
    }

    public void disablePlugin(String pluginId) {
        if (this.isPluginDisabled(pluginId)) {
            return;
        }
        this.disabledPlugins.add(pluginId);
        this.enablePluginIds.remove(pluginId);
    }

    public void enablePlugin(String pluginId) {
        if (!this.isPluginDisabled(pluginId)) {
            return;
        }
        this.disabledPlugins.remove(pluginId);
        this.enablePluginIds.add(pluginId);
    }
}

