/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.integration.operator;

import com.gitee.starblues.factory.DefaultPluginFactory;
import com.gitee.starblues.factory.PluginFactory;
import com.gitee.starblues.factory.PluginRegistryInfo;
import com.gitee.starblues.integration.IntegrationConfiguration;
import com.gitee.starblues.integration.listener.PluginInitializerListener;
import com.gitee.starblues.integration.listener.PluginInitializerListenerFactory;
import com.gitee.starblues.integration.listener.PluginListenerFactory;
import com.gitee.starblues.integration.operator.PluginOperator;
import com.gitee.starblues.integration.operator.module.PluginInfo;
import com.gitee.starblues.integration.operator.verify.DefaultPluginVerify;
import com.gitee.starblues.integration.operator.verify.PluginLegalVerify;
import com.gitee.starblues.utils.GlobalRegistryInfo;
import com.gitee.starblues.utils.PluginFileUtils;
import com.gitee.starblues.utils.PluginOperatorInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.pf4j.PluginDescriptor;
import org.pf4j.PluginManager;
import org.pf4j.PluginState;
import org.pf4j.PluginWrapper;
import org.pf4j.RuntimeMode;
import org.pf4j.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class DefaultPluginOperator
implements PluginOperator {
    private boolean isInit = false;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final DateTimeFormatter FORMAT = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    protected final GenericApplicationContext applicationContext;
    protected final IntegrationConfiguration integrationConfiguration;
    protected final PluginManager pluginManager;
    protected final PluginFactory pluginFactory;
    protected final PluginInitializerListenerFactory pluginInitializerListenerFactory;
    protected PluginLegalVerify pluginLegalVerify;

    public DefaultPluginOperator(ApplicationContext applicationContext, IntegrationConfiguration integrationConfiguration, PluginManager pluginManager, PluginListenerFactory pluginListenerFactory) {
        Objects.requireNonNull(integrationConfiguration, "applicationContext can't be null");
        Objects.requireNonNull(integrationConfiguration, "IntegrationConfiguration can't be null");
        Objects.requireNonNull(pluginManager, "PluginManager can't be null");
        this.applicationContext = (GenericApplicationContext)applicationContext;
        this.integrationConfiguration = integrationConfiguration;
        this.pluginManager = pluginManager;
        this.pluginFactory = new DefaultPluginFactory(applicationContext, pluginListenerFactory);
        this.pluginInitializerListenerFactory = new PluginInitializerListenerFactory(applicationContext);
        this.pluginLegalVerify = new DefaultPluginVerify(pluginManager);
    }

    public void setUploadPluginVerify(PluginLegalVerify uploadPluginVerify) {
        if (uploadPluginVerify != null) {
            this.pluginLegalVerify = uploadPluginVerify;
        }
    }

    @Override
    public synchronized boolean initPlugins(PluginInitializerListener pluginInitializerListener) throws Exception {
        if (this.isInit) {
            throw new RuntimeException("Plugins Already initialized. Cannot be initialized again");
        }
        try {
            this.pluginInitializerListenerFactory.addPluginInitializerListeners(pluginInitializerListener);
            this.log.info("Plugins start initialize of root path '{}'", (Object)this.pluginManager.getPluginsRoot().toString());
            this.pluginInitializerListenerFactory.before();
            if (!this.integrationConfiguration.enable()) {
                this.pluginInitializerListenerFactory.complete();
                return false;
            }
            PluginFileUtils.cleanEmptyFile(this.pluginManager.getPluginsRoot());
            this.pluginFactory.initialize();
            this.pluginManager.loadPlugins();
            this.pluginManager.startPlugins();
            List pluginWrappers = this.pluginManager.getStartedPlugins();
            if (pluginWrappers == null || pluginWrappers.isEmpty()) {
                this.log.warn("Not found plugin!");
                this.pluginInitializerListenerFactory.complete();
                return false;
            }
            boolean isFoundException = false;
            for (PluginWrapper pluginWrapper : pluginWrappers) {
                String pluginId = pluginWrapper.getPluginId();
                GlobalRegistryInfo.addOperatorPluginInfo(pluginId, PluginOperatorInfo.OperatorType.INSTALL, false);
                try {
                    this.pluginFactory.registry(PluginRegistryInfo.build(pluginWrapper, this.pluginManager, this.applicationContext, true));
                }
                catch (Exception e) {
                    this.log.error("Plugin '{}' registry failure. Reason : {}", new Object[]{pluginId, e.getMessage(), e});
                    isFoundException = true;
                }
            }
            this.pluginFactory.build();
            this.isInit = true;
            if (isFoundException) {
                this.log.error("Plugins initialize failure");
                this.pluginInitializerListenerFactory.failure(new Exception("Plugins initialize failure"));
                return false;
            }
            this.log.info("Plugins initialize success");
            this.pluginInitializerListenerFactory.complete();
            return true;
        }
        catch (Exception e) {
            this.pluginInitializerListenerFactory.failure(e);
            throw e;
        }
    }

    @Override
    public boolean verify(Path jarPath) throws Exception {
        this.pluginLegalVerify.verify(jarPath);
        return true;
    }

    @Override
    public synchronized PluginInfo install(Path jarPath) throws Exception {
        PluginInfo pluginInfo;
        String pluginId;
        block21: {
            PluginDescriptor pluginDescriptor;
            block20: {
                PluginInfo pluginInfo2;
                block19: {
                    if (this.isDev()) {
                        throw new RuntimeException("Plugin cannot be installed in 'dev' environment");
                    }
                    if (jarPath == null) {
                        throw new IllegalArgumentException("Method:install param 'pluginId' can not be empty");
                    }
                    pluginId = null;
                    pluginInfo2 = this.load(jarPath);
                    if (pluginInfo2 != null) break block19;
                    this.log.error("Plugin '{}' install failure, this pluginInfo id is empty.", pluginId);
                    PluginInfo pluginInfo3 = null;
                    if (!ObjectUtils.isEmpty(pluginId)) {
                        GlobalRegistryInfo.setOperatorPluginInfo(pluginId, false);
                    }
                    return pluginInfo3;
                }
                pluginDescriptor = pluginInfo2.getPluginDescriptor();
                if (pluginDescriptor != null) break block20;
                this.log.error("Plugin install failure.");
                PluginInfo pluginInfo4 = null;
                if (!ObjectUtils.isEmpty((Object)pluginId)) {
                    GlobalRegistryInfo.setOperatorPluginInfo(pluginId, false);
                }
                return pluginInfo4;
            }
            pluginId = pluginDescriptor.getPluginId();
            GlobalRegistryInfo.addOperatorPluginInfo(pluginId, PluginOperatorInfo.OperatorType.INSTALL, true);
            if (!this.start(pluginId)) break block21;
            this.log.info("Plugin '{}' install success", (Object)pluginId);
            PluginInfo pluginInfo5 = this.getPluginInfo(pluginId);
            if (!ObjectUtils.isEmpty((Object)pluginId)) {
                GlobalRegistryInfo.setOperatorPluginInfo(pluginId, false);
            }
            return pluginInfo5;
        }
        try {
            try {
                this.uninstall(pluginId, false);
            }
            catch (Exception uninstallException) {
                this.log.error("Plugin '{}' uninstall failure. {}", (Object)pluginId, (Object)uninstallException.getMessage());
            }
            pluginInfo = null;
        }
        catch (Exception e) {
            try {
                this.log.error("Plugin '{}' install failure. {}", pluginId, (Object)e.getMessage());
                if (!ObjectUtils.isEmpty(pluginId)) {
                    try {
                        this.uninstall(pluginId, false);
                    }
                    catch (Exception uninstallException) {
                        this.log.error("Plugin '{}' uninstall failure. {}", (Object)pluginId, (Object)uninstallException.getMessage());
                    }
                }
                throw e;
            }
            catch (Throwable throwable) {
                if (!ObjectUtils.isEmpty(pluginId)) {
                    GlobalRegistryInfo.setOperatorPluginInfo(pluginId, false);
                }
                throw throwable;
            }
        }
        if (!ObjectUtils.isEmpty((Object)pluginId)) {
            GlobalRegistryInfo.setOperatorPluginInfo(pluginId, false);
        }
        return pluginInfo;
    }

    @Override
    public synchronized boolean uninstall(String pluginId, boolean isBackup) throws Exception {
        if (this.isDev()) {
            throw new RuntimeException("Plugin cannot be uninstalled in 'dev' environment");
        }
        if (ObjectUtils.isEmpty((Object)pluginId)) {
            throw new IllegalArgumentException("Method:uninstall param 'pluginId' can not be empty");
        }
        PluginWrapper pluginWrapper = this.pluginManager.getPlugin(pluginId);
        if (pluginWrapper == null) {
            throw new Exception("Plugin uninstall failure, Not found plugin '" + pluginId + "'");
        }
        Throwable exception = null;
        if (pluginWrapper.getPluginState() == PluginState.STARTED) {
            try {
                this.pluginFactory.unRegistry(pluginId);
                this.pluginFactory.build();
            }
            catch (Exception e) {
                this.log.error("Plugin '{}' uninstall failure, {}", (Object)pluginId, (Object)e.getMessage());
                exception = e;
            }
        }
        try {
            if (this.pluginManager.unloadPlugin(pluginId)) {
                Path pluginPath = pluginWrapper.getPluginPath();
                boolean opPluginFile = isBackup ? this.backup(pluginPath, "uninstall", 1) : Files.deleteIfExists(pluginPath);
                if (opPluginFile) {
                    this.log.info("Plugin '{}' uninstall success", (Object)pluginId);
                } else {
                    this.log.error("Plugin '{}' uninstall failure. process plugin file failure", (Object)pluginId);
                }
                return opPluginFile;
            }
            this.log.error("Plugin '{}' uninstall failure", (Object)pluginId);
            return false;
        }
        catch (Exception e) {
            if (exception != null) {
                exception.printStackTrace();
            }
            this.log.error("Plugin '{}' uninstall failure. {}", (Object)pluginId, (Object)e.getMessage());
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PluginInfo load(Path jarPath) throws Exception {
        if (!Files.exists(jarPath, new LinkOption[0])) {
            throw new FileNotFoundException("Not found this path " + jarPath);
        }
        this.pluginLegalVerify.verify(jarPath);
        Path pluginsRoot = this.pluginManager.getPluginsRoot();
        Path pluginPath = null;
        if (jarPath.getParent().compareTo(pluginsRoot) == 0) {
            pluginPath = jarPath;
        } else {
            File sourceFile = jarPath.toFile();
            String targetPathString = pluginsRoot.toString() + File.separator + sourceFile.getName();
            Path targetPath = Paths.get(targetPathString, new String[0]);
            if (Files.exists(targetPath, new LinkOption[0])) {
                this.backup(targetPath, "install-backup", 1);
            }
            PluginFileUtils.createExistFile(targetPath);
            Files.copy(jarPath, targetPath, StandardCopyOption.REPLACE_EXISTING);
            pluginPath = targetPath;
        }
        String pluginId = null;
        try {
            pluginId = this.pluginManager.loadPlugin(pluginPath);
            if (pluginId != null) {
                return this.getPluginInfo(pluginId);
            }
            return null;
        }
        catch (Exception e) {
            if (pluginId != null) {
                this.log.error("Load plugin success, but get pluginInfo failure. so remove plugin '{}'", (Object)pluginId);
                try {
                    this.pluginManager.unloadPlugin(pluginId);
                }
                finally {
                    Files.delete(pluginPath);
                }
            } else {
                this.log.error("Load plugin failure");
            }
            return null;
        }
    }

    @Override
    public PluginInfo load(MultipartFile pluginFile) throws Exception {
        if (this.isDev()) {
            throw new RuntimeException("Plugin cannot uploadPluginAndStart in the 'dev' environment");
        }
        if (pluginFile == null) {
            throw new IllegalArgumentException("Method:uploadPluginAndStart param 'pluginFile' can not be null");
        }
        Path jarPath = this.uploadPlugin(pluginFile);
        return this.load(jarPath);
    }

    @Override
    public boolean unload(String pluginId, boolean isBackup) throws Exception {
        PluginWrapper pluginWrapper = this.pluginManager.getPlugin(pluginId);
        if (pluginWrapper == null) {
            throw new Exception("Plugin unload failure, Not found plugin '" + pluginId + "'");
        }
        this.pluginManager.unloadPlugin(pluginId);
        if (isBackup) {
            this.backup(pluginWrapper.getPluginPath(), "unload", 1);
        }
        return true;
    }

    @Override
    public synchronized boolean start(String pluginId) throws Exception {
        if (ObjectUtils.isEmpty((Object)pluginId)) {
            throw new IllegalArgumentException("Method:start param 'pluginId' can not be empty");
        }
        PluginWrapper pluginWrapper = this.getPluginWrapper(pluginId, "Start");
        if (pluginWrapper.getPluginState() == PluginState.STARTED) {
            throw new Exception("This plugin '" + pluginId + "' have already started");
        }
        try {
            PluginState pluginState = this.pluginManager.startPlugin(pluginId);
            if (pluginState == PluginState.STARTED) {
                GlobalRegistryInfo.addOperatorPluginInfo(pluginId, PluginOperatorInfo.OperatorType.START, false);
                this.pluginFactory.registry(PluginRegistryInfo.build(pluginWrapper, this.pluginManager, this.applicationContext, false));
                this.pluginFactory.build();
                this.log.info("Plugin '{}' start success", (Object)pluginId);
                return true;
            }
            this.log.error("Plugin '{}' start failure, plugin state is not start. Current plugin state is '{}'", (Object)pluginId, (Object)pluginState.toString());
        }
        catch (Exception e) {
            this.log.error("Plugin '{}' start failure. {}", new Object[]{pluginId, e.getMessage(), e});
            this.log.info("Start stop plugin '{}'", (Object)pluginId);
            try {
                this.stop(pluginId);
            }
            catch (Exception stopException) {
                this.log.error("Plugin '{}' stop failure. {}", (Object)pluginId, (Object)e.getMessage());
            }
        }
        return false;
    }

    @Override
    public synchronized boolean stop(String pluginId) throws Exception {
        if (ObjectUtils.isEmpty((Object)pluginId)) {
            throw new IllegalArgumentException("Method:stop param 'pluginId' can not be empty");
        }
        PluginWrapper pluginWrapper = this.getPluginWrapper(pluginId, "Stop");
        if (pluginWrapper.getPluginState() != PluginState.STARTED) {
            throw new Exception("This plugin '" + pluginId + "' is not started");
        }
        try {
            this.pluginFactory.unRegistry(pluginId);
            this.pluginFactory.build();
            this.log.info("Plugin '{}' unRegistry success", (Object)pluginId);
        }
        catch (Exception e) {
            this.log.error("Plugin '{}' stop failure. {}", new Object[]{pluginId, e.getMessage(), e});
        }
        try {
            this.pluginManager.stopPlugin(pluginId);
            this.log.info("Plugin '{}' stop success", (Object)pluginId);
            return true;
        }
        catch (Exception e) {
            this.log.error("Plugin '{}' stop failure. {}", (Object)pluginId, (Object)e.getMessage());
            throw e;
        }
    }

    @Override
    public synchronized PluginInfo uploadPluginAndStart(MultipartFile pluginFile) throws Exception {
        if (this.isDev()) {
            throw new RuntimeException("Plugin cannot uploadPluginAndStart in the 'dev' environment");
        }
        if (pluginFile == null) {
            throw new IllegalArgumentException("Method:uploadPluginAndStart param 'pluginFile' can not be null");
        }
        Path path = this.uploadPlugin(pluginFile);
        return this.install(path);
    }

    @Override
    public synchronized boolean installConfigFile(Path configFilePath) throws Exception {
        if (this.isDev()) {
            throw new RuntimeException("Plugin config file cannot be installed in the 'dev' environment");
        }
        if (!Files.exists(configFilePath, new LinkOption[0])) {
            throw new FileNotFoundException("configFilePath '" + configFilePath + "'  does not exist!");
        }
        File sourceFile = configFilePath.toFile();
        String configPath = this.integrationConfiguration.pluginConfigFilePath() + File.separator + sourceFile.getName();
        Path targetPath = PluginFileUtils.createExistFile(Paths.get(configPath, new String[0]));
        if (Files.exists(targetPath, new LinkOption[0])) {
            this.backup(targetPath, "install-config-backup", 1);
        }
        Files.copy(configFilePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
        return true;
    }

    @Override
    public synchronized boolean uploadConfigFile(MultipartFile configFile) throws Exception {
        if (this.isDev()) {
            throw new RuntimeException("Plugin config file cannot be uploaded in the 'dev' environment");
        }
        if (configFile == null) {
            throw new IllegalArgumentException("Method:uploadConfigFile param 'configFile' can not be null");
        }
        String fileName = configFile.getOriginalFilename();
        String configPath = this.integrationConfiguration.pluginConfigFilePath() + File.separator + fileName;
        Path targetPath = PluginFileUtils.createExistFile(Paths.get(configPath, new String[0]));
        if (Files.exists(targetPath, new LinkOption[0])) {
            this.backup(targetPath, "upload-config-backup", 2);
        }
        Files.write(targetPath, configFile.getBytes(), new OpenOption[0]);
        return true;
    }

    @Override
    public synchronized boolean backupPlugin(Path backDirPath, String sign) throws Exception {
        if (this.isDev()) {
            throw new RuntimeException("Plugin cannot backup in the 'dev' environment");
        }
        Objects.requireNonNull(backDirPath);
        return this.backup(backDirPath, sign, 2);
    }

    @Override
    public synchronized boolean backupPlugin(String pluginId, String sign) throws Exception {
        if (this.isDev()) {
            throw new RuntimeException("Plugin cannot backup in the 'dev' environment");
        }
        PluginWrapper pluginManager = this.getPluginWrapper(pluginId, "BackupPlugin by pluginId");
        return this.backupPlugin(pluginManager.getPluginPath(), sign);
    }

    @Override
    public List<PluginInfo> getPluginInfo() {
        List startedPlugins = this.pluginManager.getPlugins();
        ArrayList<PluginInfo> pluginInfos = new ArrayList<PluginInfo>();
        if (startedPlugins == null) {
            return pluginInfos;
        }
        return startedPlugins.stream().filter(pluginWrapper -> pluginWrapper != null).map(pw -> this.getPluginInfo((PluginWrapper)pw)).collect(Collectors.toList());
    }

    @Override
    public PluginInfo getPluginInfo(String pluginId) {
        PluginWrapper pluginWrapper = this.pluginManager.getPlugin(pluginId);
        if (pluginWrapper == null) {
            this.log.warn("Not found plugin '{}'", (Object)pluginId);
            return null;
        }
        return this.getPluginInfo(pluginWrapper);
    }

    @Override
    public Set<String> getPluginFilePaths() throws Exception {
        RuntimeMode environment = this.integrationConfiguration.environment();
        if (environment == RuntimeMode.DEVELOPMENT) {
            return new HashSet<String>(this.integrationConfiguration.pluginPath());
        }
        List<String> pluginPath = this.integrationConfiguration.pluginPath();
        HashSet<String> pathString = new HashSet<String>(pluginPath.size());
        for (String path : pluginPath) {
            if (ObjectUtils.isEmpty((Object)path)) continue;
            List jars = FileUtils.getJars((Path)Paths.get(path, new String[0]));
            for (File jar : jars) {
                pathString.add(jar.getAbsolutePath());
            }
        }
        return pathString;
    }

    @Override
    public List<PluginWrapper> getPluginWrapper() {
        return this.pluginManager.getPlugins();
    }

    @Override
    public PluginWrapper getPluginWrapper(String pluginId) {
        return this.pluginManager.getPlugin(pluginId);
    }

    protected Path uploadPlugin(MultipartFile pluginFile) throws Exception {
        if (pluginFile == null) {
            throw new IllegalArgumentException("Method:uploadPlugin param 'pluginFile' can not be null");
        }
        String fileName = pluginFile.getOriginalFilename();
        String suffixName = fileName.substring(fileName.lastIndexOf(".") + 1);
        if (StringUtils.isEmpty((Object)suffixName)) {
            throw new IllegalArgumentException("Invalid file type, please select .jar or .zip file");
        }
        if (!"jar".equalsIgnoreCase(suffixName) && !"zip".equalsIgnoreCase(suffixName)) {
            throw new IllegalArgumentException("Invalid file type, please select .jar or .zip file");
        }
        String tempPathString = this.integrationConfiguration.uploadTempPath() + File.separator + fileName;
        Path tempPath = PluginFileUtils.createExistFile(Paths.get(tempPathString, new String[0]));
        Files.write(tempPath, pluginFile.getBytes(), new OpenOption[0]);
        try {
            Path verifyPath = this.pluginLegalVerify.verify(tempPath);
            if (verifyPath != null) {
                String targetPathString = this.pluginManager.getPluginsRoot().toString() + File.separator + fileName;
                Path targetPluginPath = Paths.get(targetPathString, new String[0]);
                if (Files.exists(targetPluginPath, new LinkOption[0])) {
                    this.backup(targetPluginPath, "upload", 2);
                }
                Files.copy(verifyPath, targetPluginPath, StandardCopyOption.REPLACE_EXISTING);
                Files.deleteIfExists(tempPath);
                return targetPluginPath;
            }
            Exception exception = new Exception(fileName + " verify failure, verifyPath is null");
            this.verifyFailureDelete(tempPath, exception);
            throw exception;
        }
        catch (Exception e) {
            this.verifyFailureDelete(tempPath, e);
            throw e;
        }
    }

    protected PluginWrapper getPluginWrapper(String pluginId, String errorMsg) throws Exception {
        PluginWrapper pluginWrapper = this.pluginManager.getPlugin(pluginId);
        if (pluginWrapper == null) {
            throw new Exception(errorMsg + " -> Not found plugin " + pluginId);
        }
        return pluginWrapper;
    }

    protected void verifyFailureDelete(Path tempPluginFile, Exception e) throws Exception {
        try {
            Files.deleteIfExists(tempPluginFile);
        }
        catch (IOException e1) {
            throw new Exception("Verify failure and delete temp file failure : " + e.getMessage(), e);
        }
    }

    protected boolean backup(Path sourcePath, String sign, int type) {
        try {
            File sourceFile;
            Path target;
            if (this.isDev()) {
                return false;
            }
            if (sourcePath == null) {
                return false;
            }
            if (!Files.exists(sourcePath, new LinkOption[0])) {
                this.log.error("Path '{}' does not exist", (Object)sourcePath.toString());
                return false;
            }
            String fileName = sourcePath.getFileName().toString();
            String targetName = this.integrationConfiguration.backupPath() + File.separator;
            if (!ObjectUtils.isEmpty((Object)sign)) {
                targetName = targetName + sign;
            }
            if (!Files.exists((target = Paths.get((targetName = targetName + "_" + this.getNowTimeByFormat()) + "_" + fileName, new String[0])).getParent(), new LinkOption[0])) {
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
            }
            if ((sourceFile = sourcePath.toFile()).length() == 0L) {
                return true;
            }
            if (type == 1) {
                Files.move(sourcePath, target, StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.copy(sourcePath, target, StandardCopyOption.REPLACE_EXISTING);
            }
            return true;
        }
        catch (IOException e) {
            this.log.error("Backup plugin jar '{}' failure. {}", new Object[]{sourcePath.toString(), e.getMessage(), e});
            return false;
        }
    }

    protected String getNowTimeByFormat() {
        LocalDateTime localDateTime = LocalDateTime.now();
        return FORMAT.format(localDateTime);
    }

    protected boolean isDev() {
        return this.integrationConfiguration.environment() == RuntimeMode.DEVELOPMENT;
    }

    private PluginInfo getPluginInfo(PluginWrapper pluginWrapper) {
        return new PluginInfo(pluginWrapper.getDescriptor(), pluginWrapper.getPluginState(), pluginWrapper.getPluginPath().toAbsolutePath().toString(), this.pluginManager.getRuntimeMode().toString());
    }
}

