/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.factory.process.pipe.classs.group;

import com.gitee.starblues.annotation.Extract;
import com.gitee.starblues.factory.process.pipe.classs.PluginClassGroup;
import com.gitee.starblues.factory.process.pipe.classs.group.CallerGroup;
import com.gitee.starblues.factory.process.pipe.classs.group.ConfigBeanGroup;
import com.gitee.starblues.factory.process.pipe.classs.group.ConfigDefinitionGroup;
import com.gitee.starblues.factory.process.pipe.classs.group.OneselfListenerGroup;
import com.gitee.starblues.factory.process.pipe.classs.group.SupplierGroup;
import com.gitee.starblues.realize.BasePlugin;
import com.gitee.starblues.utils.AnnotationsUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RestController;

public class ComponentGroup
implements PluginClassGroup {
    public static final String GROUP_ID = "spring_component";
    private final List<PluginClassGroup> filters = new ArrayList<PluginClassGroup>();

    public ComponentGroup() {
        this.filters.add(new ConfigDefinitionGroup());
        this.filters.add(new ConfigBeanGroup());
        this.filters.add(new OneselfListenerGroup());
        this.filters.add(new CallerGroup());
        this.filters.add(new SupplierGroup());
    }

    @Override
    public String groupId() {
        return GROUP_ID;
    }

    @Override
    public void initialize(BasePlugin basePlugin) {
    }

    @Override
    public boolean filter(Class<?> aClass) {
        boolean have = AnnotationsUtils.haveAnnotations(aClass, false, Component.class, Service.class, Controller.class, RestController.class, Configuration.class, Extract.class);
        if (!have) {
            return false;
        }
        for (PluginClassGroup filter : this.filters) {
            if (!filter.filter(aClass)) continue;
            return false;
        }
        return true;
    }
}

