/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.factory.process.pipe.bean;

import com.gitee.starblues.annotation.ConfigDefinition;
import com.gitee.starblues.factory.PluginRegistryInfo;
import com.gitee.starblues.factory.process.pipe.bean.PluginBeanRegistrar;
import com.gitee.starblues.factory.process.pipe.loader.ResourceWrapper;
import com.gitee.starblues.factory.process.pipe.loader.load.PluginConfigFileLoader;
import com.gitee.starblues.integration.IntegrationConfiguration;
import com.gitee.starblues.integration.pf4j.descriptor.DefaultPluginDescriptorExtend;
import com.gitee.starblues.realize.BasePlugin;
import com.gitee.starblues.utils.PluginConfigUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.pf4j.PluginDescriptor;
import org.pf4j.RuntimeMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.env.PropertiesPropertySourceLoader;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class SpringBootConfigFileRegistrar
implements PluginBeanRegistrar {
    private static final String ACTIVE_PROFILES_PROPERTY = "spring.profiles.active";
    private static final String INCLUDE_PROFILES_PROPERTY = "spring.profiles.include";
    private final Logger logger = LoggerFactory.getLogger(SpringBootConfigFileRegistrar.class);
    private final IntegrationConfiguration integrationConfiguration;
    private final List<PropertySourceLoader> propertySourceLoaders;

    public SpringBootConfigFileRegistrar(ApplicationContext mainApplicationContext) {
        this.integrationConfiguration = (IntegrationConfiguration)mainApplicationContext.getBean(IntegrationConfiguration.class);
        this.propertySourceLoaders = new ArrayList<PropertySourceLoader>();
        this.addPropertySourceLoader();
    }

    protected void addPropertySourceLoader() {
        this.propertySourceLoaders.add((PropertySourceLoader)new YamlPropertySourceLoader());
        this.propertySourceLoaders.add((PropertySourceLoader)new PropertiesPropertySourceLoader());
    }

    @Override
    public void registry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        ConfigurableEnvironment environment = pluginRegistryInfo.getPluginApplicationContext().getEnvironment();
        PluginConfigUtils.FileNamePack fileNamePack = this.getConfigFileName(pluginRegistryInfo);
        if (fileNamePack == null) {
            return;
        }
        String configFileName = PluginConfigUtils.joinConfigFileName(fileNamePack);
        PluginConfigFileLoader pluginConfigFileLoader = new PluginConfigFileLoader(this.integrationConfiguration.pluginConfigFilePath(), configFileName);
        ResourceWrapper resourceWrapper = pluginConfigFileLoader.load(pluginRegistryInfo);
        List<Resource> resources = resourceWrapper.getResources();
        if (ObjectUtils.isEmpty(resources)) {
            return;
        }
        List<PropertySource<?>> propProfiles = this.getPropProfiles(resources);
        if (ObjectUtils.isEmpty(propProfiles)) {
            return;
        }
        for (PropertySource<?> propertySource : propProfiles) {
            environment.getPropertySources().addLast(propertySource);
        }
        List<Profile> profiles = this.getProfiles((Environment)environment);
        if (!ObjectUtils.isEmpty(profiles)) {
            this.loadProfilesConfig(pluginRegistryInfo, fileNamePack, environment, profiles);
        }
    }

    private PluginConfigUtils.FileNamePack getConfigFileName(PluginRegistryInfo pluginRegistryInfo) {
        DefaultPluginDescriptorExtend descriptorExtend;
        String configFileName;
        PluginDescriptor descriptor = pluginRegistryInfo.getPluginWrapper().getDescriptor();
        if (descriptor instanceof DefaultPluginDescriptorExtend && !ObjectUtils.isEmpty((Object)(configFileName = (descriptorExtend = (DefaultPluginDescriptorExtend)descriptor).getConfigFileName()))) {
            return new PluginConfigUtils.FileNamePack(configFileName, descriptorExtend.getConfigFileProfile());
        }
        BasePlugin basePlugin = pluginRegistryInfo.getBasePlugin();
        ConfigDefinition configDefinition = ((Object)((Object)basePlugin)).getClass().getAnnotation(ConfigDefinition.class);
        if (configDefinition == null) {
            return null;
        }
        RuntimeMode runtimeMode = pluginRegistryInfo.getPluginWrapper().getRuntimeMode();
        return PluginConfigUtils.getConfigFileName(configDefinition, runtimeMode);
    }

    private List<PropertySource<?>> getPropProfiles(List<Resource> resources) throws IOException {
        ArrayList propProfiles = new ArrayList();
        if (resources == null || resources.isEmpty()) {
            return propProfiles;
        }
        for (Resource resource : resources) {
            if (resource == null || !resource.exists()) continue;
            String filename = resource.getFilename();
            if (ObjectUtils.isEmpty((Object)filename)) {
                this.logger.error("File name is empty!");
                return null;
            }
            for (PropertySourceLoader propertySourceLoader : this.propertySourceLoaders) {
                List propertySources;
                if (!this.canLoadFileExtension(propertySourceLoader, filename) || ObjectUtils.isEmpty((Object)(propertySources = propertySourceLoader.load(filename, resource)))) continue;
                propProfiles.addAll(propertySources);
            }
        }
        return propProfiles;
    }

    private void loadProfilesConfig(PluginRegistryInfo pluginRegistryInfo, PluginConfigUtils.FileNamePack fileNamePack, ConfigurableEnvironment environment, List<Profile> profiles) throws Exception {
        for (Profile profile2 : profiles) {
            String name = profile2.getName();
            String fileName = PluginConfigUtils.joinConfigFileName(fileNamePack.getSourceFileName(), name);
            PluginConfigFileLoader pluginConfigFileLoader = new PluginConfigFileLoader(this.integrationConfiguration.pluginConfigFilePath(), fileName);
            ResourceWrapper resourceWrapper = pluginConfigFileLoader.load(pluginRegistryInfo);
            List<Resource> resources = resourceWrapper.getResources();
            if (ObjectUtils.isEmpty(resources)) continue;
            List<PropertySource<?>> propProfiles = this.getPropProfiles(resources);
            if (ObjectUtils.isEmpty(propProfiles)) {
                return;
            }
            for (PropertySource<?> propertySource : propProfiles) {
                environment.getPropertySources().addLast(propertySource);
            }
        }
        String[] names = (String[])profiles.stream().filter(profile -> profile != null && !profile.isDefaultProfile()).map(Profile::getName).toArray(String[]::new);
        environment.setActiveProfiles(names);
    }

    private boolean canLoadFileExtension(PropertySourceLoader loader, String name) {
        return Arrays.stream(loader.getFileExtensions()).anyMatch(fileExtension -> StringUtils.endsWithIgnoreCase((String)name, (String)fileExtension));
    }

    private List<Profile> getProfiles(Environment environment) {
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        Set<Profile> activatedViaProperty = this.getProfilesActivatedViaProperty(environment);
        profiles.addAll(this.getOtherActiveProfiles(environment, activatedViaProperty));
        profiles.addAll(activatedViaProperty);
        profiles.removeIf(profile -> profile != null && profile.isDefaultProfile());
        return profiles;
    }

    private Set<Profile> getProfilesActivatedViaProperty(Environment environment) {
        if (!environment.containsProperty(ACTIVE_PROFILES_PROPERTY) && !environment.containsProperty(INCLUDE_PROFILES_PROPERTY)) {
            return Collections.emptySet();
        }
        Binder binder = Binder.get((Environment)environment);
        LinkedHashSet<Profile> activeProfiles = new LinkedHashSet<Profile>();
        activeProfiles.addAll(this.getProfiles(binder, INCLUDE_PROFILES_PROPERTY));
        activeProfiles.addAll(this.getProfiles(binder, ACTIVE_PROFILES_PROPERTY));
        return activeProfiles;
    }

    private List<Profile> getOtherActiveProfiles(Environment environment, Set<Profile> activatedViaProperty) {
        return Arrays.stream(environment.getActiveProfiles()).map(Profile::new).filter(profile -> !activatedViaProperty.contains(profile)).collect(Collectors.toList());
    }

    private Set<Profile> getProfiles(Binder binder, String name) {
        return (Set)binder.bind(name, String[].class).map(this::asProfileSet).orElse(Collections.emptySet());
    }

    private Set<Profile> asProfileSet(String[] profileNames) {
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        for (String profileName : profileNames) {
            profiles.add(new Profile(profileName));
        }
        return new LinkedHashSet<Profile>(profiles);
    }

    private static class Profile {
        private final String name;
        private final boolean defaultProfile;

        Profile(String name) {
            this(name, false);
        }

        Profile(String name, boolean defaultProfile) {
            Assert.notNull((Object)name, (String)"Name must not be null");
            this.name = name;
            this.defaultProfile = defaultProfile;
        }

        public String getName() {
            return this.name;
        }

        public boolean isDefaultProfile() {
            return this.defaultProfile;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            return ((Profile)obj).name.equals(this.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }
}

