/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.factory.process.pipe;

import com.gitee.starblues.extension.ExtensionInitializer;
import com.gitee.starblues.factory.PluginRegistryInfo;
import com.gitee.starblues.factory.process.pipe.PluginConfigBeanPipeProcessor;
import com.gitee.starblues.factory.process.pipe.PluginInterceptorsPipeProcessor;
import com.gitee.starblues.factory.process.pipe.PluginOneselfStopEventProcessor;
import com.gitee.starblues.factory.process.pipe.PluginPipeApplicationContextProcessor;
import com.gitee.starblues.factory.process.pipe.PluginPipeProcessor;
import com.gitee.starblues.factory.process.pipe.classs.PluginClassProcess;
import com.gitee.starblues.factory.process.pipe.extract.PluginExtractPipeProcessor;
import com.gitee.starblues.factory.process.pipe.loader.PluginResourceLoadFactory;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class PluginPipeProcessorFactory
implements PluginPipeProcessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ApplicationContext mainApplicationContext;
    private final List<PluginPipeProcessor> pluginPipeProcessors = new ArrayList<PluginPipeProcessor>();

    public PluginPipeProcessorFactory(ApplicationContext mainApplicationContext) {
        this.mainApplicationContext = mainApplicationContext;
    }

    @Override
    public void initialize() throws Exception {
        this.pluginPipeProcessors.add(new PluginOneselfStopEventProcessor());
        this.pluginPipeProcessors.add(new PluginResourceLoadFactory());
        this.pluginPipeProcessors.add(new PluginClassProcess());
        this.pluginPipeProcessors.addAll(ExtensionInitializer.getPreProcessorExtends());
        this.pluginPipeProcessors.add(new PluginPipeApplicationContextProcessor(this.mainApplicationContext));
        this.pluginPipeProcessors.add(new PluginInterceptorsPipeProcessor(this.mainApplicationContext));
        this.pluginPipeProcessors.add(new PluginConfigBeanPipeProcessor());
        this.pluginPipeProcessors.add(new PluginExtractPipeProcessor(this.mainApplicationContext));
        this.pluginPipeProcessors.addAll(ExtensionInitializer.getPipeProcessorExtends());
        for (PluginPipeProcessor pluginPipeProcessor : this.pluginPipeProcessors) {
            pluginPipeProcessor.initialize();
        }
    }

    @Override
    public void registry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        for (PluginPipeProcessor pluginPipeProcessor : this.pluginPipeProcessors) {
            pluginPipeProcessor.registry(pluginRegistryInfo);
        }
    }

    @Override
    public void unRegistry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        boolean findException = false;
        for (PluginPipeProcessor pluginPipeProcessor : this.pluginPipeProcessors) {
            try {
                pluginPipeProcessor.unRegistry(pluginRegistryInfo);
            }
            catch (Exception e) {
                findException = true;
                this.logger.error("unRegistry plugin '{}' failure by {}", new Object[]{pluginRegistryInfo.getPluginWrapper().getPluginId(), pluginPipeProcessor.getClass().getName(), e});
            }
        }
        if (findException) {
            throw new Exception("UnRegistry plugin '" + pluginRegistryInfo.getPluginWrapper().getPluginId() + "'failure");
        }
    }
}

