/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.factory.process.pipe;

import com.gitee.starblues.extension.ExtensionInitializer;
import com.gitee.starblues.factory.PluginRegistryInfo;
import com.gitee.starblues.factory.process.pipe.PluginInfoContainers;
import com.gitee.starblues.factory.process.pipe.PluginPipeProcessor;
import com.gitee.starblues.factory.process.pipe.bean.BasicBeanRegistrar;
import com.gitee.starblues.factory.process.pipe.bean.ConfigBeanRegistrar;
import com.gitee.starblues.factory.process.pipe.bean.ConfigFileBeanRegistrar;
import com.gitee.starblues.factory.process.pipe.bean.InvokeBeanRegistrar;
import com.gitee.starblues.factory.process.pipe.bean.PluginBeanRegistrar;
import com.gitee.starblues.factory.process.pipe.bean.PluginInsetBeanRegistrar;
import com.gitee.starblues.factory.process.pipe.bean.SpringBootConfigFileRegistrar;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.util.ObjectUtils;

public class PluginPipeApplicationContextProcessor
implements PluginPipeProcessor {
    private static final Logger logger = LoggerFactory.getLogger(PluginPipeApplicationContextProcessor.class);
    private final List<PluginBeanRegistrar> pluginBeanDefinitionRegistrars = new ArrayList<PluginBeanRegistrar>();
    private final ApplicationContext mainApplicationContext;

    public PluginPipeApplicationContextProcessor(ApplicationContext mainApplicationContext) {
        this.mainApplicationContext = mainApplicationContext;
    }

    @Override
    public void initialize() throws Exception {
        this.pluginBeanDefinitionRegistrars.add(new SpringBootConfigFileRegistrar(this.mainApplicationContext));
        this.pluginBeanDefinitionRegistrars.add(new PluginInsetBeanRegistrar());
        this.pluginBeanDefinitionRegistrars.add(new ConfigBeanRegistrar());
        this.pluginBeanDefinitionRegistrars.add(new ConfigFileBeanRegistrar(this.mainApplicationContext));
        this.pluginBeanDefinitionRegistrars.add(new BasicBeanRegistrar());
        this.pluginBeanDefinitionRegistrars.add(new InvokeBeanRegistrar());
        this.pluginBeanDefinitionRegistrars.addAll(ExtensionInitializer.getPluginBeanRegistrarExtends());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        GenericApplicationContext pluginApplicationContext = pluginRegistryInfo.getPluginApplicationContext();
        for (PluginBeanRegistrar pluginBeanDefinitionRegistrar : this.pluginBeanDefinitionRegistrars) {
            pluginBeanDefinitionRegistrar.registry(pluginRegistryInfo);
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            this.installPluginAutoConfiguration(pluginApplicationContext, pluginRegistryInfo);
            pluginApplicationContext.refresh();
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        String pluginId = pluginRegistryInfo.getPluginWrapper().getPluginId();
        PluginInfoContainers.addPluginApplicationContext(pluginId, pluginApplicationContext);
    }

    private void installPluginAutoConfiguration(GenericApplicationContext pluginApplicationContext, PluginRegistryInfo pluginRegistryInfo) throws ClassNotFoundException {
        Set installAutoConfigClassString = (Set)pluginRegistryInfo.getPluginBinder().bind("plugin.auto-config-class", Bindable.setOf(String.class)).orElseGet(() -> null);
        if (ObjectUtils.isEmpty((Object)installAutoConfigClassString)) {
            return;
        }
        AutoConfigurationPackages.register((BeanDefinitionRegistry)pluginApplicationContext.getDefaultListableBeanFactory(), (String[])new String[]{pluginRegistryInfo.getBasePlugin().scanPackage()});
        HashSet autoConfigurationClassSet = new HashSet(installAutoConfigClassString.size());
        ClassLoader pluginClassLoader = pluginRegistryInfo.getPluginClassLoader();
        for (String string : installAutoConfigClassString) {
            Class<?> aClass = Class.forName(string, false, pluginClassLoader);
            autoConfigurationClassSet.add(aClass);
        }
        for (Class clazz : autoConfigurationClassSet) {
            pluginApplicationContext.registerBean(clazz, new BeanDefinitionCustomizer[0]);
        }
    }

    @Override
    public void unRegistry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        for (PluginBeanRegistrar registrar : this.pluginBeanDefinitionRegistrars) {
            try {
                registrar.unRegistry(pluginRegistryInfo);
            }
            catch (Exception e) {
                logger.error("Plugin '{}'-'{}' unRegistry failure.", (Object)pluginRegistryInfo.getPluginWrapper().getPluginId(), (Object)registrar.getClass().getName());
            }
        }
    }
}

