/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.realize;

import com.gitee.starblues.loader.PluginResourceLoadFactory;
import com.gitee.starblues.realize.BasePlugin;

public final class BasePluginExtend {
    private final BasePlugin basePlugin;
    private final PluginResourceLoadFactory pluginResourceLoadFactory;
    private Long startTimestamp;
    private Long stopTimestamp;

    BasePluginExtend(BasePlugin basePlugin) {
        this.basePlugin = basePlugin;
        this.pluginResourceLoadFactory = new PluginResourceLoadFactory();
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public Long getStopTimestamp() {
        return this.stopTimestamp;
    }

    public PluginResourceLoadFactory getPluginResourceLoadFactory() {
        return this.pluginResourceLoadFactory;
    }

    void startEvent() {
        try {
            this.pluginResourceLoadFactory.load(this.basePlugin);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.startTimestamp = System.currentTimeMillis();
        }
    }

    void deleteEvent() {
        try {
            this.pluginResourceLoadFactory.unload(this.basePlugin);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void stopEvent() {
        try {
            this.pluginResourceLoadFactory.unload(this.basePlugin);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.stopTimestamp = System.currentTimeMillis();
        }
    }
}

