/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.integration.listener;

import com.gitee.starblues.integration.listener.PluginListener;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.context.support.GenericApplicationContext;

public class PluginListenerFactory
implements PluginListener {
    private final List<PluginListener> listeners = new ArrayList<PluginListener>();
    private final List<Class> listenerClasses = new ArrayList<Class>();

    @Override
    public void registry(String pluginId) {
        for (PluginListener listener : this.listeners) {
            try {
                listener.registry(pluginId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void unRegistry(String pluginId) {
        for (PluginListener listener : this.listeners) {
            try {
                listener.unRegistry(pluginId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void failure(String pluginId, Throwable throwable) {
        for (PluginListener listener : this.listeners) {
            try {
                listener.failure(pluginId, throwable);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void addPluginListener(PluginListener pluginListener) {
        if (pluginListener != null) {
            this.listeners.add(pluginListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends PluginListener> void addPluginListener(Class<T> pluginListenerClass) {
        if (pluginListenerClass != null) {
            List<Class> list = this.listenerClasses;
            synchronized (list) {
                this.listenerClasses.add(pluginListenerClass);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends PluginListener> void buildListenerClass(GenericApplicationContext applicationContext) {
        if (applicationContext == null) {
            return;
        }
        List<Class> list = this.listenerClasses;
        synchronized (list) {
            for (Class listenerClass : this.listenerClasses) {
                applicationContext.registerBean(listenerClass, new BeanDefinitionCustomizer[0]);
                PluginListener bean = (PluginListener)applicationContext.getBean(listenerClass);
                this.listeners.add(bean);
            }
            this.listenerClasses.clear();
        }
    }

    public List<PluginListener> getListeners() {
        return this.listeners;
    }

    public List<Class> getListenerClasses() {
        return this.listenerClasses;
    }
}

