/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.integration.application;

import com.gitee.starblues.integration.IntegrationConfiguration;
import com.gitee.starblues.integration.application.AbstractPluginApplication;
import com.gitee.starblues.integration.listener.PluginInitializerListener;
import com.gitee.starblues.integration.operator.DefaultPluginOperator;
import com.gitee.starblues.integration.operator.PluginOperator;
import com.gitee.starblues.integration.pf4j.DefaultPf4JFactory;
import com.gitee.starblues.integration.pf4j.Pf4jFactory;
import com.gitee.starblues.integration.user.DefaultPluginUser;
import com.gitee.starblues.integration.user.PluginUser;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.pf4j.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class DefaultPluginApplication
extends AbstractPluginApplication {
    private final Logger log = LoggerFactory.getLogger(DefaultPluginApplication.class);
    private Pf4jFactory integrationFactory;
    private PluginUser pluginUser;
    private PluginOperator pluginOperator;
    private AtomicBoolean beInitialized = new AtomicBoolean(false);

    public DefaultPluginApplication() {
    }

    public DefaultPluginApplication(Pf4jFactory integrationFactory) {
        this.integrationFactory = integrationFactory;
    }

    @Override
    public synchronized void initialize(ApplicationContext applicationContext, PluginInitializerListener listener) {
        Objects.requireNonNull(applicationContext, "ApplicationContext can't be null");
        if (this.beInitialized.get()) {
            throw new RuntimeException("Plugin has been initialized");
        }
        IntegrationConfiguration configuration = this.getConfiguration(applicationContext);
        if (this.integrationFactory == null) {
            this.integrationFactory = new DefaultPf4JFactory(configuration);
        }
        PluginManager pluginManager = this.integrationFactory.getPluginManager();
        this.pluginUser = new DefaultPluginUser(applicationContext, pluginManager);
        this.pluginOperator = new DefaultPluginOperator(applicationContext, configuration, pluginManager, this.listenerFactory);
        try {
            this.pluginOperator.initPlugins(listener);
            this.beInitialized.set(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public PluginOperator getPluginOperator() {
        this.assertInjected();
        return this.pluginOperator;
    }

    @Override
    public PluginUser getPluginUser() {
        this.assertInjected();
        return this.pluginUser;
    }

    private void assertInjected() {
        if (this.pluginUser == null) {
            throw new RuntimeException("PluginUser is null, Please check whether the DefaultPluginApplication is injected");
        }
        if (this.pluginOperator == null) {
            throw new RuntimeException("PluginOperator is null, Please check whether the DefaultPluginApplication is injected");
        }
    }
}

