/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.factory.process.pipe;

import com.gitee.starblues.extension.ExtensionInitializer;
import com.gitee.starblues.factory.PluginRegistryInfo;
import com.gitee.starblues.factory.process.pipe.PluginPipeProcessor;
import com.gitee.starblues.factory.process.pipe.bean.BasicBeanProcessor;
import com.gitee.starblues.factory.process.pipe.bean.ConfigBeanProcessor;
import com.gitee.starblues.factory.process.pipe.bean.OneselfListenerStopEventProcessor;
import com.gitee.starblues.factory.process.pipe.classs.PluginClassProcess;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class PluginPipeProcessorFactory
implements PluginPipeProcessor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ApplicationContext applicationContext;
    private final List<PluginPipeProcessor> pluginPipeProcessors = new ArrayList<PluginPipeProcessor>();

    public PluginPipeProcessorFactory(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public void initialize() throws Exception {
        this.pluginPipeProcessors.add(new OneselfListenerStopEventProcessor(this.applicationContext));
        this.pluginPipeProcessors.add(new PluginClassProcess());
        this.pluginPipeProcessors.add(new BasicBeanProcessor(this.applicationContext));
        this.pluginPipeProcessors.add(new ConfigBeanProcessor(this.applicationContext));
        this.pluginPipeProcessors.addAll(ExtensionInitializer.getPipeProcessorExtends());
        for (PluginPipeProcessor pluginPipeProcessor : this.pluginPipeProcessors) {
            pluginPipeProcessor.initialize();
        }
    }

    @Override
    public void registry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        for (PluginPipeProcessor pluginPipeProcessor : this.pluginPipeProcessors) {
            pluginPipeProcessor.registry(pluginRegistryInfo);
        }
    }

    @Override
    public void unRegistry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        for (PluginPipeProcessor pluginPipeProcessor : this.pluginPipeProcessors) {
            pluginPipeProcessor.unRegistry(pluginRegistryInfo);
        }
    }
}

