/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.extension.resources.resolver;

import com.gitee.starblues.factory.PluginRegistryInfo;
import com.gitee.starblues.factory.process.pipe.loader.PluginResource;
import com.gitee.starblues.realize.BasePlugin;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileUrlResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.resource.AbstractResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolverChain;

public class PluginResourceResolver
extends AbstractResourceResolver {
    private static final Logger logger = LoggerFactory.getLogger(PluginResourceResolver.class);
    private static final String RESOLVED_RESOURCE_CACHE_KEY_PREFIX = "resolvedPluginResource:";
    private static final Map<String, PluginStaticResource> PLUGIN_RESOURCE_MAP = new ConcurrentHashMap<String, PluginStaticResource>();

    PluginResourceResolver() {
    }

    protected Resource resolveResourceInternal(HttpServletRequest request, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        int startOffset = requestPath.startsWith("/") ? 1 : 0;
        int endOffset = requestPath.indexOf(47, 1);
        if (endOffset != -1) {
            String pluginId = requestPath.substring(startOffset, endOffset);
            String partialPath = requestPath.substring(endOffset + 1);
            PluginStaticResource pluginResource = PLUGIN_RESOURCE_MAP.get(pluginId);
            if (pluginResource == null) {
                return null;
            }
            String key = this.computeKey(request, requestPath);
            Resource resource = pluginResource.getCacheResource(key);
            if (resource != null) {
                return resource;
            }
            resource = this.resolveClassPath(pluginResource, partialPath);
            if (resource != null) {
                pluginResource.putCacheResource(key, resource);
                return resource;
            }
            resource = this.resolveFilePath(pluginResource, partialPath);
            if (resource != null) {
                pluginResource.putCacheResource(key, resource);
                return resource;
            }
            return null;
        }
        return chain.resolveResource(request, requestPath, locations);
    }

    private Resource resolveClassPath(PluginStaticResource pluginResource, String partialPath) {
        Set<String> classPaths = pluginResource.getClassPaths();
        if (classPaths == null || classPaths.isEmpty()) {
            return null;
        }
        PluginRegistryInfo pluginRegistryInfo = pluginResource.getPluginRegistryInfo();
        BasePlugin basePlugin = pluginRegistryInfo.getBasePlugin();
        if (basePlugin == null) {
            return null;
        }
        ClassLoader pluginClassLoader = pluginRegistryInfo.getPluginClassLoader();
        for (String classPath : classPaths) {
            try {
                PluginResource resource = new PluginResource(classPath + partialPath, pluginRegistryInfo);
                resource.setClassLoader(pluginClassLoader);
                if (!resource.exists()) continue;
                return resource;
            }
            catch (Exception e) {
                logger.debug("Get static resources of classpath '{}' error.", (Object)classPath, (Object)e);
            }
        }
        return null;
    }

    private Resource resolveFilePath(PluginStaticResource pluginResource, String partialPath) {
        Set<String> filePaths = pluginResource.getFilePaths();
        if (filePaths == null || filePaths.isEmpty()) {
            return null;
        }
        for (String filePath : filePaths) {
            Path fullPath = Paths.get(filePath + partialPath, new String[0]);
            if (!Files.exists(fullPath, new LinkOption[0])) continue;
            try {
                FileUrlResource fileUrlResource = new FileUrlResource(fullPath.toString());
                if (!fileUrlResource.exists()) continue;
                return fileUrlResource;
            }
            catch (Exception e) {
                logger.debug("Get static resources of path '{}' error.", (Object)fullPath, (Object)e);
            }
        }
        return null;
    }

    protected String resolveUrlPathInternal(String resourceUrlPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return null;
    }

    protected String computeKey(HttpServletRequest request, String requestPath) {
        String codingKey;
        StringBuilder key = new StringBuilder(RESOLVED_RESOURCE_CACHE_KEY_PREFIX);
        key.append(requestPath);
        if (request != null && StringUtils.hasText((String)(codingKey = this.getContentCodingKey(request)))) {
            key.append("+encoding=").append(codingKey);
        }
        return key.toString();
    }

    private String getContentCodingKey(HttpServletRequest request) {
        String header = request.getHeader("Accept-Encoding");
        if (!StringUtils.hasText((String)header)) {
            return null;
        }
        return Arrays.stream(StringUtils.tokenizeToStringArray((String)header, (String)",")).map(token -> {
            int index = token.indexOf(59);
            return (index >= 0 ? token.substring(0, index) : token).trim().toLowerCase();
        }).sorted().collect(Collectors.joining(","));
    }

    public static synchronized void parse(PluginRegistryInfo pluginRegistryInfo, Set<String> locations) {
        if (locations == null || locations.isEmpty()) {
            return;
        }
        HashSet<String> classPaths = new HashSet<String>();
        HashSet<String> filePaths = new HashSet<String>();
        String pluginId = pluginRegistryInfo.getPluginWrapper().getPluginId();
        for (String location : locations) {
            if (StringUtils.isEmpty((Object)location)) continue;
            int first = location.indexOf(":");
            if (first == -1) {
                logger.warn("This plugin '{}' location config '{}' cannot be resolved", (Object)pluginId, (Object)location);
                continue;
            }
            String type = location.substring(0, first);
            String path = location.substring(first + 1);
            if ("classpath".equalsIgnoreCase(type)) {
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                classPaths.add(path);
                continue;
            }
            if ("file".equalsIgnoreCase(type)) {
                if (!path.endsWith(File.separator)) {
                    path = path + File.separator;
                }
                filePaths.add(path);
                continue;
            }
            logger.warn("The plugin '{}' type '{}' cannot be resolved", (Object)pluginId, (Object)type);
        }
        PluginStaticResource pluginResource = new PluginStaticResource();
        pluginResource.setClassPaths(classPaths);
        pluginResource.setFilePaths(filePaths);
        pluginResource.setPluginRegistryInfo(pluginRegistryInfo);
        logger.info("PluginResources '{}' set classpath resources: {}, set file resources: {}", new Object[]{pluginId, classPaths, filePaths});
        if (PLUGIN_RESOURCE_MAP.containsKey(pluginId)) {
            PluginResourceResolver.remove(pluginId);
        }
        PLUGIN_RESOURCE_MAP.put(pluginId, pluginResource);
    }

    public static synchronized void remove(String pluginId) {
        PluginStaticResource pluginResource = PLUGIN_RESOURCE_MAP.get(pluginId);
        if (pluginResource == null) {
            return;
        }
        PLUGIN_RESOURCE_MAP.remove(pluginId);
    }

    private static class PluginStaticResource {
        private PluginRegistryInfo pluginRegistryInfo;
        private Set<String> classPaths;
        private Set<String> filePaths;
        private Map<String, Resource> cacheResourceMaps = new ConcurrentHashMap<String, Resource>();

        private PluginStaticResource() {
        }

        PluginRegistryInfo getPluginRegistryInfo() {
            return this.pluginRegistryInfo;
        }

        void setPluginRegistryInfo(PluginRegistryInfo pluginRegistryInfo) {
            this.pluginRegistryInfo = pluginRegistryInfo;
        }

        Set<String> getClassPaths() {
            return this.classPaths;
        }

        void setClassPaths(Set<String> classPaths) {
            this.classPaths = classPaths;
        }

        Set<String> getFilePaths() {
            return this.filePaths;
        }

        void setFilePaths(Set<String> filePaths) {
            this.filePaths = filePaths;
        }

        Resource getCacheResource(String key) {
            return this.cacheResourceMaps.get(key);
        }

        void putCacheResource(String key, Resource resource) {
            if (StringUtils.isEmpty((Object)key) || resource == null) {
                return;
            }
            this.cacheResourceMaps.put(key, resource);
        }
    }
}

