/*
 * Decompiled with CFR 0.152.
 */
package com.dk.uartnfc.UartManager;

import android.os.CountDownTimer;
import android.util.Log;
import android_serialport_api.ComBean;
import android_serialport_api.SerialHelper;
import android_serialport_api.SerialPortFinder;
import com.dk.uartnfc.Exception.DeviceNoResponseException;
import com.dk.uartnfc.Tool.StringTool;
import com.dk.uartnfc.UartManager.DKMessageDef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class SerialManager {
    static final String TAG = "SerialManager";
    static final int DEVICE_NO_RESPONSE_TIME = 5000;
    public SerialPortFinder serialPortFinder;
    public SerialHelper serialHelper;
    private String comPortName;
    private onReceiveDataListener mOnReceiveDataListener;
    public onReceiveDataListener gOnReceiveDataListener;
    private byte[] rcvBuffer = new byte[30000];
    private int rcvLen = 0;
    private boolean rcvDataFlag = false;
    private DKMessageDef gt_message = new DKMessageDef();
    private final CountDownTimer timer = new CountDownTimer(500L, 500L){

        public void onTick(long millisUntilFinished) {
        }

        public void onFinish() {
            SerialManager.this.timer.cancel();
            if (SerialManager.this.rcvLen != 0) {
                byte[] readBytes = new byte[SerialManager.this.rcvLen];
                System.arraycopy(SerialManager.this.rcvBuffer, 0, readBytes, 0, SerialManager.this.rcvLen);
                SerialManager.this.rcvLen = 0;
                if (SerialManager.this.mOnReceiveDataListener != null) {
                    SerialManager.this.mOnReceiveDataListener.OnReceiverData(SerialManager.this.comPortName, readBytes);
                }
                if (SerialManager.this.gOnReceiveDataListener != null) {
                    SerialManager.this.gOnReceiveDataListener.OnReceiverData(SerialManager.this.comPortName, readBytes);
                }
            }
            SerialManager.this.gt_message.clear();
            SerialManager.this.rcvLen = 0;
        }
    };

    public void setOnReceiveDataListener(onReceiveDataListener l) {
        this.gOnReceiveDataListener = l;
    }

    public SerialManager() {
        this.serialPortFinder = new SerialPortFinder();
        this.serialHelper = new SerialHelper(){

            @Override
            protected void onDataReceived(ComBean comBean) {
                if (SerialManager.this.rcvLen + comBean.bRec.length > SerialManager.this.rcvBuffer.length) {
                    SerialManager.this.timer.cancel();
                    SerialManager.this.rcvLen = 0;
                    return;
                }
                if (comBean.bRec.length == 0) {
                    return;
                }
                SerialManager.this.comPortName = comBean.sComPort;
                System.arraycopy(comBean.bRec, 0, SerialManager.this.rcvBuffer, SerialManager.this.rcvLen, comBean.bRec.length);
                SerialManager.this.rcvLen = SerialManager.this.rcvLen + comBean.bRec.length;
                int i = 0;
                SerialManager.this.gt_message.clear();
                block8: for (i = 0; i < SerialManager.this.rcvLen; ++i) {
                    switch (((SerialManager)SerialManager.this).gt_message.status) {
                        case 0: {
                            if (SerialManager.this.rcvBuffer[i] == -86) {
                                SerialManager.this.gt_message.clear();
                                ((SerialManager)SerialManager.this).gt_message.start = (byte)-86;
                                ((SerialManager)SerialManager.this).gt_message.len = 0;
                                ((SerialManager)SerialManager.this).gt_message.status = 2;
                                continue block8;
                            }
                            if (SerialManager.this.rcvBuffer[i] == -69) {
                                SerialManager.this.gt_message.clear();
                                ((SerialManager)SerialManager.this).gt_message.start = (byte)-69;
                                ((SerialManager)SerialManager.this).gt_message.len = 0;
                                ((SerialManager)SerialManager.this).gt_message.status = 1;
                                continue block8;
                            }
                            if (SerialManager.this.mOnReceiveDataListener != null) {
                                SerialManager.this.mOnReceiveDataListener.OnReceiverData(SerialManager.this.comPortName, new byte[]{SerialManager.this.rcvBuffer[0]});
                            }
                            if (SerialManager.this.gOnReceiveDataListener != null) {
                                SerialManager.this.gOnReceiveDataListener.OnReceiverData(SerialManager.this.comPortName, new byte[]{SerialManager.this.rcvBuffer[0]});
                            }
                            SerialManager.this.gt_message.clear();
                            SerialManager.this.rcvLen = 0;
                            continue block8;
                        }
                        case 1: {
                            ((SerialManager)SerialManager.this).gt_message.len = (SerialManager.this.rcvBuffer[i] & 0xFF) << 8;
                            ++((SerialManager)SerialManager.this).gt_message.status;
                            continue block8;
                        }
                        case 2: {
                            ((SerialManager)SerialManager.this).gt_message.len += SerialManager.this.rcvBuffer[i] & 0xFF;
                            if (((SerialManager)SerialManager.this).gt_message.len == 0) {
                                SerialManager.this.gt_message.clear();
                                continue block8;
                            }
                            ++((SerialManager)SerialManager.this).gt_message.status;
                            continue block8;
                        }
                        case 3: {
                            ((SerialManager)SerialManager.this).gt_message.command = SerialManager.this.rcvBuffer[i];
                            if (((SerialManager)SerialManager.this).gt_message.len >= 2) {
                                ((SerialManager)SerialManager.this).gt_message.index = 0;
                                ((SerialManager)SerialManager.this).gt_message.dataLen = ((SerialManager)SerialManager.this).gt_message.len - 1;
                                ++((SerialManager)SerialManager.this).gt_message.status;
                                continue block8;
                            }
                            if (((SerialManager)SerialManager.this).gt_message.len != 1) continue block8;
                            byte[] readBytes = new byte[((SerialManager)SerialManager.this).gt_message.len + 2];
                            System.arraycopy(SerialManager.this.rcvBuffer, 0, readBytes, 0, readBytes.length);
                            SerialManager.this.rcvLen = 0;
                            if (SerialManager.this.mOnReceiveDataListener != null) {
                                SerialManager.this.mOnReceiveDataListener.OnReceiverData(SerialManager.this.comPortName, readBytes);
                            }
                            if (SerialManager.this.gOnReceiveDataListener != null) {
                                SerialManager.this.gOnReceiveDataListener.OnReceiverData(SerialManager.this.comPortName, readBytes);
                            }
                            SerialManager.this.gt_message.clear();
                            SerialManager.this.rcvLen = 0;
                            continue block8;
                        }
                        case 4: {
                            if (((SerialManager)SerialManager.this).gt_message.index >= 30000) {
                                SerialManager.this.gt_message.clear();
                            }
                            if (((SerialManager)SerialManager.this).gt_message.index < ((SerialManager)SerialManager.this).gt_message.dataLen) {
                                ((SerialManager)SerialManager.this).gt_message.data[((SerialManager)SerialManager.this).gt_message.index++] = SerialManager.this.rcvBuffer[i];
                            }
                            if (((SerialManager)SerialManager.this).gt_message.index != ((SerialManager)SerialManager.this).gt_message.dataLen) continue block8;
                            if (((SerialManager)SerialManager.this).gt_message.start == -69) {
                                ++((SerialManager)SerialManager.this).gt_message.status;
                                continue block8;
                            }
                            byte[] readBytes = new byte[((SerialManager)SerialManager.this).gt_message.len + 2];
                            System.arraycopy(SerialManager.this.rcvBuffer, 0, readBytes, 0, readBytes.length);
                            SerialManager.this.rcvLen = 0;
                            if (SerialManager.this.mOnReceiveDataListener != null) {
                                SerialManager.this.mOnReceiveDataListener.OnReceiverData(SerialManager.this.comPortName, readBytes);
                            }
                            if (SerialManager.this.gOnReceiveDataListener != null) {
                                SerialManager.this.gOnReceiveDataListener.OnReceiverData(SerialManager.this.comPortName, readBytes);
                            }
                            SerialManager.this.gt_message.clear();
                            SerialManager.this.rcvLen = 0;
                            continue block8;
                        }
                        case 5: {
                            ((SerialManager)SerialManager.this).gt_message.bcc = SerialManager.this.rcvBuffer[i];
                            byte[] readBytes = new byte[((SerialManager)SerialManager.this).gt_message.len + 4];
                            System.arraycopy(SerialManager.this.rcvBuffer, 0, readBytes, 0, readBytes.length);
                            SerialManager.this.rcvLen = 0;
                            if (SerialManager.this.mOnReceiveDataListener != null) {
                                SerialManager.this.mOnReceiveDataListener.OnReceiverData(SerialManager.this.comPortName, readBytes);
                            }
                            if (SerialManager.this.gOnReceiveDataListener != null) {
                                SerialManager.this.gOnReceiveDataListener.OnReceiverData(SerialManager.this.comPortName, readBytes);
                            }
                            SerialManager.this.gt_message.clear();
                            SerialManager.this.rcvLen = 0;
                            continue block8;
                        }
                        default: {
                            SerialManager.this.gt_message.clear();
                        }
                    }
                }
                SerialManager.this.timer.cancel();
                SerialManager.this.timer.start();
            }
        };
    }

    public byte[] sendWithReturn(byte[] msg) throws DeviceNoResponseException {
        return this.sendWithReturn(msg, 5000);
    }

    public synchronized byte[] sendWithReturn(byte[] msg, int timeOutMs) throws DeviceNoResponseException {
        if (!this.serialHelper.isOpen()) {
            throw new DeviceNoResponseException("Serial port is close!");
        }
        final byte[][] returnBytes = new byte[1][1];
        final boolean[] isCmdRunSucFlag = new boolean[]{false};
        final Semaphore semaphore = new Semaphore(0);
        returnBytes[0] = null;
        this.send(msg, new onReceiveDataListener(){

            @Override
            public void OnReceiverData(String portNumberString, byte[] data) {
                if (data != null) {
                    returnBytes[0] = data;
                    isCmdRunSucFlag[0] = true;
                } else {
                    returnBytes[0] = null;
                    isCmdRunSucFlag[0] = false;
                }
                semaphore.release();
            }
        });
        try {
            semaphore.tryAcquire(timeOutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new DeviceNoResponseException("\u8bbe\u5907\u65e0\u54cd\u5e94\uff01");
        }
        if (!isCmdRunSucFlag[0]) {
            throw new DeviceNoResponseException("\u8bbe\u5907\u65e0\u54cd\u5e94\uff01");
        }
        return returnBytes[0];
    }

    public void send(byte[] msg) {
        if (msg == null) {
            return;
        }
        Log.d((String)TAG, (String)("\u4e32\u53e3\"" + this.serialHelper.getPort() + "\"\u53d1\u9001\u6570\u636e\uff1a" + StringTool.byteHexToSting(msg)));
        this.serialHelper.send(msg);
    }

    public void send(byte[] msg, onReceiveDataListener listener) {
        this.mOnReceiveDataListener = listener;
        this.send(msg);
    }

    public int read(byte[] buf, int size, int wait, int interval) {
        try {
            byte[] bytes = this.sendWithReturn(null, wait);
            if (bytes == null) {
                return -1;
            }
            if (bytes.length == 0) {
                return 0;
            }
            System.arraycopy(bytes, 0, buf, 0, size);
            return size;
        }
        catch (DeviceNoResponseException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public List<String> getAvailablePorts() {
        ArrayList<String> availablePorts = new ArrayList<String>();
        String[] ports = this.serialPortFinder.getAllDevicesPath();
        availablePorts.addAll(Arrays.asList(ports));
        return availablePorts;
    }

    public boolean open(String portName, String baudRate) {
        if (portName == null || baudRate == null) {
            return false;
        }
        this.close();
        this.serialHelper.setBaudRate(baudRate);
        this.serialHelper.setPort(portName);
        try {
            this.serialHelper.open();
            Log.d((String)TAG, (String)("\u6253\u5f00\u4e32\u53e3\"" + portName + "\"\u6210\u529f\uff01"));
            return true;
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("\u6253\u5f00\u4e32\u53e3\"" + portName + "\"\u5931\u8d25\uff01"));
            return false;
        }
    }

    public void close() {
        if (this.serialHelper.isOpen()) {
            this.serialHelper.close();
        }
    }

    public boolean isOpen() {
        return this.serialHelper.isOpen();
    }

    public static interface onReceiveDataListener {
        public void OnReceiverData(String var1, byte[] var2);
    }
}

