/*
 * Decompiled with CFR 0.152.
 */
package com.dk.uartnfc.DKCloudID;

import android.util.Log;
import com.dk.uartnfc.Tool.UtilTool;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;

public class DKCloudID {
    private static final String TAG = "DKCloudID";
    private static String ip = "www.dkcloudid.cn";
    private static final int port = 20006;
    public static final int PACKET_HEAD_LENGTH = 2;
    private static Socket client = null;
    private static OutputStream out;
    private static InputStream in;
    private static boolean closed;

    public DKCloudID() {
        boolean isClientOk = true;
        try {
            if (client == null || client.isClosed() || in == null) {
                isClientOk = false;
            } else {
                client.setSoTimeout(1);
                if (in.read() < 0) {
                    isClientOk = false;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!isClientOk) {
            Log.d((String)TAG, (String)"\u5efa\u7acb\u8fde\u63a5");
            DKCloudID.Close();
            client = new Socket();
            InetSocketAddress socketAddress = new InetSocketAddress(ip, 20006);
            try {
                client.connect(socketAddress, 8000);
            }
            catch (IOException e) {
                DKCloudID.Close();
                Log.d((String)TAG, (String)("\u8fde\u63a5\u670d\u52a1\u5668\u5931\u8d25\uff1a" + ip + ":" + 20006));
                e.printStackTrace();
                return;
            }
            try {
                client.setTcpNoDelay(true);
                client.setSoTimeout(5000);
                out = client.getOutputStream();
                in = client.getInputStream();
                closed = false;
            }
            catch (UnknownHostException e) {
                DKCloudID.Close();
                e.printStackTrace();
            }
            catch (IOException e) {
                DKCloudID.Close();
                e.printStackTrace();
            }
        } else {
            try {
                client.setSoTimeout(5000);
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
        }
    }

    public static void setIp(String theIp) {
        if (theIp == null) {
            return;
        }
        ip = theIp;
    }

    public boolean isConnected() {
        return client.isConnected();
    }

    public byte[] dkCloudTcpDataExchange(byte[] initData) {
        if (initData == null || closed) {
            return null;
        }
        this.SendPacket(initData);
        return this.ReadPacket();
    }

    private void clearInBuf() {
        if (in != null) {
            try {
                while (in.available() > 0) {
                    byte[] buf = new byte[1];
                    in.read(buf);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void SendPacket(byte[] res) {
        this.clearInBuf();
        byte[] headLen = UtilTool.shortToByte((short)res.length);
        byte[] body = UtilTool.mergeByte(headLen, res, 0, res.length);
        try {
            out.write(body);
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            DKCloudID.Close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private byte[] ReadPacket() {
        byte[] bodyBuff = new byte[]{};
        byte[] headBuff = new byte[]{};
        while (true) {
            if (closed) {
                Log.d((String)TAG, (String)"\u8bf7\u6c42\u5df2\u88ab\u5173\u95ed");
                return null;
            }
            try {
                byte[] head;
                int couter;
                if (headBuff.length < 2 && ((couter = in.read(head = new byte[2 - headBuff.length])) < 0 || (headBuff = UtilTool.mergeByte(headBuff, head, 0, couter)).length < 2)) continue;
                short bodyLen = UtilTool.byteToShort(headBuff);
                if (bodyBuff.length >= bodyLen) return bodyBuff;
                byte[] body = new byte[bodyLen - bodyBuff.length];
                int couter2 = in.read(body);
                if (couter2 < 0) continue;
                bodyBuff = UtilTool.mergeByte(bodyBuff, body, 0, couter2);
                if (couter2 >= body.length) return bodyBuff;
            }
            catch (Exception e) {
                e.printStackTrace();
                DKCloudID.Close();
                return null;
            }
        }
    }

    public static void Close() {
        closed = true;
        if (client != null) {
            try {
                client.close();
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        closed = false;
    }
}

