/*
 * Decompiled with CFR 0.152.
 */
package com.dk.uartnfc.Card;

import com.dk.uartnfc.Card.Card;
import com.dk.uartnfc.DeviceManager.Command;
import com.dk.uartnfc.DeviceManager.DeviceManager;
import com.dk.uartnfc.Exception.CardNoResponseException;
import com.dk.uartnfc.Exception.DeviceNoResponseException;
import com.dk.uartnfc.UartManager.DKMessageDef;
import java.util.Arrays;

public class Ultralight
extends Card {
    static final byte UL_GET_VERSION_CMD = 96;
    static final byte UL_READ_CMD = 48;
    static final byte UL_FAST_READ_CMD = 58;
    static final byte UL_WRITE_CMD = -94;
    static final byte UL_READ_CNT_CMD = 57;
    static final byte UL_PWD_AUTH_CMD = 27;
    public static final int UL_MAX_FAST_READ_BLOCK_NUM = 4;
    public static final int LONG_READ_MAX_NUMBER = 48;

    public Ultralight(DeviceManager deviceManager) {
        super(deviceManager);
    }

    public Ultralight(DeviceManager deviceManager, byte[] uid, byte[] atr) {
        super(deviceManager, uid, atr);
    }

    public byte[] getVersion() throws CardNoResponseException {
        return null;
    }

    public byte[] read(byte addr) throws CardNoResponseException {
        byte[] cmdByte = new byte[]{48, addr};
        byte[] rsp = this.transceive(cmdByte);
        if (rsp.length != 16) {
            throw new CardNoResponseException("\u8bfb\u5361\u547d\u4ee4\u6267\u884c\u5931\u8d25");
        }
        return rsp;
    }

    public byte[] fastRead(byte startAddress, byte endAddress) throws CardNoResponseException {
        return null;
    }

    public byte[] longReadSingle(byte startAddress, int number) throws CardNoResponseException {
        int endAddress = (startAddress & 0xFF) + number;
        try {
            byte[] rsp = this.deviceManager.serialManager.sendWithReturn(Command.getCmdBytes((byte)28, startAddress, new byte[]{(byte)endAddress}), 500);
            DKMessageDef msg = Command.getRspMsg(rsp);
            if (msg.data == null || msg.data.length < 5 || msg.command != 28) {
                throw new CardNoResponseException("longReadSingle\u8bfb\u5361\u5931\u8d25\uff0c\u8bf7\u4e0d\u8981\u79fb\u52a8\u5361\u7247");
            }
            return Arrays.copyOfRange(msg.data, 1, msg.data.length);
        }
        catch (DeviceNoResponseException e) {
            e.printStackTrace();
            throw new CardNoResponseException("\u8bfb\u5361\u5931\u8d25\uff0c\u8bf7\u4e0d\u8981\u79fb\u52a8\u5361\u7247");
        }
    }

    public boolean write(byte addr, byte[] writeData) throws CardNoResponseException {
        if (writeData.length != 4) {
            throw new CardNoResponseException("\u5199\u5165\u957f\u5ea6\u5fc5\u987b\u7b49\u4e8e16");
        }
        try {
            byte[] rsp = this.deviceManager.serialManager.sendWithReturn(Command.getCmdBytes((byte)10, addr, writeData), 500);
            return Command.verify_ack(rsp);
        }
        catch (DeviceNoResponseException e) {
            e.printStackTrace();
            throw new CardNoResponseException("\u8bfb\u5361\u5931\u8d25\uff0c\u8bf7\u4e0d\u8981\u79fb\u52a8\u5361\u7247");
        }
    }

    public boolean longWriteSingle(byte startAddress, byte[] data) throws CardNoResponseException {
        try {
            byte[] rsp = this.deviceManager.serialManager.sendWithReturn(Command.getCmdBytes((byte)29, startAddress, data), 500);
            return Command.verify_ack(rsp);
        }
        catch (DeviceNoResponseException e) {
            e.printStackTrace();
            throw new CardNoResponseException("\u8bfb\u5361\u5931\u8d25\uff0c\u8bf7\u4e0d\u8981\u79fb\u52a8\u5361\u7247");
        }
    }

    public byte[] readCnt() throws CardNoResponseException {
        return null;
    }

    public boolean pwdAuth(byte[] password) throws CardNoResponseException {
        if (password.length != 4) {
            throw new CardNoResponseException("\u5bc6\u94a5\u5fc5\u987b4\u5b57\u8282");
        }
        byte[] cmdByte = new byte[]{27, password[0], password[1], password[2], password[3]};
        byte[] rsp = this.transceive(cmdByte);
        return rsp.length == 2;
    }

    public byte[] transceive(byte[] data) throws CardNoResponseException {
        if (data == null || data.length == 0) {
            throw new CardNoResponseException("\u6570\u636e\u4e0d\u80fd\u4e3anull");
        }
        try {
            byte[] nfc_return_bytes = this.deviceManager.serialManager.sendWithReturn(Command.getCmdBytes((byte)37, data), 500);
            DKMessageDef msg = Command.getRspMsg(nfc_return_bytes);
            if (msg.data == null || msg.command != 37) {
                return null;
            }
            return msg.data;
        }
        catch (DeviceNoResponseException e) {
            e.printStackTrace();
            throw new CardNoResponseException("\u8bfb\u53d6\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u4e0d\u8981\u79fb\u52a8\u5361\u7247");
        }
    }
}

