/*
 * Decompiled with CFR 0.152.
 */
package com.dk.uartnfc.Card;

import com.dk.uartnfc.DeviceManager.DeviceManager;
import com.dk.uartnfc.Exception.CardNoResponseException;
import com.dk.uartnfc.Exception.DeviceNoResponseException;
import com.dk.uartnfc.Tool.UtilTool;
import com.dk.uartnfc.UartManager.SerialManager;
import java.util.Arrays;

public class SamVIdCard {
    public static final int NUMBER_OF_REPARSING = 5;
    public SerialManager serialManager;
    private byte[] initData;

    public SamVIdCard(SerialManager serialManager, byte[] initData) {
        this.serialManager = serialManager;
        this.initData = initData;
    }

    public SamVIdCard(DeviceManager deviceManager, byte[] initData) {
        this.serialManager = deviceManager.serialManager;
        this.initData = initData;
    }

    public byte[] getSamVInitData() throws CardNoResponseException {
        if (this.initData == null) {
            throw new CardNoResponseException("\u521d\u59cb\u5316\u6570\u636e\u4e3a\u7a7a");
        }
        return this.initData;
    }

    public byte[] transceive(byte[] data) throws CardNoResponseException {
        SamVIdCard samVIdCard = this;
        synchronized (samVIdCard) {
            if (data == null || data.length == 0) {
                throw new CardNoResponseException("\u6570\u636e\u4e0d\u80fd\u4e3anull");
            }
            byte[] bytes = new byte[data.length + 5];
            int cmdLen = data.length + 1;
            bytes[0] = -69;
            bytes[1] = (byte)((cmdLen & 0xFF00) >> 8);
            bytes[2] = (byte)(cmdLen & 0xFF);
            bytes[3] = 51;
            System.arraycopy(data, 0, bytes, 4, data.length);
            bytes[bytes.length - 1] = UtilTool.bcc_check(bytes);
            byte[] sendApduBytes = bytes;
            try {
                byte[] nfc_return_bytes = this.serialManager.sendWithReturn(sendApduBytes, 2000);
                SamVIdCard.verify(nfc_return_bytes);
                byte[] apduBytes = Arrays.copyOfRange(nfc_return_bytes, 4, nfc_return_bytes.length - 1);
                return apduBytes;
            }
            catch (DeviceNoResponseException e) {
                e.printStackTrace();
                throw new CardNoResponseException("\u8bfb\u53d6\u8eab\u4efd\u8bc1\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u4e0d\u8981\u79fb\u52a8\u8eab\u4efd\u8bc1");
            }
        }
    }

    public static boolean verify(byte[] data) throws CardNoResponseException {
        if (data.length < 6) {
            throw new CardNoResponseException("\u6570\u636e\u957f\u5ea6\u9519\u8bef");
        }
        byte bcc_sum = 0;
        for (int i = 0; i < data.length - 1; ++i) {
            bcc_sum = (byte)(bcc_sum ^ data[i]);
        }
        if (bcc_sum != data[data.length - 1]) {
            System.out.println("\u548c\u6821\u9a8c\u5931\u8d25");
            throw new CardNoResponseException("\u548c\u6821\u9a8c\u5931\u8d25");
        }
        return true;
    }
}

