/*
 * Decompiled with CFR 0.152.
 */
package com.dk.uartnfc.Card;

import com.dk.uartnfc.Card.Card;
import com.dk.uartnfc.DeviceManager.Command;
import com.dk.uartnfc.DeviceManager.DeviceManager;
import com.dk.uartnfc.Exception.CardNoResponseException;
import com.dk.uartnfc.Exception.DeviceNoResponseException;
import com.dk.uartnfc.UartManager.DKMessageDef;
import java.util.Arrays;

public class Iso15693Card
extends Card {
    public Iso15693Card(DeviceManager deviceManager) {
        super(deviceManager);
    }

    public Iso15693Card(DeviceManager deviceManager, byte[] uid, byte[] atr) {
        super(deviceManager, uid, atr);
    }

    public boolean lockBlock(byte addr) throws CardNoResponseException {
        try {
            return Command.verify_ack(this.deviceManager.serialManager.sendWithReturn(Command.getCmdBytes((byte)-108, new byte[]{addr}), 500));
        }
        catch (DeviceNoResponseException e) {
            e.printStackTrace();
            throw new CardNoResponseException("\u8bfb\u5361\u5931\u8d25\uff0c\u8bf7\u4e0d\u8981\u79fb\u52a8\u5361\u7247");
        }
    }

    public byte[] read(int addr) throws CardNoResponseException {
        return this.read((byte)addr);
    }

    public byte[] read(byte addr) throws CardNoResponseException {
        try {
            byte[] rsp = this.deviceManager.serialManager.sendWithReturn(Command.getCmdBytes((byte)-112, new byte[]{addr}), 500);
            DKMessageDef msg = Command.getRspMsg(rsp);
            if (msg.data == null || msg.data.length < 5 || msg.command != -112) {
                return null;
            }
            return Arrays.copyOfRange(msg.data, 1, msg.data.length);
        }
        catch (DeviceNoResponseException e) {
            e.printStackTrace();
            throw new CardNoResponseException("\u8bfb\u5361\u5931\u8d25\uff0c\u8bf7\u4e0d\u8981\u79fb\u52a8\u5361\u7247");
        }
    }

    public byte[] ReadMultiple(int addr, int number) throws CardNoResponseException {
        return this.ReadMultiple((byte)addr, (byte)number);
    }

    public byte[] ReadMultiple(byte addr, byte number) throws CardNoResponseException {
        try {
            byte[] rsp = this.deviceManager.serialManager.sendWithReturn(Command.getCmdBytes((byte)-111, addr, new byte[]{number}), 500);
            DKMessageDef msg = Command.getRspMsg(rsp);
            if (msg.data == null || msg.data.length < 5 || msg.command != -111) {
                return null;
            }
            return Arrays.copyOfRange(msg.data, 1, msg.data.length);
        }
        catch (DeviceNoResponseException e) {
            e.printStackTrace();
            throw new CardNoResponseException("\u8bfb\u5361\u5931\u8d25\uff0c\u8bf7\u4e0d\u8981\u79fb\u52a8\u5361\u7247");
        }
    }

    public boolean write(int addr, byte[] writeData) throws CardNoResponseException {
        return this.write((byte)addr, writeData);
    }

    public boolean write(byte addr, byte[] writeData) throws CardNoResponseException {
        try {
            byte[] rsp = this.deviceManager.serialManager.sendWithReturn(Command.getCmdBytes((byte)-110, addr, writeData), 500);
            return Command.verify_ack(rsp);
        }
        catch (DeviceNoResponseException e) {
            e.printStackTrace();
            throw new CardNoResponseException("\u8bfb\u5361\u5931\u8d25\uff0c\u8bf7\u4e0d\u8981\u79fb\u52a8\u5361\u7247");
        }
    }

    public boolean writeMultiple(byte addr, byte number, byte[] writeData) throws CardNoResponseException {
        try {
            byte[] rsp = this.deviceManager.serialManager.sendWithReturn(Command.getCmdBytes((byte)-109, addr, number, writeData), 500);
            return Command.verify_ack(rsp);
        }
        catch (DeviceNoResponseException e) {
            e.printStackTrace();
            throw new CardNoResponseException("\u8bfb\u5361\u5931\u8d25\uff0c\u8bf7\u4e0d\u8981\u79fb\u52a8\u5361\u7247");
        }
    }

    public byte[] transceive(byte[] data) throws CardNoResponseException {
        return null;
    }
}

