/*
 * Decompiled with CFR 0.152.
 */
package com.dk.uartnfc.Card;

import com.dk.uartnfc.Card.Card;
import com.dk.uartnfc.DeviceManager.Command;
import com.dk.uartnfc.DeviceManager.DeviceManager;
import com.dk.uartnfc.Exception.CardNoResponseException;
import com.dk.uartnfc.Exception.DeviceNoResponseException;
import com.dk.uartnfc.Tool.StringTool;
import com.dk.uartnfc.UartManager.DKMessageDef;

public class CpuCard
extends Card {
    private static final int APDU_DEFAULT_TIMEOUT_MS = 1000;

    public CpuCard(DeviceManager deviceManager) {
        super(deviceManager);
    }

    public CpuCard(DeviceManager deviceManager, byte[] uid, byte[] atr) {
        super(deviceManager, uid, atr);
    }

    public byte[] getAtr() throws CardNoResponseException {
        try {
            byte[] nfc_return_bytes = this.deviceManager.serialManager.sendWithReturn(Command.getCmdBytes((byte)35), 200);
            DKMessageDef msg = Command.getRspMsg(nfc_return_bytes);
            this.atr = msg.data;
            return this.atr;
        }
        catch (DeviceNoResponseException e) {
            e.printStackTrace();
            throw new CardNoResponseException("\u8bfb\u53d6\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u4e0d\u8981\u79fb\u52a8\u5361\u7247");
        }
    }

    public String transceive(String cmdStr) throws CardNoResponseException {
        return StringTool.byteHexToSting(this.transceive(StringTool.hexStringToBytes(cmdStr)));
    }

    public byte[] transceive(byte[] data) throws CardNoResponseException {
        return this.transceive(data, 1000);
    }

    public String transceive(String cmdStr, int timeout) throws CardNoResponseException {
        return StringTool.byteHexToSting(this.transceive(StringTool.hexStringToBytes(cmdStr), timeout));
    }

    public byte[] transceive(byte[] data, int timeout) throws CardNoResponseException {
        CpuCard cpuCard = this;
        synchronized (cpuCard) {
            if (data == null || data.length == 0) {
                throw new CardNoResponseException("\u6570\u636e\u4e0d\u80fd\u4e3anull");
            }
            try {
                byte[] nfc_return_bytes = this.deviceManager.serialManager.sendWithReturn(Command.getCmdBytes((byte)23, data), timeout);
                return CpuCard.verify_apdu_cmd_return(nfc_return_bytes);
            }
            catch (DeviceNoResponseException e) {
                e.printStackTrace();
                throw new CardNoResponseException("\u8bfb\u53d6\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u4e0d\u8981\u79fb\u52a8\u5361\u7247");
            }
        }
    }

    public static byte[] verify_apdu_cmd_return(byte[] data) throws CardNoResponseException {
        DKMessageDef msg = Command.getRspMsg(data);
        return msg.data;
    }
}

