/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.context.extensions.types;

import com.giffing.wicket.spring.boot.context.exceptions.WicketSpringBootException;
import com.giffing.wicket.spring.boot.context.extensions.types.DurationUnit;
import com.giffing.wicket.spring.boot.context.extensions.types.SessionUnit;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.time.Duration;

public class TypeParser {
    public static Bytes parse(Long size, SessionUnit sessionUnit) {
        switch (sessionUnit) {
            case BYTES: {
                return Bytes.bytes((long)size);
            }
            case KILOBYTES: {
                return Bytes.kilobytes((long)size);
            }
            case MEGABYTES: {
                return Bytes.megabytes((long)size);
            }
            case TERABYTES: {
                return Bytes.terabytes((long)size);
            }
        }
        throw new WicketSpringBootException("Could not parse size with session unit " + size + " " + (Object)((Object)sessionUnit));
    }

    public static Duration parse(Long time, DurationUnit durationUnit) {
        switch (durationUnit) {
            case DAYS: {
                return Duration.days((double)time.longValue());
            }
            case HOURS: {
                return Duration.hours((double)time.longValue());
            }
            case MILLISECONDS: {
                return Duration.milliseconds((long)time);
            }
            case MINUTES: {
                return Duration.minutes((double)time.longValue());
            }
            case SECONDS: {
                return Duration.seconds((double)time.longValue());
            }
        }
        throw new WicketSpringBootException("Could not parse time with duration unit " + time + " " + (Object)((Object)durationUnit));
    }
}

