/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.context.condition;

import com.giffing.wicket.spring.boot.context.condition.ConditionalOnWicket;
import java.util.Map;
import org.apache.wicket.settings.FrameworkSettings;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class WicketSettingsCondition
extends SpringBootCondition {
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        String implVersion = null;
        String wicketVersion = this.retrieveWicketVersion(implVersion);
        Map attributes = metadata.getAnnotationAttributes(ConditionalOnWicket.class.getName());
        ConditionalOnWicket.Range range = (ConditionalOnWicket.Range)((Object)attributes.get("range"));
        int expectedVersion = (Integer)attributes.get("value");
        String[] splittedWicketVersion = wicketVersion.split("\\.");
        int majorWicketVersion = Integer.valueOf(splittedWicketVersion[0]);
        return this.getMatchOutcome(range, majorWicketVersion, expectedVersion);
    }

    protected ConditionOutcome getMatchOutcome(ConditionalOnWicket.Range range, int runningVersion, int expectedVersion) {
        boolean match = this.matches(range, expectedVersion, runningVersion);
        return new ConditionOutcome(match, this.getMessage(match, range, runningVersion, expectedVersion));
    }

    private boolean matches(ConditionalOnWicket.Range range, int expectedVersion, int runningVersion) {
        switch (range) {
            case EQUALS: {
                return runningVersion == expectedVersion;
            }
            case EQUALS_OR_LOWER: {
                return runningVersion <= expectedVersion;
            }
            case EQUALS_OR_HIGHER: {
                return runningVersion >= expectedVersion;
            }
        }
        return false;
    }

    private String getMessage(boolean matches, ConditionalOnWicket.Range range, int runningVersion, int expectedVersion) {
        if (matches) {
            return "Wicket version matches current: " + runningVersion + " " + (Object)((Object)range) + " expected: " + expectedVersion;
        }
        return "Wicket version does not match current: " + runningVersion + " " + (Object)((Object)range) + " expected: " + expectedVersion;
    }

    private String retrieveWicketVersion(String implVersion) {
        Package pkg = FrameworkSettings.class.getPackage();
        if (pkg != null) {
            implVersion = pkg.getImplementationVersion();
        }
        String wicketVersion = this.isEmpty(implVersion) ? "0" : implVersion;
        return wicketVersion;
    }

    private boolean isEmpty(String stringToCheck) {
        return stringToCheck == null || stringToCheck.length() == 0;
    }
}

