/*
 * Decompiled with CFR 0.152.
 */
package com.geteasyqa.EasyQA;

import com.geteasyqa.EasyQA.Plugin.EasyQABuildFailureMode;
import com.geteasyqa.EasyQA.Plugin.EasyQAServer;
import com.geteasyqa.EasyQA.Plugin.EasyQASite;
import com.geteasyqa.EasyQA.Plugin.User;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.util.CopyOnWriteList;
import hudson.util.FormValidation;
import java.util.Collection;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class EasyQAPluginProperties
extends JobProperty<AbstractProject<?, ?>> {
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private String siteName;
    private boolean pluginEnabled;
    private EasyQABuildFailureMode failureMode = EasyQABuildFailureMode.NONE;

    @DataBoundConstructor
    public EasyQAPluginProperties(String siteName, boolean pluginEnabled, EasyQABuildFailureMode failureMode) {
        this.siteName = siteName;
        this.pluginEnabled = pluginEnabled;
        this.failureMode = failureMode;
    }

    public JobPropertyDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public void setPluginEnabled(boolean pluginEnabled) {
        this.pluginEnabled = pluginEnabled;
    }

    public EasyQASite getSite() {
        EasyQASite result = null;
        EasyQASite[] sites = DESCRIPTOR.getSites();
        if (this.siteName == null && sites.length > 0) {
            result = sites[0];
        }
        for (EasyQASite site : sites) {
            if (site.getName() == null || !site.getName().equals(this.siteName)) continue;
            result = site;
            break;
        }
        if (result != null) {
            result.setPluginEnabled(this.pluginEnabled);
            result.setFailureMode(this.failureMode);
        }
        return result;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    public boolean isPluginEnabled() {
        return this.pluginEnabled;
    }

    public EasyQABuildFailureMode getFailureMode() {
        return this.failureMode;
    }

    public void setFailureMode(EasyQABuildFailureMode failureMode) {
        this.failureMode = failureMode;
    }

    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        private final CopyOnWriteList<EasyQASite> sites = new CopyOnWriteList();

        public DescriptorImpl() {
            super(EasyQAPluginProperties.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return AbstractProject.class.isAssignableFrom(jobType);
        }

        public EasyQASite[] getSites() {
            return (EasyQASite[])this.sites.toArray((Object[])new EasyQASite[0]);
        }

        public void setSites(EasyQASite site) {
            this.sites.add((Object)site);
        }

        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            JSONObject pluginEnabled = (JSONObject)formData.get("pluginEnabled");
            EasyQAPluginProperties ypp = null;
            if (pluginEnabled != null) {
                ypp = (EasyQAPluginProperties)((Object)req.bindJSON(EasyQAPluginProperties.class, pluginEnabled));
                if (ypp.siteName == null) {
                    return null;
                }
                ypp.setPluginEnabled(true);
            }
            return ypp;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) {
            this.sites.replaceBy((Collection)req.bindParametersToList(EasyQASite.class, "EasyQA."));
            this.save();
            return true;
        }

        public String getDisplayName() {
            return "EasyQA Plugin";
        }

        public FormValidation doTestConnection(@QueryParameter(value="EasyQA.url") String url, @QueryParameter(value="EasyQA.token") String token, @QueryParameter(value="EasyQA.email") String email, @QueryParameter(value="EasyQA.password") String password) {
            EasyQAServer easyQAServer = new EasyQAServer(url);
            if (email != null && !email.equals("")) {
                User login = easyQAServer.login(token, email, password);
                if (login != null && login.isLoggedIn()) {
                    return FormValidation.ok((String)"Connection ok!");
                }
                return FormValidation.error((String)"Could not login with given options");
            }
            return FormValidation.error((String)"Please, enter email");
        }
    }
}

