/*
 * Decompiled with CFR 0.152.
 */
package com.genonbeta.android.database;

import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteStatement;
import android.util.Log;
import com.genonbeta.android.database.DatabaseObject;
import com.genonbeta.android.database.SQLQuery;
import com.genonbeta.android.database.exception.ReconstructionFailedException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class SQLiteDatabase
extends SQLiteOpenHelper {
    public static final String TAG = SQLiteDatabase.class.getSimpleName();
    public static final String ACTION_DATABASE_CHANGE = "com.genonbeta.database.intent.action.DATABASE_CHANGE";
    public static final String EXTRA_BROADCAST_DATA = "extraBroadcastData";
    public static final String TYPE_REMOVE = "typeRemove";
    public static final String TYPE_INSERT = "typeInsert";
    public static final String TYPE_UPDATE = "typeUpdate";
    private final List<BroadcastData> mBroadcastOverhead = new ArrayList<BroadcastData>();
    private Context mContext;

    public SQLiteDatabase(Context context, String name, SQLiteDatabase.CursorFactory factory, int version) {
        super(context, name, factory, version);
        this.mContext = context;
    }

    public void bindContentValue(SQLiteStatement statement, int iteratorPosition, Object bindingObject) {
        if (bindingObject == null) {
            statement.bindNull(iteratorPosition);
        } else if (bindingObject instanceof Long) {
            statement.bindLong(iteratorPosition, ((Long)bindingObject).longValue());
        } else if (bindingObject instanceof Integer) {
            statement.bindLong(iteratorPosition, (long)((Integer)bindingObject).intValue());
        } else if (bindingObject instanceof Double) {
            statement.bindDouble(iteratorPosition, ((Double)bindingObject).doubleValue());
        } else if (bindingObject instanceof byte[]) {
            statement.bindBlob(iteratorPosition, (byte[])bindingObject);
        } else {
            statement.bindString(iteratorPosition, bindingObject instanceof String ? (String)bindingObject : String.valueOf(bindingObject));
        }
    }

    public <T extends DatabaseObject> List<T> castQuery(SQLQuery.Select select, Class<T> clazz) {
        return this.castQuery(select, clazz, null);
    }

    public <T extends DatabaseObject> List<T> castQuery(SQLQuery.Select select, Class<T> clazz, CastQueryListener<T> listener) {
        return this.castQuery(this.getReadableDatabase(), select, clazz, listener);
    }

    public <T extends DatabaseObject> List<T> castQuery(android.database.sqlite.SQLiteDatabase db, SQLQuery.Select select, Class<T> clazz, CastQueryListener<T> listener) {
        ArrayList<DatabaseObject> returnedList = new ArrayList<DatabaseObject>();
        List<ContentValues> itemList = this.getTable(db, select);
        try {
            for (ContentValues item : itemList) {
                DatabaseObject newClazz = (DatabaseObject)clazz.newInstance();
                newClazz.reconstruct(item);
                if (listener != null) {
                    listener.onObjectReconstructed(this, item, newClazz);
                }
                returnedList.add(newClazz);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        return returnedList;
    }

    public synchronized void append(android.database.sqlite.SQLiteDatabase dbInstance, String tableName, String changeType) {
        this.append(dbInstance, tableName, changeType, this.getAffectedRowCount(dbInstance));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void append(android.database.sqlite.SQLiteDatabase dbInstance, String tableName, String changeType, long affectedRows) {
        if (affectedRows <= 0L) {
            Log.e((String)TAG, (String)("Changelog is not added because there is no change. table: " + tableName + "; change: " + changeType + "; affected rows: " + affectedRows));
            return;
        }
        BroadcastData data = null;
        Object object = this.mBroadcastOverhead;
        synchronized (object) {
            for (BroadcastData testedData : this.mBroadcastOverhead) {
                if (!tableName.equals(testedData.tableName)) continue;
                data = testedData;
                break;
            }
            if (data == null) {
                data = new BroadcastData(tableName);
                this.mBroadcastOverhead.add(data);
            }
        }
        switch (changeType) {
            case "typeInsert": {
                data.inserted = true;
                break;
            }
            case "typeRemove": {
                data.removed = true;
                break;
            }
            case "typeUpdate": {
                data.updated = true;
            }
        }
        data.affectedRowCount = (int)((long)data.affectedRowCount + affectedRows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void broadcast() {
        List<BroadcastData> list = this.mBroadcastOverhead;
        synchronized (list) {
            for (BroadcastData data : this.mBroadcastOverhead) {
                this.getContext().sendBroadcast(new Intent(ACTION_DATABASE_CHANGE).putExtra(EXTRA_BROADCAST_DATA, (Serializable)data));
            }
            this.mBroadcastOverhead.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAffectedRowCount(android.database.sqlite.SQLiteDatabase database) {
        long returnCount = 0L;
        try (Cursor cursor = null;){
            cursor = database.rawQuery("SELECT changes() AS affected_row_count", null);
            if (cursor != null && cursor.getCount() > 0 && cursor.moveToFirst()) {
                returnCount = cursor.getLong(cursor.getColumnIndex("affected_row_count"));
            }
        }
        return returnCount;
    }

    public <T, V extends DatabaseObject<T>> Map<String, List<V>> explodePerTable(List<V> objects) {
        HashMap<String, List<ArrayList<DatabaseObject>>> tables = new HashMap<String, List<ArrayList<DatabaseObject>>>();
        for (DatabaseObject object : objects) {
            String tableName = object.getWhere().tableName;
            ArrayList<DatabaseObject> availTable = (ArrayList<DatabaseObject>)tables.get(tableName);
            if (availTable == null) {
                availTable = new ArrayList<DatabaseObject>();
                tables.put(tableName, availTable);
            }
            availTable.add(object);
        }
        return tables;
    }

    public Context getContext() {
        return this.mContext;
    }

    public ContentValues getFirstFromTable(SQLQuery.Select select) {
        return this.getFirstFromTable(this.getReadableDatabase(), select);
    }

    public ContentValues getFirstFromTable(android.database.sqlite.SQLiteDatabase db, SQLQuery.Select select) {
        List<ContentValues> list = this.getTable(db, select.setLimit(1));
        return list.size() > 0 ? list.get(0) : null;
    }

    public List<ContentValues> getTable(SQLQuery.Select select) {
        return this.getTable(this.getReadableDatabase(), select);
    }

    public List<ContentValues> getTable(android.database.sqlite.SQLiteDatabase db, SQLQuery.Select select) {
        ArrayList<ContentValues> list = new ArrayList<ContentValues>();
        Cursor cursor = db.query(select.tableName, select.columns, select.where, select.whereArgs, select.groupBy, select.having, select.orderBy, select.limit);
        if (cursor.moveToFirst()) {
            if (select.loadListener != null) {
                select.loadListener.onOpen(this, cursor);
            }
            do {
                ContentValues item = new ContentValues();
                for (int i = 0; i < cursor.getColumnCount(); ++i) {
                    item.put(cursor.getColumnName(i), cursor.getString(i));
                }
                if (select.loadListener != null) {
                    select.loadListener.onLoad(this, cursor, item);
                }
                list.add(item);
            } while (cursor.moveToNext());
        }
        cursor.close();
        return list;
    }

    public long insert(DatabaseObject object) {
        return this.insert(this.getWritableDatabase(), object, null);
    }

    public <T> long insert(android.database.sqlite.SQLiteDatabase db, DatabaseObject<T> object, T parent) {
        object.onCreateObject(db, this, parent);
        return this.insert(db, object.getWhere().tableName, null, object.getValues());
    }

    public long insert(android.database.sqlite.SQLiteDatabase db, String tableName, String nullColumnHack, ContentValues contentValues) {
        long insertedId = db.insert(tableName, nullColumnHack, contentValues);
        this.append(db, tableName, TYPE_INSERT, insertedId > -1L ? 1L : 0L);
        return insertedId;
    }

    public <T extends DatabaseObject> boolean insert(List<T> objects) {
        return this.insert(objects, null);
    }

    public <T extends DatabaseObject> boolean insert(List<T> objects, ProgressUpdater updater) {
        return this.insert(this.getWritableDatabase(), objects, updater, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, V extends DatabaseObject<T>> boolean insert(android.database.sqlite.SQLiteDatabase openDatabase, List<V> objects, ProgressUpdater updater, T parent) {
        int progress = 0;
        openDatabase.beginTransaction();
        try {
            for (DatabaseObject object : objects) {
                if (updater != null && !updater.onProgressChange(objects.size(), progress++)) break;
                this.insert(openDatabase, object, parent);
            }
            openDatabase.setTransactionSuccessful();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            openDatabase.endTransaction();
        }
        return false;
    }

    public int publish(DatabaseObject object) {
        return this.publish(this.getWritableDatabase(), object, null);
    }

    public <T> int publish(android.database.sqlite.SQLiteDatabase database, DatabaseObject<T> object, T parent) {
        int rowsChanged = this.update(database, object, parent);
        if (rowsChanged <= 0) {
            rowsChanged = this.insert(database, object, parent) >= -1L ? 1 : 0;
        }
        return rowsChanged;
    }

    public <T extends DatabaseObject> boolean publish(List<T> objects) {
        return this.publish(objects, null);
    }

    public <T extends DatabaseObject> boolean publish(List<T> objects, ProgressUpdater updater) {
        return this.publish(this.getWritableDatabase(), objects, updater, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, V extends DatabaseObject<T>> boolean publish(android.database.sqlite.SQLiteDatabase openDatabase, List<V> objects, ProgressUpdater updater, T parent) {
        int progress = 0;
        openDatabase.beginTransaction();
        try {
            for (DatabaseObject object : objects) {
                if (updater != null && !updater.onProgressChange(objects.size(), progress++)) break;
                this.publish(openDatabase, object, parent);
            }
            openDatabase.setTransactionSuccessful();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            openDatabase.endTransaction();
        }
        return false;
    }

    public void reconstruct(DatabaseObject object) throws ReconstructionFailedException {
        this.reconstruct(this.getReadableDatabase(), object);
    }

    public void reconstruct(android.database.sqlite.SQLiteDatabase db, DatabaseObject object) throws ReconstructionFailedException {
        ContentValues item = this.getFirstFromTable(db, object.getWhere());
        if (item == null) {
            SQLQuery.Select select = object.getWhere();
            StringBuilder whereArgs = new StringBuilder();
            for (String arg : select.whereArgs) {
                if (whereArgs.length() > 0) {
                    whereArgs.append(", ");
                }
                whereArgs.append("[] ");
                whereArgs.append(arg);
            }
            throw new ReconstructionFailedException("No data was returned from: query; tableName: " + select.tableName + "; where: " + select.where + "; whereArgs: " + whereArgs.toString());
        }
        object.reconstruct(item);
    }

    public void remove(DatabaseObject object) {
        this.remove(this.getWritableDatabase(), object, null);
    }

    public <T> void remove(android.database.sqlite.SQLiteDatabase db, DatabaseObject<T> object, T parent) {
        object.onRemoveObject(db, this, parent);
        this.remove(db, object.getWhere());
    }

    public int remove(SQLQuery.Select select) {
        return this.remove(this.getWritableDatabase(), select);
    }

    public int remove(android.database.sqlite.SQLiteDatabase db, SQLQuery.Select select) {
        int affectedRows = db.delete(select.tableName, select.where, select.whereArgs);
        this.append(db, select.tableName, TYPE_REMOVE, affectedRows);
        return affectedRows;
    }

    public <T extends DatabaseObject> boolean remove(List<T> objects) {
        return this.remove(objects, null);
    }

    public <T extends DatabaseObject> boolean remove(List<T> objects, ProgressUpdater updater) {
        return this.remove(this.getWritableDatabase(), objects, updater, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, V extends DatabaseObject<T>> boolean remove(android.database.sqlite.SQLiteDatabase openDatabase, List<V> objects, ProgressUpdater updater, T parent) {
        int progress = 0;
        openDatabase.beginTransaction();
        try {
            for (DatabaseObject object : objects) {
                if (updater != null && !updater.onProgressChange(objects.size(), progress++)) break;
                this.remove(openDatabase, object, parent);
            }
            openDatabase.setTransactionSuccessful();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            openDatabase.endTransaction();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V, T extends DatabaseObject<V>> boolean removeAsObject(android.database.sqlite.SQLiteDatabase openDatabase, SQLQuery.Select select, Class<T> objectType, CastQueryListener<T> listener, ProgressUpdater updater, V parent) {
        int progress = 0;
        openDatabase.beginTransaction();
        try {
            List<T> objects = this.castQuery(openDatabase, select, objectType, listener);
            for (DatabaseObject object : objects) {
                if (updater != null && !updater.onProgressChange(objects.size(), progress++)) break;
                this.remove(openDatabase, object, parent);
            }
            openDatabase.setTransactionSuccessful();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            openDatabase.endTransaction();
        }
        return false;
    }

    public int update(DatabaseObject object) {
        return this.update(this.getWritableDatabase(), object, null);
    }

    public <T> int update(android.database.sqlite.SQLiteDatabase db, DatabaseObject<T> object, T parent) {
        object.onUpdateObject(db, this, parent);
        return this.update(db, object.getWhere(), object.getValues());
    }

    public int update(SQLQuery.Select select, ContentValues values) {
        return this.update(this.getWritableDatabase(), select, values);
    }

    public int update(android.database.sqlite.SQLiteDatabase database, SQLQuery.Select select, ContentValues values) {
        int rowsAffected = database.update(select.tableName, values, select.where, select.whereArgs);
        this.append(database, select.tableName, TYPE_UPDATE, rowsAffected);
        return rowsAffected;
    }

    public <T extends DatabaseObject> boolean update(List<T> objects) {
        return this.update(objects, null);
    }

    public <T extends DatabaseObject> boolean update(List<T> objects, ProgressUpdater updater) {
        return this.update(this.getWritableDatabase(), objects, updater, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, V extends DatabaseObject<T>> boolean update(android.database.sqlite.SQLiteDatabase openDatabase, List<V> objects, ProgressUpdater updater, T parent) {
        int progress = 0;
        openDatabase.beginTransaction();
        try {
            for (DatabaseObject object : objects) {
                if (updater != null && !updater.onProgressChange(objects.size(), progress++)) break;
                this.update(openDatabase, object, parent);
            }
            openDatabase.setTransactionSuccessful();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            openDatabase.endTransaction();
        }
        return false;
    }

    public static BroadcastData toData(Intent intent) {
        return (BroadcastData)intent.getSerializableExtra(EXTRA_BROADCAST_DATA);
    }

    public static class BroadcastData
    implements Serializable {
        public int affectedRowCount = 0;
        public boolean inserted = false;
        public boolean removed = false;
        public boolean updated = false;
        public String tableName;

        BroadcastData(String tableName) {
            this.tableName = tableName;
        }
    }

    public static interface ProgressUpdater {
        public boolean onProgressChange(int var1, int var2);
    }

    public static interface CastQueryListener<T extends DatabaseObject> {
        public void onObjectReconstructed(SQLiteDatabase var1, ContentValues var2, T var3);
    }
}

