/*
 * Decompiled with CFR 0.152.
 */
package com.genonbeta.android.database;

import java.util.HashMap;
import java.util.Map;

public class CursorItem {
    private Map<String, Object> mList = new HashMap<String, Object>();

    public CursorItem clear() {
        this.mList.clear();
        return this;
    }

    public boolean exists(String keyName) {
        return this.mList.containsKey(keyName) && this.mList.get(keyName) != null;
    }

    public boolean getBoolean(String keyName) {
        return Boolean.valueOf(this.getString(keyName));
    }

    public double getDouble(String keyName) {
        try {
            return Double.valueOf(this.getString(keyName));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public float getFloat(String keyName) {
        try {
            return Float.valueOf(this.getString(keyName)).floatValue();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    public int getInt(String keyName) {
        try {
            return Integer.valueOf(this.getString(keyName));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public long getLong(String keyName) {
        try {
            return Long.valueOf(this.getString(keyName));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public String getString(String keyName) {
        return this.mList.get(keyName) == null ? null : String.valueOf(this.mList.get(keyName));
    }

    public int length() {
        return this.mList.size();
    }

    public Map<String, Object> list() {
        return this.mList;
    }

    public CursorItem put(String keyName, Object object) {
        this.mList.put(keyName, object);
        return this;
    }

    public CursorItem putAll(CursorItem item) {
        this.list().putAll(item.list());
        return this;
    }

    public int size() {
        return this.mList.size();
    }
}

