/*
 * Decompiled with CFR 0.152.
 */
package com.genonbeta.android.framework.widget;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.util.AttributeSet;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.animation.AnimationUtils;
import com.genonbeta.android.framework.R;
import com.genonbeta.android.framework.object.Selectable;
import java.util.ArrayList;

public class PowerfulActionMode
extends Toolbar {
    private View mContainerLayout;
    private OnSelectionTaskListener mTaskListener;
    private MenuInflater mMenuInflater;
    private ArrayMap<Callback, Holder> mActiveActionModes = new ArrayMap();

    public PowerfulActionMode(Context context) {
        super(context);
        this.initialize();
    }

    public PowerfulActionMode(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initialize();
    }

    public PowerfulActionMode(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize();
    }

    public <T extends Selectable> boolean check(@NonNull Callback<T> callback, T selectable, boolean selected, int position) {
        if (!selectable.setSelectableSelected(selected)) {
            return false;
        }
        if (!this.hasActive(callback)) {
            this.start(callback);
        }
        if (selected) {
            this.getHolder(callback).getSelectionList().add(selectable);
        } else {
            this.getHolder(callback).getSelectionList().remove(selectable);
        }
        callback.onItemChecked(this.getContext(), this, selectable, position);
        return true;
    }

    public void finish(@NonNull Callback callback) {
        Holder holder = (Holder)this.mActiveActionModes.get((Object)callback);
        if (holder != null) {
            callback.onFinish(this.getContext(), this);
            this.mActiveActionModes.remove((Object)callback);
            this.reload(callback);
        }
    }

    public boolean hasActive(Callback callback) {
        return this.mActiveActionModes.containsKey((Object)callback);
    }

    public View getContainerLayout() {
        return this.mContainerLayout;
    }

    public MenuInflater getMenuInflater() {
        return this.mMenuInflater;
    }

    public <T extends Selectable> Holder<T> getHolder(Callback<T> callback) {
        return (Holder)this.mActiveActionModes.get(callback);
    }

    protected void initialize() {
        this.mContainerLayout = this;
        this.mMenuInflater = new MenuInflater(this.getContext());
    }

    public boolean reload(final Callback callback) {
        this.getMenu().clear();
        if (callback == null || !this.mActiveActionModes.containsKey((Object)callback)) {
            this.updateVisibility(8);
            this.finish(callback);
            return false;
        }
        this.updateVisibility(0);
        this.setNavigationIcon(R.drawable.genfw_close_black_24dp);
        this.setNavigationContentDescription(0x1040000);
        this.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PowerfulActionMode.this.finish(callback);
            }
        });
        boolean result = callback.onCreateActionMenu(this.getContext(), this, this.getMenu());
        if (result) {
            MenuItem.OnMenuItemClickListener defListener = new MenuItem.OnMenuItemClickListener(){

                public boolean onMenuItemClick(MenuItem menuItem) {
                    boolean didTrigger = callback.onActionMenuItemSelected(PowerfulActionMode.this.getContext(), PowerfulActionMode.this, menuItem);
                    if (didTrigger) {
                        PowerfulActionMode.this.finish(callback);
                    }
                    return didTrigger;
                }
            };
            for (int menuPos = 0; menuPos < this.getMenu().size(); ++menuPos) {
                this.getMenu().getItem(menuPos).setOnMenuItemClickListener(defListener);
            }
        }
        return result;
    }

    public void setContainerLayout(View containerLayout) {
        this.mContainerLayout = containerLayout;
    }

    public void setOnSelectionTaskListener(OnSelectionTaskListener taskListener) {
        this.mTaskListener = taskListener;
    }

    public <T extends Selectable> boolean start(@NonNull Callback<T> callback) {
        return this.start(callback, false);
    }

    public <T extends Selectable> boolean start(@NonNull Callback<T> callback, boolean forceStart) {
        if (!callback.onPrepareActionMenu(this.getContext(), this) || this.mActiveActionModes.containsKey(callback) && !forceStart) {
            this.finish(callback);
            return false;
        }
        this.mActiveActionModes.put(callback, new Holder());
        return this.reload(callback);
    }

    protected void updateVisibility(int visibility) {
        PowerfulActionMode view;
        int animationId = visibility == 0 ? 0x10A0000 : 0x10A0001;
        PowerfulActionMode powerfulActionMode = view = this.getContainerLayout() == null ? this : this.getContainerLayout();
        if (visibility == 0) {
            view.setVisibility(visibility);
            view.setAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)animationId));
            if (this.mTaskListener != null) {
                this.mTaskListener.onSelectionTask(true, this);
            }
        } else {
            view.setAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)animationId));
            view.setVisibility(visibility);
            if (this.mTaskListener != null) {
                this.mTaskListener.onSelectionTask(false, this);
            }
        }
    }

    public static interface OnSelectionTaskListener {
        public void onSelectionTask(boolean var1, PowerfulActionMode var2);
    }

    public static class Holder<T extends Selectable> {
        private final ArrayList<T> mSelectionList = new ArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ArrayList<T> getSelectionList() {
            ArrayList<T> arrayList = this.mSelectionList;
            synchronized (arrayList) {
                return this.mSelectionList;
            }
        }
    }

    public static class SelectorConnection<T extends Selectable> {
        private PowerfulActionMode mMode;
        private Callback<T> mCallback;

        public SelectorConnection(PowerfulActionMode mode, Callback<T> callback) {
            this.mMode = mode;
            this.mCallback = callback;
        }

        public Callback<T> getCallback() {
            return this.mCallback;
        }

        public PowerfulActionMode getMode() {
            return this.mMode;
        }

        public ArrayList<T> getSelectedItemList() {
            Holder<T> holder = this.getMode().getHolder(this.getCallback());
            return holder == null ? new ArrayList<T>() : holder.getSelectionList();
        }

        public boolean isSelected(T selectable) {
            Holder<T> holder = this.getMode().getHolder(this.getCallback());
            return holder != null && holder.getSelectionList().contains(selectable);
        }

        public boolean selectionActive() {
            return this.getMode().hasActive(this.getCallback());
        }

        public boolean setSelected(RecyclerView.ViewHolder holder) {
            return this.setSelected(holder.getAdapterPosition());
        }

        public boolean setSelected(int position) {
            return this.setSelected((Selectable)this.getCallback().getSelectableList().get(position), position);
        }

        public boolean setSelected(T selectable) {
            return this.setSelected(selectable, !this.isSelected(selectable), -1);
        }

        public boolean setSelected(T selectable, boolean selected) {
            return this.setSelected(selectable, selected, -1);
        }

        public boolean setSelected(T selectable, @Nullable int position) {
            return this.setSelected(selectable, !this.isSelected(selectable), position);
        }

        public boolean setSelected(T selectable, boolean selected, @Nullable int position) {
            if (selected == this.isSelected(selectable)) {
                return selected;
            }
            return this.getMode().check(this.getCallback(), selectable, selected, position);
        }

        public boolean removeSelected(T selectable) {
            if (!this.getMode().hasActive(this.getCallback())) {
                return false;
            }
            return this.getMode().getHolder(this.getCallback()).getSelectionList().remove(selectable);
        }
    }

    public static interface Callback<T extends Selectable> {
        public ArrayList<T> getSelectableList();

        public boolean onPrepareActionMenu(Context var1, PowerfulActionMode var2);

        public boolean onCreateActionMenu(Context var1, PowerfulActionMode var2, Menu var3);

        public boolean onActionMenuItemSelected(Context var1, PowerfulActionMode var2, MenuItem var3);

        public void onItemChecked(Context var1, PowerfulActionMode var2, T var3, int var4);

        public void onFinish(Context var1, PowerfulActionMode var2);
    }
}

