/*
 * Decompiled with CFR 0.152.
 */
package com.genonbeta.android.framework.util.actionperformer;

import com.genonbeta.android.framework.object.Selectable;
import com.genonbeta.android.framework.util.actionperformer.IBaseEngineConnection;
import com.genonbeta.android.framework.util.actionperformer.IEngineConnection;
import com.genonbeta.android.framework.util.actionperformer.IPerformerEngine;
import com.genonbeta.android.framework.util.actionperformer.PerformerCallback;
import com.genonbeta.android.framework.util.actionperformer.PerformerEngineProvider;
import com.genonbeta.android.framework.util.actionperformer.PerformerListener;
import java.util.ArrayList;
import java.util.List;

public class PerformerEngine
implements IPerformerEngine {
    private final List<IBaseEngineConnection> mConnectionList = new ArrayList<IBaseEngineConnection>();
    private final List<PerformerCallback> mPerformerCallbackList = new ArrayList<PerformerCallback>();
    private final List<PerformerListener> mPerformerListenerList = new ArrayList<PerformerListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Selectable> boolean check(IEngineConnection<T> engineConnection, T selectable, boolean isSelected, int position) {
        List<PerformerCallback> list = this.mPerformerCallbackList;
        synchronized (list) {
            for (PerformerCallback callback : this.mPerformerCallbackList) {
                if (callback.onSelection((IPerformerEngine)this, engineConnection, selectable, isSelected, position)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Selectable> boolean check(IEngineConnection<T> engineConnection, List<T> selectableList, boolean isSelected, int[] positions) {
        List<PerformerCallback> list = this.mPerformerCallbackList;
        synchronized (list) {
            for (PerformerCallback callback : this.mPerformerCallbackList) {
                if (callback.onSelection((IPerformerEngine)this, engineConnection, selectableList, isSelected, positions)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<? extends Selectable> getSelectionList() {
        ArrayList<? extends Selectable> selectableList = new ArrayList<Selectable>();
        List<IBaseEngineConnection> list = this.mConnectionList;
        synchronized (list) {
            for (IBaseEngineConnection baseEngineConnection : this.mConnectionList) {
                selectableList.addAll(baseEngineConnection.getGenericSelectedItemList());
            }
        }
        return selectableList;
    }

    @Override
    public List<IBaseEngineConnection> getConnectionList() {
        return new ArrayList<IBaseEngineConnection>(this.mConnectionList);
    }

    @Override
    public boolean hasActiveSlots() {
        return this.mConnectionList.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ensureSlot(PerformerEngineProvider provider, IBaseEngineConnection selectionConnection) {
        List<IBaseEngineConnection> list = this.mConnectionList;
        synchronized (list) {
            if (this.mConnectionList.contains(selectionConnection) || this.mConnectionList.add(selectionConnection)) {
                if (selectionConnection.getEngineProvider() != provider) {
                    selectionConnection.setEngineProvider(provider);
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Selectable> void informListeners(IEngineConnection<T> engineConnection, T selectable, boolean isSelected, int position) {
        List<PerformerListener> list = this.mPerformerListenerList;
        synchronized (list) {
            for (PerformerListener listener : this.mPerformerListenerList) {
                listener.onSelected((IPerformerEngine)this, engineConnection, selectable, isSelected, position);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Selectable> void informListeners(IEngineConnection<T> engineConnection, List<T> selectableList, boolean isSelected, int[] positions) {
        List<PerformerListener> list = this.mPerformerListenerList;
        synchronized (list) {
            for (PerformerListener listener : this.mPerformerListenerList) {
                listener.onSelected((IPerformerEngine)this, engineConnection, selectableList, isSelected, positions);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeSlot(IBaseEngineConnection selectionConnection) {
        List<IBaseEngineConnection> list = this.mConnectionList;
        synchronized (list) {
            return this.mConnectionList.remove(selectionConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSlots() {
        List<IBaseEngineConnection> list = this.mConnectionList;
        synchronized (list) {
            this.mConnectionList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addPerformerCallback(PerformerCallback callback) {
        List<PerformerCallback> list = this.mPerformerCallbackList;
        synchronized (list) {
            return this.mPerformerCallbackList.contains(callback) || this.mPerformerCallbackList.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addPerformerListener(PerformerListener listener) {
        List<PerformerListener> list = this.mPerformerListenerList;
        synchronized (list) {
            return this.mPerformerListenerList.contains(listener) || this.mPerformerListenerList.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removePerformerCallback(PerformerCallback listener) {
        List<PerformerCallback> list = this.mPerformerCallbackList;
        synchronized (list) {
            return this.mPerformerCallbackList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removePerformerListener(PerformerListener listener) {
        List<PerformerListener> list = this.mPerformerListenerList;
        synchronized (list) {
            return this.mPerformerListenerList.remove(listener);
        }
    }
}

